/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.descriptor;

import com.meidusa.toolkit.plugins.autoconfig.ConfigException;
import com.meidusa.toolkit.plugins.autoconfig.ConfigResource;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigDescriptor;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigGenerate;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigGroup;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigProperty;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;
import org.apache.commons.digester.Rules;
import org.apache.commons.digester.plugins.PluginCreateRule;
import org.apache.commons.digester.plugins.PluginDeclarationRule;
import org.apache.commons.digester.plugins.PluginRules;

public class ConfigDescriptorLoader {
    public synchronized ConfigDescriptor load(ConfigResource descriptorResource, InputStream istream) {
        Digester digester = this.getDigester();
        digester.push((Object)new ConfigDescriptor(descriptorResource));
        try {
            return (ConfigDescriptor)digester.parse(istream);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigException("Failed to load config descriptor: " + descriptorResource.getURL() + "\n", e);
        }
    }

    public synchronized Map loadValidatorClasses() {
        Digester digester = this.loadValidatorPlugins();
        return (Map)digester.pop();
    }

    protected Digester getDigester() {
        Digester digester = this.loadValidatorPlugins();
        digester.addSetProperties("config");
        digester.addObjectCreate("config/group", ConfigGroup.class);
        digester.addSetProperties("config/group");
        digester.addSetNext("config/group", "addGroup");
        digester.addObjectCreate("config/group/property", ConfigProperty.class);
        digester.addSetProperties("config/group/property");
        digester.addCallMethod("config/group/property", "afterPropertiesSet");
        digester.addSetNext("config/group/property", "addProperty");
        PluginCreateRule pcr = new PluginCreateRule(ConfigValidator.class);
        pcr.setPluginIdAttribute(null, "name");
        digester.addRule("config/group/property/validator", (Rule)pcr);
        digester.addSetNext("config/group/property/validator", "addValidator");
        digester.addObjectCreate("config/script/generate", ConfigGenerate.class);
        digester.addSetProperties("config/script/generate");
        digester.addSetNext("config/script/generate", "addGenerate");
        digester.clear();
        return digester;
    }

    private Digester loadValidatorPlugins() {
        Digester digester = new Digester();
        digester.setRules((Rules)new PluginRules());
        digester.addObjectCreate("config-property-validators", HashMap.class);
        digester.addCallMethod("config-property-validators/validator", "put", 2);
        digester.addCallParam("config-property-validators/validator", 0, "id");
        digester.addCallParam("config-property-validators/validator", 1, "class");
        digester.addRule("config-property-validators/validator", (Rule)new PluginDeclarationRule());
        InputStream istream = this.getClass().getResourceAsStream("validators.xml");
        try {
            digester.push(digester.parse(istream));
        }
        catch (Exception e) {
            throw new ConfigException("Failed to load validators", e);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException e) {}
            }
        }
        digester.getRules().clear();
        return digester;
    }
}

