/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.dependency;

import com.meidusa.toolkit.plugins.autoconfig.DependencyInfo;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DependencyFilter {
    private Pattern groupPattern;
    private Pattern artifactPattern;

    private DependencyFilter() {
    }

    public static DependencyFilter compile(DependencyInfo info) {
        DependencyFilter filter = new DependencyFilter();
        filter.groupPattern = Pattern.compile(info.getGroupId());
        filter.artifactPattern = Pattern.compile(info.getArtifactId());
        return filter;
    }

    public boolean match(String groupId, String artifactId) {
        Matcher groupMatcher = this.groupPattern.matcher(groupId);
        if (groupMatcher.matches()) {
            Matcher artifactMatcher = this.artifactPattern.matcher(artifactId);
            return artifactMatcher.matches();
        }
        return false;
    }
}

