/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.entry;

import com.meidusa.toolkit.plugins.autoconfig.ConfigException;
import com.meidusa.toolkit.plugins.autoconfig.ConfigResource;
import com.meidusa.toolkit.plugins.autoconfig.ConfigSettings;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigDescriptor;
import com.meidusa.toolkit.plugins.autoconfig.entry.ConfigEntry;
import com.meidusa.toolkit.plugins.autoconfig.generator.ConfigGeneratorCallback;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.ScannerException;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.ScannerHandler;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.ZipScanner;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipConfigEntry
extends ConfigEntry {
    public ZipConfigEntry(ConfigResource resource, ConfigSettings settings) {
        super(resource, settings);
    }

    @Override
    protected void scan(InputStream istream) {
        ConfigEntry.Handler handler = new ConfigEntry.Handler();
        ZipScanner scanner = new ZipScanner(this.getConfigEntryResource().getURL(), (ScannerHandler)handler);
        scanner.setInputStream(istream);
        try {
            scanner.scan();
        }
        catch (ScannerException e) {
            throw new ConfigException((Throwable)((Object)e));
        }
        this.subEntries = handler.getSubEntries();
        this.getGenerator().init();
    }

    @Override
    protected void generate(InputStream istream, OutputStream ostream) {
        boolean needCloseOutputStream = false;
        boolean needCloseInputStream = false;
        boolean success = false;
        File destfile = null;
        File tempfile = null;
        this.getConfigSettings().debug("Processing files in " + this.getConfigEntryResource());
        ZipInputStream zis = null;
        ZipOutputStream zos = null;
        try {
            try {
                ZipEntry zipEntry;
                if (ostream == null) {
                    destfile = this.getConfigEntryResource().getFile();
                    if (destfile == null || !destfile.exists()) {
                        throw new ConfigException("Could not find " + this.getConfigEntryResource().getURL());
                    }
                    tempfile = new File(destfile.getParentFile(), String.valueOf(destfile.getName()) + ".tmp");
                    ostream = new BufferedOutputStream(new FileOutputStream(tempfile), 8192);
                    needCloseOutputStream = true;
                }
                if (istream == null) {
                    istream = this.getConfigEntryResource().getURL().openStream();
                    if (!(istream instanceof BufferedInputStream)) {
                        istream = new BufferedInputStream(istream, 8192);
                    }
                    needCloseInputStream = true;
                }
                zis = new ZipInputStream(istream);
                zos = new ZipOutputStream(ostream);
                File propsFile = this.getConfigSettings().getUserPropertiesFile();
                String propsFileCharset = this.getConfigSettings().getUserPropertiesFileCharset();
                this.getGenerator().startSession(propsFile, propsFileCharset);
                while ((zipEntry = zis.getNextEntry()) != null) {
                    this.processZipEntry(zipEntry, zis, zos);
                }
                this.getGenerator().getSession().checkNonprocessedTemplates();
                success = true;
            }
            catch (IOException e) {
                throw new ConfigException(e);
            }
        }
        finally {
            this.getGenerator().closeSession();
            if (zos != null) {
                try {
                    zos.finish();
                }
                catch (IOException iOException) {}
            }
            if (needCloseInputStream && istream != null) {
                try {
                    istream.close();
                }
                catch (IOException iOException) {}
            }
            if (needCloseOutputStream && ostream != null) {
                try {
                    ostream.flush();
                    ostream.close();
                }
                catch (IOException iOException) {}
                if (success) {
                    destfile.delete();
                    tempfile.renameTo(destfile);
                } else {
                    tempfile.delete();
                }
            }
        }
    }

    private void processZipEntry(ZipEntry zipEntry, ZipInputStream zis, ZipOutputStream zos) throws IOException {
        String name = zipEntry.getName();
        ConfigEntry subEntry = this.getSubEntry(name);
        if (subEntry != null) {
            ZipEntry zipEntryToWrite = new ZipEntry(zipEntry.getName());
            zos.putNextEntry(zipEntryToWrite);
            subEntry.generate(zis, zos);
        } else if (this.getGenerator().isTemplateFile(name)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.io(zis, baos);
            byte[] bytes = baos.toByteArray();
            this.copyZipEntry(zipEntry, new ByteArrayInputStream(bytes), zos);
            this.getGenerator().getSession().generate(name, new ZipCallback(bytes, zos));
        } else if (!this.getGenerator().isDestFile(name) && !this.getGenerator().isDescriptorLogFile(name)) {
            this.copyZipEntry(zipEntry, zis, zos);
        }
    }

    private void copyZipEntry(ZipEntry zipEntry, InputStream istream, ZipOutputStream zos) throws IOException {
        zos.putNextEntry(new ZipEntry(zipEntry));
        if (!zipEntry.isDirectory()) {
            this.io(istream, zos);
        }
    }

    private void io(InputStream in, OutputStream out) throws IOException {
        int amount;
        byte[] buffer = new byte[8192];
        while ((amount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, amount);
        }
    }

    private ConfigEntry getSubEntry(String name) {
        ConfigEntry[] entries = this.getSubEntries();
        int i = 0;
        while (i < entries.length) {
            ConfigEntry subEntry = entries[i];
            if (subEntry.getName().equals(name.replace('\\', '/'))) {
                return subEntry;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return "ZipConfigEntry[" + this.getConfigEntryResource() + "]";
    }

    private final class ZipCallback
    implements ConfigGeneratorCallback {
        private final byte[] bytes;
        private final ZipOutputStream zos;

        private ZipCallback(ZipOutputStream zos) {
            this(null, zos);
        }

        private ZipCallback(byte[] bytes, ZipOutputStream zos) {
            this.bytes = bytes;
            this.zos = zos;
        }

        @Override
        public void nextEntry(ConfigDescriptor descriptor, String template, String dest) {
            try {
                this.zos.putNextEntry(new ZipEntry(dest));
            }
            catch (IOException e) {
                throw new ConfigException(e);
            }
            ZipConfigEntry.this.getGenerator().getSession().setInputStream(new ByteArrayInputStream(this.bytes));
            ZipConfigEntry.this.getGenerator().getSession().setOutputStream(this.zos);
        }

        @Override
        public void logEntry(ConfigDescriptor descriptor, String logfileName) {
            try {
                this.zos.putNextEntry(new ZipEntry(logfileName));
            }
            catch (IOException e) {
                throw new ConfigException(e);
            }
            ZipConfigEntry.this.getGenerator().getSession().setOutputStream(this.zos);
        }

        @Override
        public void closeEntry() {
        }
    }
}

