/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.descriptor;

import com.meidusa.toolkit.plugins.autoconfig.ConfigResource;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigGenerate;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigGroup;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ConfigDescriptor {
    private ConfigResource resource;
    private String description;
    private List groups = new LinkedList();
    private List generates = new LinkedList();
    private Map context = new HashMap();

    public ConfigDescriptor(ConfigResource descriptorResource) {
        this.resource = descriptorResource;
    }

    public ConfigResource getConfigResource() {
        return this.resource;
    }

    public ConfigResource getConfigResourceBase() {
        return this.getConfigResource().getBase();
    }

    public File getFile() {
        return this.resource.getFile();
    }

    public File getBaseFile() {
        return this.getConfigResourceBase().getFile();
    }

    public URL getURL() {
        return this.resource.getURL();
    }

    public URL getBaseURL() {
        return this.getConfigResourceBase().getURL();
    }

    public String getName() {
        return this.resource.getName();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addGroup(ConfigGroup group) {
        group.setConfigDescriptor(this);
        this.groups.add(group);
    }

    public ConfigGroup[] getGroups() {
        return this.groups.toArray(new ConfigGroup[this.groups.size()]);
    }

    public void setGroups(List list) {
        this.groups = list;
    }

    public void addGenerate(ConfigGenerate generate) {
        generate.setConfigDescriptor(this);
        this.generates.add(generate);
    }

    public void removeGenerate(ConfigGenerate generate) {
        this.generates.remove(generate);
    }

    public ConfigGenerate[] getGenerates() {
        return this.generates.toArray(new ConfigGenerate[this.generates.size()]);
    }

    public void setGenerates(List list) {
        this.generates = list;
    }

    public Map getContext() {
        return this.context;
    }

    public String toString() {
        return "Descriptor[" + (this.getURL() == null ? "" : this.getURL().toExternalForm()) + "]";
    }
}

