/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.util.scanner;

import com.meidusa.toolkit.plugins.autoconfig.util.FileUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.AbstractScanner;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.ScannerException;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.ScannerHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class DirectoryScanner
extends AbstractScanner {
    private File basedir;
    private URL baseURL;
    private boolean followSymlinks = true;

    public DirectoryScanner(File basedir, ScannerHandler handler) {
        super(handler);
        if (!basedir.exists() || !basedir.isDirectory()) {
            throw new IllegalArgumentException(basedir + " is not a directory");
        }
        try {
            this.baseURL = basedir.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(basedir + " is not a directory");
        }
        this.basedir = basedir;
    }

    public File getBasedir() {
        return this.basedir;
    }

    @Override
    public URL getBaseURL() {
        return this.baseURL;
    }

    @Override
    public URL getURL() {
        try {
            return new File(this.getBasedir(), this.getPath()).toURL();
        }
        catch (MalformedURLException e) {
            throw new ScannerException(e);
        }
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new FileInputStream(new File(this.getBasedir(), this.getPath()));
        }
        catch (FileNotFoundException e) {
            throw new ScannerException(e);
        }
    }

    public boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    @Override
    public void scan() {
        HashSet processed = new HashSet();
        this.getScannerHandler().setScanner(this);
        this.getScannerHandler().startScanning();
        this.scandir(this.getBasedir(), processed);
        this.getScannerHandler().endScanning();
    }

    protected void scandir(File dir, Set processed) {
        try {
            String canonicalPath = dir.getCanonicalPath();
            if (processed.contains(canonicalPath)) {
                return;
            }
            processed.add(canonicalPath);
        }
        catch (IOException e) {
            throw new ScannerException(e);
        }
        String[] files = dir.list();
        if (files == null) {
            throw new ScannerException("IO error scanning directory " + dir.getAbsolutePath());
        }
        if (!this.followSymlinks) {
            ArrayList<String> noLinks = new ArrayList<String>(files.length);
            int i = 0;
            while (i < files.length) {
                try {
                    if (!FileUtil.isSymbolicLink(dir, files[i])) {
                        noLinks.add(files[i]);
                    }
                }
                catch (IOException e) {
                    System.err.println("IOException caught while checking for links, couldn't get cannonical path!");
                    noLinks.add(files[i]);
                }
                ++i;
            }
            files = noLinks.toArray(new String[noLinks.size()]);
        }
        int i = 0;
        while (i < files.length) {
            String savedPath;
            String name = String.valueOf(this.getPath()) + files[i];
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                savedPath = this.setPath(String.valueOf(name) + '/');
                this.getScannerHandler().directory();
                if (this.getScannerHandler().followUp()) {
                    this.scandir(file, processed);
                }
            } else {
                savedPath = this.setPath(name);
                this.getScannerHandler().file();
            }
            this.setPath(savedPath);
            ++i;
        }
    }
}

