/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.util.i18n;

import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.i18n.UnsupportedLocaleException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class LocaleInfo {
    private static final String DEFAULT_LOCALE = "china";
    private static final Map LOCALE_MAP = new HashMap();
    private static LocaleInfo defaultLocaleInfo;
    private String name;
    private Locale locale;
    private String charset;

    static {
        LOCALE_MAP.put("us", new LocaleInfo("US", Locale.US, "ISO-8859-1"));
        LOCALE_MAP.put(DEFAULT_LOCALE, new LocaleInfo("China", Locale.CHINA, "GBK"));
        try {
            LocaleInfo.setDefault(DEFAULT_LOCALE);
        }
        catch (UnsupportedLocaleException e) {
            throw new InternalError();
        }
    }

    public LocaleInfo(String name, Locale locale, String charset) {
        this.name = name;
        this.locale = locale;
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getName() {
        return this.name;
    }

    public ResourceBundle getBundle(String bundleName) {
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, this.getLocale());
        if (!this.getLocale().toString().startsWith(bundle.getLocale().toString())) {
            bundle = ResourceBundle.getBundle(bundleName, new Locale("", "", ""));
        }
        return bundle;
    }

    public static void setDefault(String name) throws UnsupportedLocaleException {
        LocaleInfo locale = LocaleInfo.get(name);
        if (locale == null) {
            throw new UnsupportedLocaleException("Unsupported locale \"" + name + "\"");
        }
        defaultLocaleInfo = locale;
    }

    public static LocaleInfo getDefault() {
        return defaultLocaleInfo;
    }

    public static LocaleInfo get(String name) {
        if (name == null) {
            return null;
        }
        LocaleInfo localeInfo = (LocaleInfo)LOCALE_MAP.get(name.toLowerCase());
        if (localeInfo == null) {
            int index = name.indexOf(":");
            String localeName = null;
            String charsetName = null;
            if (index >= 0) {
                localeName = name.substring(0, index).trim();
                charsetName = name.substring(index + 1).trim();
            } else {
                localeName = name.trim();
            }
            Locale locale = null;
            if (localeName != null) {
                String[] localeParts = StringUtil.split(localeName, "_");
                if (localeParts.length == 1) {
                    locale = new Locale(localeParts[0]);
                }
                if (localeParts.length == 2) {
                    locale = new Locale(localeParts[0], localeParts[1]);
                }
                if (localeParts.length == 3) {
                    locale = new Locale(localeParts[0], localeParts[1], localeParts[2]);
                }
                if (locale == null) {
                    return null;
                }
            }
            localeInfo = new LocaleInfo(name, locale, charsetName);
        }
        return localeInfo;
    }
}

