/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.util.cli;

import com.meidusa.toolkit.plugins.autoconfig.util.cli.Option;

public class OptionBuilder {
    private String longopt;
    private String description;
    private String argName;
    private boolean required;
    private int numberOfArgs = -1;
    private Object type;
    private boolean optionalArg;
    private char valuesep;

    private void reset() {
        this.description = null;
        this.argName = null;
        this.longopt = null;
        this.type = null;
        this.required = false;
        this.numberOfArgs = -1;
        this.optionalArg = false;
        this.valuesep = '\u0000';
    }

    public OptionBuilder withLongOpt(String longopt) {
        this.longopt = longopt;
        return this;
    }

    public OptionBuilder hasArg() {
        this.numberOfArgs = 1;
        return this;
    }

    public OptionBuilder hasArg(boolean hasArg) {
        this.numberOfArgs = hasArg ? 1 : -1;
        return this;
    }

    public OptionBuilder withArgName(String name) {
        this.argName = name;
        return this;
    }

    public OptionBuilder isRequired() {
        this.required = true;
        return this;
    }

    public OptionBuilder withValueSeparator(char sep) {
        this.valuesep = sep;
        return this;
    }

    public OptionBuilder withValueSeparator() {
        this.valuesep = (char)61;
        return this;
    }

    public OptionBuilder isRequired(boolean required) {
        this.required = required;
        return this;
    }

    public OptionBuilder hasArgs() {
        this.numberOfArgs = -2;
        return this;
    }

    public OptionBuilder hasArgs(int num) {
        this.numberOfArgs = num;
        return this;
    }

    public OptionBuilder hasOptionalArg() {
        this.numberOfArgs = 1;
        this.optionalArg = true;
        return this;
    }

    public OptionBuilder hasOptionalArgs() {
        this.numberOfArgs = -2;
        this.optionalArg = true;
        return this;
    }

    public OptionBuilder hasOptionalArgs(int numArgs) {
        this.numberOfArgs = numArgs;
        this.optionalArg = true;
        return this;
    }

    public OptionBuilder withType(Object type) {
        this.type = type;
        return this;
    }

    public OptionBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public Option create(char opt) throws IllegalArgumentException {
        return this.create(String.valueOf(opt));
    }

    public Option create() throws IllegalArgumentException {
        if (this.longopt == null) {
            throw new IllegalArgumentException("must specify longopt");
        }
        return this.create(" ");
    }

    public Option create(String opt) throws IllegalArgumentException {
        Option option = new Option(opt, this.description);
        option.setLongOpt(this.longopt);
        option.setRequired(this.required);
        option.setOptionalArg(this.optionalArg);
        option.setArgs(this.numberOfArgs);
        option.setType(this.type);
        option.setValueSeparator(this.valuesep);
        option.setArgName(this.argName);
        this.reset();
        return option;
    }
}

