/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.util.cli;

import java.util.ArrayList;
import java.util.List;

public class Option
implements Cloneable {
    public static final int UNINITIALIZED = -1;
    public static final int UNLIMITED_VALUES = -2;
    private String opt;
    private String longOpt;
    private boolean hasArg;
    private String argName;
    private String description;
    private boolean required;
    private boolean optionalArg;
    private int numberOfArgs = -1;
    private Object type;
    private ArrayList values = new ArrayList();
    private char id;
    private char valuesep;

    private void validateOption(String opt) throws IllegalArgumentException {
        if (opt == null) {
            throw new IllegalArgumentException("opt is null");
        }
        if (opt.length() == 1) {
            char ch = opt.charAt(0);
            if (!this.isValidOpt(ch)) {
                throw new IllegalArgumentException("illegal option value '" + ch + "'");
            }
            this.id = ch;
        } else {
            char[] chars = opt.toCharArray();
            int i = 0;
            while (i < chars.length) {
                if (!this.isValidChar(chars[i])) {
                    throw new IllegalArgumentException("opt contains illegal character value '" + chars[i] + "'");
                }
                ++i;
            }
        }
    }

    private boolean isValidOpt(char c) {
        return this.isValidChar(c) || c == ' ' || c == '?' || c == '@';
    }

    private boolean isValidChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public int getId() {
        return this.id;
    }

    public Option(String opt, String description) throws IllegalArgumentException {
        this(opt, null, false, description);
    }

    public Option(String opt, boolean hasArg, String description) throws IllegalArgumentException {
        this(opt, null, hasArg, description);
    }

    public Option(String opt, String longOpt, boolean hasArg, String description) throws IllegalArgumentException {
        this.validateOption(opt);
        this.opt = opt;
        this.longOpt = longOpt;
        if (hasArg) {
            this.numberOfArgs = 1;
        }
        this.hasArg = hasArg;
        this.description = description;
    }

    public String getOpt() {
        return this.opt;
    }

    public Object getType() {
        return this.type;
    }

    public void setType(Object type) {
        this.type = type;
    }

    public String getLongOpt() {
        return this.longOpt;
    }

    public void setLongOpt(String longOpt) {
        this.longOpt = longOpt;
    }

    public void setOptionalArg(boolean optionalArg) {
        this.optionalArg = optionalArg;
    }

    public boolean hasOptionalArg() {
        return this.optionalArg;
    }

    public boolean hasLongOpt() {
        return this.longOpt != null;
    }

    public boolean hasArg() {
        return this.numberOfArgs > 0 || this.numberOfArgs == -2;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setArgName(String argName) {
        this.argName = argName;
    }

    public String getArgName() {
        return this.argName;
    }

    public boolean hasArgName() {
        return this.argName != null && this.argName.length() > 0;
    }

    public boolean hasArgs() {
        return this.numberOfArgs > 1 || this.numberOfArgs == -2;
    }

    public void setArgs(int num) {
        this.numberOfArgs = num;
    }

    public void setValueSeparator(char sep) {
        this.valuesep = sep;
    }

    public char getValueSeparator() {
        return this.valuesep;
    }

    public int getArgs() {
        return this.numberOfArgs;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer().append("[ option: ");
        buf.append(this.opt);
        if (this.longOpt != null) {
            buf.append(" ").append(this.longOpt);
        }
        buf.append(" ");
        if (this.hasArg) {
            buf.append("+ARG");
        }
        buf.append(" :: ").append(this.description);
        if (this.type != null) {
            buf.append(" :: ").append(this.type);
        }
        buf.append(" ]");
        return buf.toString();
    }

    public boolean addValue(String value) {
        switch (this.numberOfArgs) {
            case -1: {
                return false;
            }
            case -2: {
                if (this.getValueSeparator() > '\u0000') {
                    int index = 0;
                    while ((index = value.indexOf(this.getValueSeparator())) != -1) {
                        this.values.add(value.substring(0, index));
                        value = value.substring(index + 1);
                    }
                }
                this.values.add(value);
                return true;
            }
        }
        if (this.getValueSeparator() > '\u0000') {
            int index = 0;
            while ((index = value.indexOf(this.getValueSeparator())) != -1) {
                if (this.values.size() > this.numberOfArgs - 1) {
                    return false;
                }
                this.values.add(value.substring(0, index));
                value = value.substring(index + 1);
            }
        }
        if (this.values.size() > this.numberOfArgs - 1) {
            return false;
        }
        this.values.add(value);
        return true;
    }

    public String getValue() {
        return this.values.size() == 0 ? null : (String)this.values.get(0);
    }

    public String getValue(int index) throws IndexOutOfBoundsException {
        return this.values.size() == 0 ? null : (String)this.values.get(index);
    }

    public String getValue(String defaultValue) {
        String value = this.getValue();
        return value != null ? value : defaultValue;
    }

    public String[] getValues() {
        return this.values.size() == 0 ? null : this.values.toArray(new String[0]);
    }

    public List getValuesList() {
        return this.values;
    }

    public Object clone() {
        Option option = new Option(this.getOpt(), this.getDescription());
        option.setArgs(this.getArgs());
        option.setOptionalArg(this.hasOptionalArg());
        option.setRequired(this.isRequired());
        option.setLongOpt(this.getLongOpt());
        option.setType(this.getType());
        option.setValueSeparator(this.getValueSeparator());
        return option;
    }
}

