/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.generator.expr;

import com.meidusa.toolkit.plugins.autoconfig.generator.expr.ConstantExpression;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.Expression;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.ExpressionContext;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.ExpressionException;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.ReferenceExpression;
import java.util.ArrayList;
import java.util.List;

public class CompositeExpression
implements Expression {
    private String expr;
    private Expression[] expressions;

    public CompositeExpression(String expr, List expressions) {
        this.expr = expr;
        this.expressions = expressions.toArray(new Expression[expressions.size()]);
    }

    @Override
    public String getExpressionText() {
        return this.expr;
    }

    @Override
    public Object evaluate(ExpressionContext context) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.expressions.length) {
            Expression expression = this.expressions[i];
            Object value = expression.evaluate(context);
            if (value != null) {
                buffer.append(value);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static Expression parse(String expr) {
        int length = expr.length();
        int startIndex = expr.indexOf("${");
        if (startIndex < 0) {
            return new ConstantExpression(expr);
        }
        int endIndex = expr.indexOf("}", startIndex + 2);
        if (endIndex < 0) {
            throw new ExpressionException("Missing '}' character at the end of expression: " + expr);
        }
        if (startIndex == 0 && endIndex == length - 1) {
            return new ReferenceExpression(expr.substring(2, endIndex));
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        char ch = '\u0000';
        int i = 0;
        StringBuffer chars = new StringBuffer();
        StringBuffer exprBuff = new StringBuffer();
        block20: while (i < length) {
            ch = expr.charAt(i);
            block0 : switch (ch) {
                case '$': {
                    if (i + 1 < length) {
                        ch = expr.charAt(++i);
                        switch (ch) {
                            case '$': {
                                chars.append(ch);
                                break;
                            }
                            case '{': {
                                if (chars.length() > 0) {
                                    expressions.add(new ConstantExpression(chars.toString()));
                                    chars.delete(0, chars.length());
                                }
                                if (i + 1 >= length) break block0;
                                ++i;
                                block21: while (i < length) {
                                    ch = expr.charAt(i);
                                    block7 : switch (ch) {
                                        case '\"': {
                                            boolean escape;
                                            exprBuff.append(ch);
                                            ++i;
                                            while (i < length) {
                                                ch = expr.charAt(i);
                                                escape = false;
                                                switch (ch) {
                                                    case '\\': {
                                                        escape = true;
                                                        ++i;
                                                        exprBuff.append(ch);
                                                        break;
                                                    }
                                                    case '\"': {
                                                        ++i;
                                                        exprBuff.append(ch);
                                                        break block7;
                                                    }
                                                    default: {
                                                        escape = false;
                                                        ++i;
                                                        exprBuff.append(ch);
                                                    }
                                                }
                                            }
                                            continue block21;
                                        }
                                        case '\'': {
                                            boolean escape;
                                            exprBuff.append(ch);
                                            ++i;
                                            while (i < length) {
                                                ch = expr.charAt(i);
                                                escape = false;
                                                switch (ch) {
                                                    case '\\': {
                                                        escape = true;
                                                        ++i;
                                                        exprBuff.append(ch);
                                                        break;
                                                    }
                                                    case '\'': {
                                                        ++i;
                                                        exprBuff.append(ch);
                                                        break block7;
                                                    }
                                                    default: {
                                                        escape = false;
                                                        ++i;
                                                        exprBuff.append(ch);
                                                    }
                                                }
                                            }
                                            continue block21;
                                        }
                                        case '}': {
                                            expressions.add(new ReferenceExpression(exprBuff.toString()));
                                            exprBuff.delete(0, exprBuff.length());
                                            ++i;
                                            continue block20;
                                        }
                                        default: {
                                            exprBuff.append(ch);
                                            ++i;
                                        }
                                    }
                                }
                                break block0;
                            }
                            default: {
                                chars.append(ch);
                                break;
                            }
                        }
                        break;
                    }
                    chars.append(ch);
                    break;
                }
                default: {
                    chars.append(ch);
                }
            }
            ++i;
        }
        if (chars.length() > 0) {
            expressions.add(new ConstantExpression(chars.toString()));
        }
        return new CompositeExpression(expr, expressions);
    }
}

