/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.generator;

import com.meidusa.toolkit.plugins.autoconfig.ConfigException;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.CompositeExpression;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.Expression;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.ExpressionContext;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.ReferenceExpression;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.collection.ExtendedProperties;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public abstract class PropertiesLoader {
    public static Map loadPropertiesFile(File propsFile, String propsCharset) {
        ExtendedProperties props = new ExtendedProperties();
        if (propsFile.exists()) {
            try {
                props.load(propsFile.toURL(), propsCharset);
            }
            catch (IOException e) {
                throw new ConfigException(e);
            }
        }
        return props;
    }

    public static void mergeProperties(Map dest, Map src) {
        for (Map.Entry entry : src.entrySet()) {
            Expression expr;
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof String && (expr = CompositeExpression.parse((String)value)) != null) {
                value = expr;
            }
            dest.put(name, value);
            dest.put(StringUtil.getValidIdentifier(name), value);
        }
    }

    public static Object evaluate(String name, final Map props) {
        return new ReferenceExpression(name).evaluate(new ExpressionContext(){

            @Override
            public Object get(String key) {
                return props.get(key);
            }

            @Override
            public void put(String key, Object value) {
                props.put(key, value);
            }
        });
    }
}

