/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.generator;

import com.meidusa.toolkit.plugins.autoconfig.ConfigException;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigDescriptor;
import com.meidusa.toolkit.plugins.autoconfig.generator.ConfigGenerator;
import com.meidusa.toolkit.plugins.autoconfig.generator.ConfigGeneratorCallback;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DirectoryCallback
implements ConfigGeneratorCallback {
    private final ConfigGenerator generator;
    private File destfileBase;
    private InputStream istream;
    private OutputStream ostream;

    public DirectoryCallback(ConfigGenerator generator) {
        this.generator = generator;
    }

    public DirectoryCallback(ConfigGenerator generator, File destfileBase) {
        this.generator = generator;
        this.destfileBase = destfileBase;
    }

    @Override
    public void nextEntry(ConfigDescriptor descriptor, String template, String dest) {
        File projectPath = this.generator.configSettings.getProjectPath();
        File templateBase = projectPath == null ? descriptor.getBaseFile() : projectPath;
        File destfileBase = this.destfileBase;
        if (destfileBase == null) {
            destfileBase = projectPath == null ? templateBase : projectPath;
        }
        File templateFile = new File(templateBase, template);
        File destFile = new File(destfileBase, dest);
        File destBase = destFile.getParentFile();
        destBase.mkdirs();
        if (!destBase.isDirectory()) {
            throw new ConfigException("Could not create directory: " + destBase.getAbsolutePath());
        }
        if (!templateFile.exists()) {
            throw new ConfigException("Could not find template file: " + templateFile.getAbsolutePath() + " for descriptor: " + descriptor.getURL());
        }
        try {
            this.istream = new BufferedInputStream(new FileInputStream(templateFile), 8192);
            this.ostream = new BufferedOutputStream(new FileOutputStream(destFile), 8192);
        }
        catch (FileNotFoundException e) {
            throw new ConfigException(e);
        }
        this.generator.getSession().setInputStream(this.istream);
        this.generator.getSession().setOutputStream(this.ostream);
    }

    @Override
    public void logEntry(ConfigDescriptor descriptor, String logfileName) {
        File templateBase = descriptor.getBaseFile();
        File destfileBase = this.destfileBase;
        if (destfileBase == null) {
            destfileBase = templateBase;
        }
        File logfile = new File(destfileBase, logfileName);
        File logbase = logfile.getParentFile();
        logbase.mkdirs();
        if (!logbase.isDirectory()) {
            throw new ConfigException("Could not create directory: " + logbase.getAbsolutePath());
        }
        try {
            this.ostream = new BufferedOutputStream(new FileOutputStream(logfile), 8192);
        }
        catch (FileNotFoundException e) {
            throw new ConfigException(e);
        }
        this.generator.getSession().setOutputStream(this.ostream);
    }

    @Override
    public void closeEntry() {
        if (this.istream != null) {
            try {
                this.istream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.istream = null;
        }
        if (this.ostream != null) {
            try {
                this.ostream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.ostream = null;
        }
    }
}

