/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.entry;

import com.meidusa.toolkit.plugins.autoconfig.ConfigException;
import com.meidusa.toolkit.plugins.autoconfig.ConfigResource;
import com.meidusa.toolkit.plugins.autoconfig.ConfigSettings;
import com.meidusa.toolkit.plugins.autoconfig.entry.ConfigEntry;
import com.meidusa.toolkit.plugins.autoconfig.generator.ConfigGeneratorSession;
import com.meidusa.toolkit.plugins.autoconfig.generator.DirectoryCallback;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.DirectoryScanner;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.ScannerException;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;

public class DirectoryConfigEntry
extends ConfigEntry {
    public DirectoryConfigEntry(ConfigResource resource, ConfigSettings settings) {
        super(resource, settings);
    }

    @Override
    protected void scan(InputStream istream) {
        ConfigEntry.Handler handler = new ConfigEntry.Handler();
        DirectoryScanner scanner = new DirectoryScanner(this.getConfigEntryResource().getFile(), handler);
        try {
            scanner.scan();
        }
        catch (ScannerException e) {
            throw new ConfigException((Throwable)((Object)e));
        }
        this.subEntries = handler.getSubEntries();
        this.getGenerator().init();
    }

    @Override
    protected void generate(InputStream istream, OutputStream ostream) {
        this.getConfigSettings().debug("Processing files in " + this.getConfigEntryResource().getURL());
        try {
            File propsFile = this.getConfigSettings().getUserPropertiesFile();
            String propsFileCharset = this.getConfigSettings().getUserPropertiesFileCharset();
            ConfigGeneratorSession session = this.getGenerator().startSession(propsFile, propsFileCharset);
            session.generate(new DirectoryCallback(this.getGenerator()));
        }
        finally {
            this.getGenerator().closeSession();
        }
        ConfigEntry[] subEntries = this.getSubEntries();
        int i = 0;
        while (i < subEntries.length) {
            ConfigEntry subEntry = subEntries[i];
            subEntry.generate(null, null);
            ++i;
        }
    }

    public String toString() {
        return "DirectoryConfigEntry[" + this.getConfigEntryResource() + "]";
    }
}

