/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.cli;

import com.meidusa.toolkit.plugins.autoconfig.cli.CLIException;
import com.meidusa.toolkit.plugins.autoconfig.util.cli.CommandLine;
import com.meidusa.toolkit.plugins.autoconfig.util.cli.HelpFormatter;
import com.meidusa.toolkit.plugins.autoconfig.util.cli.OptionBuilder;
import com.meidusa.toolkit.plugins.autoconfig.util.cli.Options;
import com.meidusa.toolkit.plugins.autoconfig.util.cli.ParseException;
import com.meidusa.toolkit.plugins.autoconfig.util.cli.PosixParser;
import java.io.PrintWriter;

public class CLIManager {
    public static final String PRE_FIX = "config.";
    public static final String OPT_HELP = "config.h";
    public static final String OPT_INCLUDE_PACKAGES = "config.p";
    public static final String OPT_EXCLUDE_PACKAGES = "config.P";
    public static final String OPT_INCLUDE_DESCRIPTORS = "config.d";
    public static final String OPT_EXCLUDE_DESCRIPTORS = "config.D";
    public static final String OPT_TEXT_MODE = "config.t";
    public static final String OPT_GUI_MODE = "config.g";
    public static final String OPT_INTERACTIVE_MODE = "config.i";
    public static final String OPT_NON_INTERACTIVE_MODE = "config.I";
    public static final String OPT_VERBOSE = "config.v";
    public static final String OPT_CHARSET = "config.c";
    public static final String OPT_USER_PROPERTIES = "config.u";
    public static final String OPT_SKIP = "config.s";
    private Options options;

    public CLIManager() {
        OptionBuilder builder = new OptionBuilder();
        this.options = new Options();
        this.options.addOption(builder.withLongOpt("help").withDescription("\u663e\u793a\u5e2e\u52a9\u4fe1\u606f").create(OPT_HELP));
        this.options.addOption(builder.withLongOpt("include-descriptors").hasArg().withDescription("\u5305\u542b\u54ea\u4e9b\u914d\u7f6e\u63cf\u8ff0\u6587\u4ef6\uff0c\u4f8b\u5982\uff1aconf/auto-config.xml\uff0c\u53ef\u4f7f\u7528*\u3001**\u3001?\u901a\u914d\u7b26\uff0c\u5982\u6709\u591a\u9879\uff0c\u7528\u9017\u53f7\u5206\u9694").create(OPT_INCLUDE_DESCRIPTORS));
        this.options.addOption(builder.withLongOpt("exclude-descriptors").hasArg().withDescription("\u6392\u9664\u54ea\u4e9b\u914d\u7f6e\u63cf\u8ff0\u6587\u4ef6\uff0c\u53ef\u4f7f\u7528*\u3001**\u3001?\u901a\u914d\u7b26\uff0c\u5982\u6709\u591a\u9879\uff0c\u7528\u9017\u53f7\u5206\u9694").create(OPT_EXCLUDE_DESCRIPTORS));
        this.options.addOption(builder.withLongOpt("include-packages").hasArg().withDescription("\u5305\u542b\u54ea\u4e9b\u6253\u5305\u6587\u4ef6\uff0c\u4f8b\u5982\uff1atarget/*.war\uff0c\u53ef\u4f7f\u7528*\u3001**\u3001?\u901a\u914d\u7b26\uff0c\u5982\u6709\u591a\u9879\uff0c\u7528\u9017\u53f7\u5206\u9694").create(OPT_INCLUDE_PACKAGES));
        this.options.addOption(builder.withLongOpt("exclude-packages").hasArg().withDescription("\u6392\u9664\u54ea\u4e9b\u6253\u5305\u6587\u4ef6\uff0c\u53ef\u4f7f\u7528*\u3001**\u3001?\u901a\u914d\u7b26\uff0c\u5982\u6709\u591a\u9879\uff0c\u7528\u9017\u53f7\u5206\u9694").create(OPT_EXCLUDE_PACKAGES));
        this.options.addOption(builder.withLongOpt("interactive").hasOptionalArg().withDescription("\u4ea4\u4e92\u6a21\u5f0f\uff1aauto|on|off\uff0c\u9ed8\u8ba4\u4e3aauto\uff0c\u65e0\u53c2\u6570\u8868\u793aon").create(OPT_INTERACTIVE_MODE));
        this.options.addOption(builder.withLongOpt("non-interactive").withDescription("\u975e\u4ea4\u4e92\u6a21\u5f0f\uff0c\u76f8\u5f53\u4e8e--interactive=off").create(OPT_NON_INTERACTIVE_MODE));
        this.options.addOption(builder.withLongOpt("gui").withDescription("\u56fe\u5f62\u7528\u6237\u754c\u9762\uff08\u4ea4\u4e92\u6a21\u5f0f\uff09").create(OPT_GUI_MODE));
        this.options.addOption(builder.withLongOpt("text").withDescription("\u6587\u672c\u7528\u6237\u754c\u9762\uff08\u4ea4\u4e92\u6a21\u5f0f\uff09").create(OPT_TEXT_MODE));
        this.options.addOption(builder.withLongOpt("verbose").withDescription("\u663e\u793a\u66f4\u591a\u4fe1\u606f").create(OPT_VERBOSE));
        this.options.addOption(builder.withLongOpt("charset").withDescription("\u8f93\u5165/\u8f93\u51fa\u7f16\u7801\u5b57\u7b26\u96c6").create(OPT_CHARSET));
        this.options.addOption(builder.withLongOpt("userprop").hasArg().withDescription("\u7528\u6237\u5c5e\u6027\u6587\u4ef6").create(OPT_USER_PROPERTIES));
        this.options.addOption(builder.withLongOpt("skip").hasArg().withDescription("\u8df3\u8fc7Auto-config\u8fd0\u884c").create(OPT_SKIP));
    }

    public CommandLine parse(String[] args) {
        CommandLine cli;
        try {
            cli = new PosixParser().parse(this.options, args);
            cli.putAll(System.getProperties());
        }
        catch (ParseException e) {
            throw new CLIException((Throwable)((Object)e));
        }
        return cli;
    }

    public void help(PrintWriter out) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.defaultSyntaxPrefix = "\u4f7f\u7528\u65b9\u6cd5\uff1a";
        formatter.printHelp(out, 74, "autoconfig [\u53ef\u9009\u53c2\u6570] [\u76ee\u5f55\u540d|\u5305\u6587\u4ef6\u540d]\n", "\u53ef\u9009\u53c2\u6570\uff1a", this.options, 1, 3, "\n");
    }
}

