/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig;

import com.meidusa.toolkit.common.util.ConfigUtil;
import com.meidusa.toolkit.plugins.autoconfig.ConfigRuntimeImpl;
import com.meidusa.toolkit.plugins.autoconfig.DependencyInfo;
import com.meidusa.toolkit.plugins.autoconfig.dependency.DependencyFilter;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class AutoConfig
extends AbstractMojo {
    private ArtifactFactory artifactFactory;
    private String projectName;
    private String includePackages;
    private String excludePackages;
    private String excludeDescriptors;
    private String includeDescriptors;
    private String userPropertiesFile;
    private String charset;
    private MavenProject project;
    private List<DependencyInfo> excludeDependencies;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String skip = ConfigUtil.filter((String)System.getProperty("config.s"));
        if (skip != null && skip.toLowerCase().equals("true")) {
            return;
        }
        ArrayList<DependencyFilter> dependencyFilters = new ArrayList<DependencyFilter>();
        if (this.excludeDependencies != null && this.excludeDependencies.size() > 0) {
            for (DependencyInfo dependencyInfo : this.excludeDependencies) {
                dependencyFilters.add(DependencyFilter.compile(dependencyInfo));
            }
        }
        ArrayList<File> dependencyFiles = new ArrayList<File>();
        Iterator i = this.project.getArtifacts().iterator();
        while (i.hasNext()) {
            boolean exclude = false;
            Artifact dependency = (Artifact)i.next();
            if (dependency.getFile() == null) continue;
            Iterator iterator = dependencyFilters.iterator();
            while (iterator.hasNext()) {
                if (!((DependencyFilter)iterator.next()).match(dependency.getGroupId(), dependency.getArtifactId())) continue;
                exclude = true;
            }
            if (exclude) continue;
            dependencyFiles.add(dependency.getFile());
        }
        String interactive = System.getProperty("mode", "auto");
        ConfigRuntimeImpl runtimeImpl = new ConfigRuntimeImpl(System.in, System.out, System.err, StringUtil.isEmpty(this.charset) ? "gb2312" : this.charset);
        String userFileFromCmd = ConfigUtil.filter((String)System.getProperty("config.u"));
        if (userFileFromCmd != null) {
            runtimeImpl.setUserPropertiesFile(userFileFromCmd, this.charset);
        } else if (this.userPropertiesFile != null) {
            runtimeImpl.setUserPropertiesFile(this.userPropertiesFile, this.charset);
        }
        runtimeImpl.info("set defined properties: " + runtimeImpl.getUserPropertiesFile().toString() + "\n");
        runtimeImpl.setProjectName(this.projectName);
        runtimeImpl.setDescriptorPatterns(this.includeDescriptors, this.excludeDescriptors);
        runtimeImpl.setPackagePatterns(this.includePackages, this.excludePackages);
        runtimeImpl.setInteractiveMode(interactive);
        Properties properties = new Properties();
        properties.setProperty("project", this.project.getFile().getParent());
        runtimeImpl.setProperties(properties);
        runtimeImpl.setProjectPath(this.project.getFile().getParentFile());
        runtimeImpl.setDependencyFiles(dependencyFiles);
        try {
            runtimeImpl.start();
        }
        catch (Exception e) {
            runtimeImpl.error(e);
        }
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setIncludePackages(String includePackages) {
        this.includePackages = includePackages;
    }

    public void setExcludePackages(String excludePackages) {
        this.excludePackages = excludePackages;
    }

    public void setExcludeDescriptors(String excludeDescriptors) {
        this.excludeDescriptors = excludeDescriptors;
    }

    public void setIncludeDescriptors(String includeDescriptors) {
        this.includeDescriptors = includeDescriptors;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }
}

