package com.meidusa.toolkit.plugins.autoconfig.wizard.text;

import com.meidusa.toolkit.plugins.autoconfig.ConfigConstant;
import com.meidusa.toolkit.plugins.autoconfig.ConfigSettings;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigDescriptor;
import com.meidusa.toolkit.plugins.autoconfig.entry.ConfigEntry;

import java.io.File;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConfigWizardLoader {
    private final ConfigSettings   settings;
    private final List             configEntries;
    private final ConfigDescriptor inlineDescriptor;

    public ConfigWizardLoader(ConfigSettings settings, List configEntries) {
        this.settings         = settings;
        this.configEntries    = configEntries;
        this.inlineDescriptor = null;
    }

    public ConfigWizardLoader(ConfigSettings settings, ConfigDescriptor inlineDescription) {
        this.settings         = settings;
        this.configEntries    = null;
        this.inlineDescriptor = inlineDescription;
    }

    public void loadAndStart() {
        // ʹwizard֤û
        ConfigDescriptor[] descriptors     = getAllDescriptors();
        File               propsFile       = settings.getUserPropertiesFile();
        String             propsCharset    = settings.getUserPropertiesFileCharset();
        ConfigWizard       wizard          = new ConfigWizard(descriptors, propsFile, propsCharset);
        boolean            valid           = wizard.validate();
        String             interactiveMode = settings.getInteractiveMode();
        boolean            interactiveAuto = ConfigConstant.INTERACTIVE_AUTO.equals(interactiveMode);
        boolean            interactiveOn   = ConfigConstant.INTERACTIVE_ON.equals(interactiveMode);

        if (interactiveOn || (interactiveAuto && !valid)) {
            if (!valid) {
                StringBuffer confirm = new StringBuffer();

                confirm.append("q\n");
                confirm.append("\n");
                confirm.append(" ļҪ£\n");
                confirm.append("\n");
                confirm.append(" ").append(propsFile.getAbsolutePath()).append("\n");
                confirm.append("\n");
                confirm.append(" ļ˵ã\n");
                confirm.append(" ˿ڡʼַݡ\n");
                confirm.append("\n");
                confirm.append("\n");
                confirm.append("\n").append(" ´ļܻᵼļݲ\n");
                confirm.append(" Ҫڸ´ļ?");

                wizard.setConfirmMessage(confirm.toString());
            }

            wizard.start();

            valid = wizard.validate();
        }

        // validΪtrue׳쳣
        if (!valid) {
            throw new ConfigWizardException("Ϊļ" + propsFile + "δ׼ã޷ȥ");
        }
    }

    /**
     * ȡеdescriptors
     *
     * @return descriptors
     */
    private ConfigDescriptor[] getAllDescriptors() {
        if (configEntries != null) {
            List descriptors = new ArrayList();

            for (Iterator i = configEntries.iterator(); i.hasNext();) {
                ConfigEntry entry = (ConfigEntry) i.next();

                addConfigEntryRecursive(entry, descriptors);
            }

            return (ConfigDescriptor[]) descriptors.toArray(new ConfigDescriptor[descriptors.size()]);
        } else if (inlineDescriptor != null) {
            return new ConfigDescriptor[] { inlineDescriptor };
        } else {
            return new ConfigDescriptor[0];
        }
    }

    /**
     * entryentryеdescriptorsбС
     *
     * @param entry config entry
     * @param descriptors descriptorsб
     */
    private void addConfigEntryRecursive(ConfigEntry entry, List descriptors) {
        if (entry == null) {
            return;
        }

        ConfigDescriptor[] entryDescriptors = entry.getGenerator().getConfigDescriptors();

        for (int i = 0; i < entryDescriptors.length; i++) {
            descriptors.add(entryDescriptors[i]);
        }

        ConfigEntry[] subEntries = entry.getSubEntries();

        for (int i = 0; i < subEntries.length; i++) {
            addConfigEntryRecursive(subEntries[i], descriptors);
        }
    }
}
