package com.meidusa.toolkit.plugins.autoconfig.util;

import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

/**
 * һ򵥵XML writerֿ֧ռ䡣
 *
 * 
 *
 */
public class SimpleXMLWriter extends XMLWriter {
    /**
     * һXML writer
     *
     * @param file XMLļ
     *
     * @throws IOException ļʧ
     */
    public SimpleXMLWriter(File file) throws IOException {
        super(new FileOutputStream(file), OutputFormat.createPrettyPrint());
    }

    /**
     * ʼһXML element
     *
     * @param elementName element
     *
     * @throws SAXException SAX쳣
     */
    public void startElement(String elementName) throws SAXException {
        startElement("", "", elementName, new AttributesImpl());
    }

    /**
     * ʼһXML element
     *
     * @param elementName element
     * @param attrName 
     * @param attrValue ֵ
     *
     * @throws SAXException SAX쳣
     */
    public void startElement(String elementName, String attrName, String attrValue)
            throws SAXException {
        if (attrValue == null) {
            attrValue = "";
        }

        AttributesImpl attrs = new AttributesImpl();

        attrs.addAttribute("", "", attrName, "CDATA", attrValue);

        startElement("", "", elementName, attrs);
    }

    /**
     * ʼһXML element
     *
     * @param elementName element
     * @param attrName1 
     * @param attrValue1 ֵ
     * @param attrName2 
     * @param attrValue2 ֵ
     *
     * @throws SAXException SAX쳣
     */
    public void startElement(String elementName, String attrName1, String attrValue1,
        String attrName2, String attrValue2) throws SAXException {
        if (attrValue1 == null) {
            attrValue1 = "";
        }

        if (attrValue2 == null) {
            attrValue2 = "";
        }

        AttributesImpl attrs = new AttributesImpl();

        attrs.addAttribute("", "", attrName1, "CDATA", attrValue1);
        attrs.addAttribute("", "", attrName2, "CDATA", attrValue2);

        startElement("", "", elementName, attrs);
    }

    /**
     * һXML element
     *
     * @param elementName element
     * @param bodyText elementֵ
     *
     * @throws SAXException SAX쳣
     */
    public void processElement(String elementName, String bodyText)
            throws SAXException {
        if (StringUtil.isEmpty(bodyText)) {
            return;
        }

        startElement("", "", elementName, new AttributesImpl());
        characters(bodyText.toCharArray(), 0, bodyText.length());
        endElement("", "", elementName);
    }

    /**
     * һXML element
     *
     * @param elementName element
     *
     * @throws SAXException SAX쳣
     */
    public void endElement(String elementName) throws SAXException {
        endElement("", "", elementName);
    }
}
