package com.meidusa.toolkit.plugins.autoconfig.util;

import java.io.Serializable;

import java.text.MessageFormat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * Բͳִ߳ʱĹߡ
 *
 * 
 *
 */
public final class Profiler {
    private static final ThreadLocal entryStack = new ThreadLocal();

    /**
     * ʼʱ
     */
    public static void start() {
        start((String) null);
    }

    /**
     * ʼʱ
     *
     * @param message һentryϢ
     */
    public static void start(String message) {
        entryStack.set(new Entry(message, null, null));
    }

    /**
     * ʼʱ
     *
     * @param message һentryϢ
     */
    public static void start(Message message) {
        entryStack.set(new Entry(message, null, null));
    }

    /**
     * ʱ
     * 
     * <p>
     * Ժٴε<code>start</code>¼ʱ
     * </p>
     */
    public static void reset() {
        entryStack.set(null);
    }

    /**
     * ʼһµentryʱ
     *
     * @param message entryϢ
     */
    public static void enter(String message) {
        Entry currentEntry = getCurrentEntry();

        if (currentEntry != null) {
            currentEntry.enterSubEntry(message);
        }
    }

    /**
     * ʼһµentryʱ
     *
     * @param message entryϢ
     */
    public static void enter(Message message) {
        Entry currentEntry = getCurrentEntry();

        if (currentEntry != null) {
            currentEntry.enterSubEntry(message);
        }
    }

    /**
     * һentry¼ʱ䡣
     */
    public static Entry release() {
        Entry currentEntry = getCurrentEntry();

        if (currentEntry != null) {
            currentEntry.release();
        }

        return currentEntry;
    }

    /**
     * ȡúķѵʱ䡣
     *
     * @return ķѵʱ䣬δʼʱ򷵻<code>-1</code>
     */
    public static long getDuration() {
        Entry entry = (Entry) entryStack.get();

        if (entry != null) {
            return entry.getDuration();
        } else {
            return -1;
        }
    }

    /**
     * геentry
     *
     * @return гentryͳƸռõʱ
     */
    public static String dump() {
        return dump("", "");
    }

    /**
     * геentry
     *
     * @param prefix ǰ׺
     *
     * @return гentryͳƸռõʱ
     */
    public static String dump(String prefix) {
        return dump(prefix, prefix);
    }

    /**
     * геentry
     *
     * @param prefix1 ǰ׺
     * @param prefix2 ǰ׺
     *
     * @return гentryͳƸռõʱ
     */
    public static String dump(String prefix1, String prefix2) {
        Entry entry = (Entry) entryStack.get();

        if (entry != null) {
            return entry.toString(prefix1, prefix2);
        } else {
            return "";
        }
    }

    /**
     * ȡõһentry
     *
     * @return һentryڣ򷵻<code>null</code>
     */
    public static Entry getEntry() {
        return (Entry) entryStack.get();
    }

    /**
     * ȡһentry
     *
     * @return һentryڣ򷵻<code>null</code>
     */
    private static Entry getCurrentEntry() {
        Entry subEntry = (Entry) entryStack.get();
        Entry entry = null;

        if (subEntry != null) {
            do {
                entry    = subEntry;
                subEntry = entry.getUnreleasedEntry();
            } while (subEntry != null);
        }

        return entry;
    }

    private static Object defaultIfNull(Object object, Object defaultValue) {
        return (object != null) ? object
                                : defaultValue;
    }

    private static String defaultIfEmpty(String str, String defaultStr) {
        return ((str == null) || (str.length() == 0)) ? defaultStr
                                                      : str;
    }

    /**
     * һʱԪ
     */
    public static final class Entry {
        private final List   subEntries  = new ArrayList(4);
        private final Object message;
        private final Entry  parentEntry;
        private final Entry  firstEntry;
        private final long   baseTime;
        private final long   startTime;
        private long         endTime;

        /**
         * һµentry
         *
         * @param message entryϢ<code>null</code>
         * @param parentEntry entry<code>null</code>
         * @param firstEntry һentry<code>null</code>
         */
        private Entry(Object message, Entry parentEntry, Entry firstEntry) {
            this.message     = message;
            this.startTime   = System.currentTimeMillis();
            this.parentEntry = parentEntry;
            this.firstEntry  = (Entry) defaultIfNull(firstEntry, this);
            this.baseTime    = (firstEntry == null) ? 0
                                                    : firstEntry.startTime;
        }

        /**
         * ȡentryϢ
         */
        public String getMessage() {
            String messageString = null;

            if (message instanceof String) {
                messageString = (String) message;
            } else if (message instanceof Message) {
                Message      messageObject = (Message) message;
                MessageLevel level = MessageLevel.BRIEF_MESSAGE;

                if (isReleased()) {
                    level = messageObject.getMessageLevel(this);
                }

                if (level == MessageLevel.DETAILED_MESSAGE) {
                    messageString = messageObject.getDetailedMessage();
                } else {
                    messageString = messageObject.getBriefMessage();
                }
            }

            return defaultIfEmpty(messageString, null);
        }

        /**
         * ȡentryڵһentryʼʱ䡣
         *
         * @return ʼʱ
         */
        public long getStartTime() {
            return (baseTime > 0) ? (startTime - baseTime)
                                  : 0;
        }

        /**
         * ȡentryڵһentryĽʱ䡣
         *
         * @return Խʱ䣬entryδ򷵻<code>-1</code>
         */
        public long getEndTime() {
            if (endTime < baseTime) {
                return -1;
            } else {
                return endTime - baseTime;
            }
        }

        /**
         * ȡentryʱ䡣
         *
         * @return entryʱ䣬entryδ򷵻<code>-1</code>
         */
        public long getDuration() {
            if (endTime < startTime) {
                return -1;
            } else {
                return endTime - startTime;
            }
        }

        /**
         * ȡentryõʱ䣬ʱȥentryõʱ䡣
         *
         * @return entryõʱ䣬entryδ򷵻<code>-1</code>
         */
        public long getDurationOfSelf() {
            long duration = getDuration();

            if (duration < 0) {
                return -1;
            } else if (subEntries.isEmpty()) {
                return duration;
            } else {
                for (int i = 0; i < subEntries.size(); i++) {
                    Entry subEntry = (Entry) subEntries.get(i);

                    duration -= subEntry.getDuration();
                }

                if (duration < 0) {
                    return -1;
                } else {
                    return duration;
                }
            }
        }

        /**
         * ȡõǰentryڸentryռʱٷֱȡ
         *
         * @return ٷֱ
         */
        public double getPecentage() {
            double parentDuration = 0;
            double duration = getDuration();

            if ((parentEntry != null) && parentEntry.isReleased()) {
                parentDuration = parentEntry.getDuration();
            }

            if ((duration > 0) && (parentDuration > 0)) {
                return duration / parentDuration;
            } else {
                return 0;
            }
        }

        /**
         * ȡõǰentryڵһentryռʱٷֱȡ
         *
         * @return ٷֱ
         */
        public double getPecentageOfAll() {
            double firstDuration = 0;
            double duration = getDuration();

            if ((firstEntry != null) && firstEntry.isReleased()) {
                firstDuration = firstEntry.getDuration();
            }

            if ((duration > 0) && (firstDuration > 0)) {
                return duration / firstDuration;
            } else {
                return 0;
            }
        }

        /**
         * ȡentries
         *
         * @return entriesбɸģ
         */
        public List getSubEntries() {
            return Collections.unmodifiableList(subEntries);
        }

        /**
         * ǰentry¼ʱ䡣
         */
        private void release() {
            endTime = System.currentTimeMillis();
        }

        /**
         * жϵǰentryǷ
         *
         * @return entryѾ򷵻<code>true</code>
         */
        private boolean isReleased() {
            return endTime > 0;
        }

        /**
         * һµentry
         *
         * @param message entryϢ
         */
        private void enterSubEntry(Object message) {
            Entry subEntry = new Entry(message, this, firstEntry);

            subEntries.add(subEntry);
        }

        /**
         * ȡδentry
         *
         * @return δentryûentryentryѽ򷵻<code>null</code>
         */
        private Entry getUnreleasedEntry() {
            Entry subEntry = null;

            if (!subEntries.isEmpty()) {
                subEntry = (Entry) subEntries.get(subEntries.size() - 1);

                if (subEntry.isReleased()) {
                    subEntry = null;
                }
            }

            return subEntry;
        }

        /**
         * entryתַıʾ
         *
         * @return ַʾentry
         */
        public String toString() {
            return toString("", "");
        }

        /**
         * entryתַıʾ
         *
         * @param prefix1 ǰ׺
         * @param prefix2 ǰ׺
         *
         * @return ַʾentry
         */
        private String toString(String prefix1, String prefix2) {
            StringBuffer buffer = new StringBuffer();

            toString(buffer, prefix1, prefix2);

            return buffer.toString();
        }

        /**
         * entryתַıʾ
         *
         * @param buffer ַbuffer
         * @param prefix1 ǰ׺
         * @param prefix2 ǰ׺
         */
        private void toString(StringBuffer buffer, String prefix1, String prefix2) {
            buffer.append(prefix1);

            String message        = getMessage();
            long   startTime      = getStartTime();
            long   duration       = getDuration();
            long   durationOfSelf = getDurationOfSelf();
            double percent        = getPecentage();
            double percentOfAll   = getPecentageOfAll();

            Object[] params = new Object[] {
                                  message, // {0} - entryϢ 
            new Long(startTime), // {1} - ʼʱ
            new Long(duration), // {2} - ʱ
            new Long(durationOfSelf), // {3} - ĵʱ
            new Double(percent), // {4} - ڸentryռʱ
            new Double(percentOfAll) // {5} - ʱɵʱ
                              };

            StringBuffer pattern = new StringBuffer("{1,number} ");

            if (isReleased()) {
                pattern.append("[{2,number}ms");

                if ((durationOfSelf > 0) && (durationOfSelf != duration)) {
                    pattern.append(" ({3,number}ms)");
                }

                if (percent > 0) {
                    pattern.append(", {4,number,##%}");
                }

                if (percentOfAll > 0) {
                    pattern.append(", {5,number,##%}");
                }

                pattern.append("]");
            } else {
                pattern.append("[UNRELEASED]");
            }

            if (message != null) {
                pattern.append(" - {0}");
            }

            buffer.append(MessageFormat.format(pattern.toString(), params));

            for (int i = 0; i < subEntries.size(); i++) {
                Entry subEntry = (Entry) subEntries.get(i);

                buffer.append('\n');

                if (i == (subEntries.size() - 1)) {
                    subEntry.toString(buffer, prefix2 + "`---", prefix2 + "    "); // һ
                } else if (i == 0) {
                    subEntry.toString(buffer, prefix2 + "+---", prefix2 + "|   "); // һ
                } else {
                    subEntry.toString(buffer, prefix2 + "+---", prefix2 + "|   "); // м
                }
            }
        }
    }

    /**
     * ʾϢļ
     */
    public static final class MessageLevel implements Serializable {
        private static final long        serialVersionUID = 3257849896026388537L;
        public static final MessageLevel NO_MESSAGE       = new MessageLevel();
        public static final MessageLevel BRIEF_MESSAGE    = new MessageLevel();
        public static final MessageLevel DETAILED_MESSAGE = new MessageLevel();
    }

    /**
     * һprofiler entryϸϢ
     */
    public interface Message {
        MessageLevel getMessageLevel(Entry entry);

        String getBriefMessage();

        String getDetailedMessage();
    }
}
