package com.meidusa.toolkit.plugins.autoconfig.generator;

import com.meidusa.toolkit.plugins.autoconfig.ConfigException;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.CompositeExpression;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.Expression;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.ExpressionContext;
import com.meidusa.toolkit.plugins.autoconfig.generator.expr.ReferenceExpression;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.collection.ExtendedProperties;

import java.io.File;
import java.io.IOException;

import java.util.Iterator;
import java.util.Map;

public abstract class PropertiesLoader {
    /**
     * װļ
     *
     * @param propsFile ļ
     * @param propsCharset װļʱʹõıַ
     *
     * @return ļ
     */
    public static Map loadPropertiesFile(File propsFile, String propsCharset) {
        ExtendedProperties props = new ExtendedProperties();

        if (propsFile.exists()) {
            try {
                props.load(propsFile.toURL(), propsCharset);
            } catch (IOException e) {
                throw new ConfigException(e);
            }
        }

        return props;
    }

    /**
     * ԴԴԱкϲĿԱģ򸲸֮
     *
     * @param dest ĿԱ
     * @param src ԴԱ
     */
    public static void mergeProperties(Map dest, Map src) {
        for (Iterator i = src.entrySet().iterator(); i.hasNext();) {
            Map.Entry entry = (Map.Entry) i.next();
            String    name  = (String) entry.getKey();
            Object    value = entry.getValue();

            if (value instanceof String) {
                Expression expr = CompositeExpression.parse((String) value);

                if (expr != null) {
                    value = expr;
                }
            }

            dest.put(name, value);
            dest.put(StringUtil.getValidIdentifier(name), value);
        }
    }

    /**
     * ȡֵ㡣
     */
    public static Object evaluate(String name, final Map props) {
        return new ReferenceExpression(name).evaluate(new ExpressionContext() {
                public Object get(String key) {
                    return props.get(key);
                }

                public void put(String key, Object value) {
                    props.put(key, value);
                }
            });
    }
}
