package com.meidusa.toolkit.plugins.autoconfig.entry;

import com.meidusa.toolkit.plugins.autoconfig.ConfigResource;
import com.meidusa.toolkit.plugins.autoconfig.ConfigSettings;
import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigDescriptor;
import com.meidusa.toolkit.plugins.autoconfig.generator.ConfigGenerator;
import com.meidusa.toolkit.plugins.autoconfig.util.PatternSet;
import com.meidusa.toolkit.plugins.autoconfig.util.SelectorUtil;
import com.meidusa.toolkit.plugins.autoconfig.util.scanner.DefaultScannerHandler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import java.net.URL;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * һϢ
 *
 * 
 */
public abstract class ConfigEntry {
    private ConfigSettings        settings;
    private ConfigResource        resource;
    private PatternSet            descriptorPatterns;
    private PatternSet            packagePatterns;
    protected ConfigEntry[]       subEntries;
    private final ConfigGenerator generator;

/**
     * һ㡣
     *
     * @param resource ָԴ
     * @param settings autoconfig
     */
    public ConfigEntry(ConfigResource resource, ConfigSettings settings) {
        this.resource  = resource;
        this.settings  = settings;
        this.generator = new ConfigGenerator(settings);
    }

    /**
     * ȡýơ
     *
     * @return 
     */
    public String getName() {
        return getConfigEntryResource().getName();
    }

    /**
     * κdescriptorsub entriesĿս㡣
     */
    public boolean isEmpty() {
        return (getSubEntries().length == 0) && (getGenerator().getConfigDescriptors().length == 0);
    }

    /**
     * ȡԴ
     *
     * @return Դ
     */
    public ConfigResource getConfigEntryResource() {
        return resource;
    }

    /**
     * ȡconfigá
     *
     * @return config
     */
    public ConfigSettings getConfigSettings() {
        return settings;
    }

    /**
     * ȡconfig descriptorpatternsδãʹĬֵ
     *
     * @return config descriptorpattern
     */
    public PatternSet getDescriptorPatterns() {
        return descriptorPatterns;
    }

    /**
     * config descriptorpatternδãʹĬֵ
     *
     * @param descriptorsPatterns config descriptorpattern
     */
    public void setDescriptorPatterns(PatternSet descriptorPatterns) {
        this.descriptorPatterns = descriptorPatterns;
    }

    /**
     * ȡƥ䵱ǰµӽpattern
     *
     * @return pattern
     */
    public PatternSet getPackagePatterns() {
        return packagePatterns;
    }

    /**
     * ƥ䵱ǰµӽpattern
     *
     * @param packagePatterns pattern
     */
    public void setPackagePatterns(PatternSet packagePatterns) {
        this.packagePatterns = packagePatterns;
    }

    /**
     * ȡõǰconfigӦgenerator
     *
     * @return generator
     */
    public ConfigGenerator getGenerator() {
        return generator;
    }

    /**
     * ȡõǰconfigµӽ㡣
     *
     * @return ӽ飬ڣ򷵻ؿ
     */
    public ConfigEntry[] getSubEntries() {
        return subEntries;
    }

    /**
     * ɨ㡣
     */
    public void scan() {
        scan(null);
    }

    /**
     * ɨ㡣
     */
    protected abstract void scan(InputStream istream);

    /**
     * װdescriptorcontextļ
     */
    protected void populateDescriptorContext(Map context, String string) {
    }

    /**
     * ļ
     */
    public void generate() {
        generate(null, null);
    }

    /**
     * ļ
     */
    protected abstract void generate(InputStream istream, OutputStream ostream);

    /**
     * ɨ账
     */
    public class Handler extends DefaultScannerHandler {
        private List subEntries = new ArrayList();

        public ConfigEntry[] getSubEntries() {
            return (ConfigEntry[]) subEntries.toArray(new ConfigEntry[subEntries.size()]);
        }

        public void startScanning() {
            StringBuffer buffer = new StringBuffer();

            buffer.append("Scanning ").append(getScanner().getBaseURL()).append("\n");
            buffer.append("  descriptors: ").append(getDescriptorPatterns()).append("\n");
            buffer.append("     packages: ").append(getPackagePatterns()).append("\n");

            settings.debug(buffer.toString());
        }

        public void file() {
            String name = getScanner().getPath();

            if (isDescriptorFile(name)) {
                settings.debug("Loading descriptor " + getScanner().getURL() + "\n");

                loadDescriptor();
            } else if (isPackageFile(name)) {
                ConfigResource     resource = new ConfigResource(getScanner().getURL(), name);
                ConfigEntryFactory factory  = getConfigSettings().getConfigEntryFactory();
                ConfigEntry        subEntry = factory.create(resource);

                InputStream istream = null;

                try {
                    istream = getScanner().getInputStream();
                    subEntry.scan(istream);
                } finally {
                    if (istream != null) {
                        try {
                            istream.close();
                        } catch (IOException e) {
                        }
                    }
                }

                if (!subEntry.isEmpty()) {
                    subEntries.add(subEntry);
                }
            }
        }

        public void directory() {
            String name = getScanner().getPath();

            if (isPackageFile(name)) {
                ConfigResource     resource = new ConfigResource(getScanner().getURL(), name);
                ConfigEntryFactory factory  = getConfigSettings().getConfigEntryFactory();
                ConfigEntry        subEntry = factory.create(resource);

                subEntry.scan();

                if (!subEntry.isEmpty()) {
                    subEntries.add(subEntry);
                }
            }
        }

        /**
         * ǷָĿ¼ļ÷ɨٶȡ
         *
         * @return ǣ򷵻<code>true</code>
         */
        public boolean followUp() {
            String  name     = getScanner().getPath();
            boolean followUp = false;

            followUp |= SelectorUtil.matchPathPrefix(name, getDescriptorPatterns().getIncludes(),
                                                     getDescriptorPatterns().getExcludes());

            followUp |= SelectorUtil.matchPathPrefix(name, getPackagePatterns().getIncludes(),
                                                     getPackagePatterns().getExcludes());

            if (isPackageFile(name)) {
                return false;
            }

            if (!followUp) {
                getConfigSettings().debug("Skipping directory " + name);
            }

            return followUp;
        }

        /**
         * װdescriptor
         */
        private void loadDescriptor() {
            URL            descriptorURL      = getScanner().getURL();
            ConfigResource descriptorResource = new ConfigResource(descriptorURL,
                                                                   getScanner().getPath());

            ConfigDescriptor descriptor;
            InputStream      istream = null;

            try {
                istream    = getScanner().getInputStream();
                descriptor = getGenerator().addConfigDescriptor(descriptorResource, istream);
            } finally {
                if (istream != null) {
                    try {
                        istream.close();
                    } catch (IOException e) {
                    }
                }
            }

            populateDescriptorContext(descriptor.getContext(), descriptor.getName());
        }

        /**
         * 鿴ָǷdescriptorpatterns
         *
         * @param name Ҫƥ
         *
         * @return descriptorpatterns򷵻<code>true</code>
         */
        private boolean isDescriptorFile(String name) {
            return SelectorUtil.matchPath(name, getDescriptorPatterns().getIncludes(),
                                          getDescriptorPatterns().getExcludes());
        }

        /**
         * 鿴ָǷjarfilepatterns
         *
         * @param name Ҫƥ
         *
         * @return jarfilepatterns򷵻<code>true</code>
         */
        private boolean isPackageFile(String name) {
            return SelectorUtil.matchPath(name, getPackagePatterns().getIncludes(),
                                          getPackagePatterns().getExcludes());
        }
    }
}
