package com.meidusa.toolkit.plugins.autoconfig;

import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

import com.meidusa.toolkit.common.util.ConfigUtil;
import com.meidusa.toolkit.plugins.autoconfig.cli.CLIManager;
import com.meidusa.toolkit.plugins.autoconfig.dependency.DependencyFilter;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;

/**
 * 
 * @author Administrator
 * @goal config
 * @phase process-resources
 */
public class AutoConfig extends AbstractMojo {
	/**
	 * The artifact factory to use.
	 * 
	 * @component
	 * @required
	 * @readonly
	 */
	private ArtifactFactory artifactFactory;

	/**
	 * projectName
	 * 
	 * @parameter
	 */
	private String projectName;

	/**
	 * includePackages
	 * 
	 * @parameter
	 */
	private String includePackages;

	/**
	 * excludePackages
	 * 
	 * @parameter
	 */
	private String excludePackages;

	/**
	 * excludeDescriptors
	 * 
	 * @parameter
	 */
	private String excludeDescriptors;

	/**
	 * includeDescriptors
	 * 
	 * @parameter
	 */
	private String includeDescriptors;

	/**
	 * @parameter
	 */
	private String userPropertiesFile;

	/**
	 * @parameter
	 */
	private String charset;

	/**
	 * The maven project.
	 * 
	 * @parameter expression="${project}"
	 * @required
	 * @readonly
	 */
	private MavenProject project;

	/**
	 * @parameter
	 */
	private List<com.meidusa.toolkit.plugins.autoconfig.DependencyInfo> excludeDependencies;

	public void execute() throws MojoExecutionException, MojoFailureException {

		String skip = ConfigUtil
				.filter(System.getProperty(CLIManager.OPT_SKIP));

		if (skip != null && skip.toLowerCase().equals("true")) {
			return;
		}

		List<DependencyFilter> dependencyFilters = new ArrayList<DependencyFilter>();

		if (excludeDependencies != null && excludeDependencies.size() > 0) {

			for (Iterator iterator = excludeDependencies.iterator(); iterator
					.hasNext();) {
				DependencyInfo dependencyInfo = (DependencyInfo) iterator
						.next();
				dependencyFilters.add(DependencyFilter.compile(dependencyInfo));

			}
		}
		List<File> dependencyFiles = new ArrayList<File>();

		for (Iterator i = project.getArtifacts().iterator(); i
				.hasNext();) {
			boolean exclude = false;
			Artifact dependency = (Artifact) i.next();
			if (dependency.getFile() != null) {
				for (Iterator iterator = dependencyFilters.iterator(); iterator
						.hasNext();) {
					if (((DependencyFilter) iterator.next())
							.match(dependency.getGroupId(),
									dependency.getArtifactId())) {
						exclude = true;

					}

				}
				if (!exclude) {
					dependencyFiles.add(dependency.getFile());
				}
			}

		}

		String interactive = System.getProperty("mode", "auto");

		ConfigRuntimeImpl runtimeImpl = new ConfigRuntimeImpl(System.in,
				System.out, System.err, StringUtil.isEmpty(charset) ? "gb2312"
						: charset);
		String userFileFromCmd = ConfigUtil.filter(System
				.getProperty(CLIManager.OPT_USER_PROPERTIES));

		if (userFileFromCmd != null) {
			runtimeImpl.setUserPropertiesFile(userFileFromCmd, charset);
		} else if (this.userPropertiesFile != null) {
			runtimeImpl.setUserPropertiesFile(userPropertiesFile, charset);
		}
		runtimeImpl.info("set defined properties: "
				+ runtimeImpl.getUserPropertiesFile().toString() + "\n");

		runtimeImpl.setProjectName(projectName);
		runtimeImpl.setDescriptorPatterns(includeDescriptors,
				excludeDescriptors);
		runtimeImpl.setPackagePatterns(includePackages, excludePackages);
		runtimeImpl.setInteractiveMode(interactive);
		Properties properties = new Properties();
		properties.setProperty("project", project.getFile().getParent());
		runtimeImpl.setProperties(properties);
		runtimeImpl.setProjectPath(project.getFile().getParentFile());
		runtimeImpl.setDependencyFiles(dependencyFiles);
		try {
			runtimeImpl.start();
		} catch (Exception e) {
			runtimeImpl.error(e);
		}
	}

	public void setArtifactFactory(ArtifactFactory artifactFactory) {
		this.artifactFactory = artifactFactory;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public void setIncludePackages(String includePackages) {
		this.includePackages = includePackages;
	}

	public void setExcludePackages(String excludePackages) {
		this.excludePackages = excludePackages;
	}

	public void setExcludeDescriptors(String excludeDescriptors) {
		this.excludeDescriptors = excludeDescriptors;
	}

	public void setIncludeDescriptors(String includeDescriptors) {
		this.includeDescriptors = includeDescriptors;
	}

	public void setCharset(String charset) {
		this.charset = charset;
	}

	public void setProject(MavenProject project) {
		this.project = project;
	}

}
