/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.plugins.autoconfig.descriptor.validator;

import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigValidator;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;
import java.io.File;
import org.apache.log4j.Logger;

public class FileExistValidator
extends ConfigValidator {
    private static final Logger log = Logger.getLogger(FileExistValidator.class);
    private String filename;
    private File file;

    @Override
    public Logger getLogger() {
        return log;
    }

    public void setFile(String filename) {
        this.filename = filename;
    }

    @Override
    public boolean validate(String value) {
        if (value == null) {
            return true;
        }
        if (StringUtil.isEmpty(value = value.trim())) {
            return true;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Validating file or directory: " + value));
        }
        this.file = this.filename == null ? new File(value) : new File(value, this.filename);
        return this.file.isAbsolute() && this.file.exists();
    }

    @Override
    protected String getDefaultMessage() {
        return "\u6587\u4ef6\u6216\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u6216\u4e0d\u662f\u7edd\u5bf9\u8def\u5f84\uff1a" + this.file;
    }
}

