package com.meidusa.toolkit.plugins.autoconfig.descriptor.validator;

import org.apache.log4j.Logger;

import com.meidusa.toolkit.plugins.autoconfig.descriptor.ConfigValidator;
import com.meidusa.toolkit.plugins.autoconfig.util.StringUtil;


public class RequiredValidator extends ConfigValidator {
    private static final Logger log = Logger.getLogger(RequiredValidator.class);

    public Logger getLogger() {
        return log;
    }

    public boolean validate(String value) {
        if (getLogger().isDebugEnabled()) {
            getLogger().debug("Validating value: " + value);
        }

        if (value == null) {
            return false;
        }

        value = value.trim();

        return !StringUtil.isEmpty(value);
    }

    protected String getDefaultMessage() {
        return "ûд" + getConfigProperty().getName();
    }
}
