package com.meidusa.toolkit.plugins.autoconfig.cli;

import com.meidusa.toolkit.plugins.autoconfig.util.cli.CommandLine;
import com.meidusa.toolkit.plugins.autoconfig.util.cli.HelpFormatter;
import com.meidusa.toolkit.plugins.autoconfig.util.cli.OptionBuilder;
import com.meidusa.toolkit.plugins.autoconfig.util.cli.Options;
import com.meidusa.toolkit.plugins.autoconfig.util.cli.ParseException;
import com.meidusa.toolkit.plugins.autoconfig.util.cli.PosixParser;

import java.io.PrintWriter;

/**
 * autoconfigн
 * 
 * 
 */
public class CLIManager {
	public static final String PRE_FIX = "config.";
	public static final String OPT_HELP = PRE_FIX + "h";
	public static final String OPT_INCLUDE_PACKAGES = PRE_FIX + "p";
	public static final String OPT_EXCLUDE_PACKAGES = PRE_FIX + "P";
	public static final String OPT_INCLUDE_DESCRIPTORS = PRE_FIX + "d";
	public static final String OPT_EXCLUDE_DESCRIPTORS = PRE_FIX + "D";
	public static final String OPT_TEXT_MODE = PRE_FIX + "t";
	public static final String OPT_GUI_MODE = PRE_FIX + "g";
	public static final String OPT_INTERACTIVE_MODE = PRE_FIX + "i";
	public static final String OPT_NON_INTERACTIVE_MODE = PRE_FIX + "I";
	public static final String OPT_VERBOSE = PRE_FIX + "v";
	public static final String OPT_CHARSET = PRE_FIX + "c";
	public static final String OPT_USER_PROPERTIES = PRE_FIX + "u";
	public static final String OPT_SKIP = PRE_FIX + "s";
	private Options options;

	public CLIManager() {
		OptionBuilder builder = new OptionBuilder();

		options = new Options();

		options.addOption(builder.withLongOpt("help").withDescription("ʾϢ")
				.create(OPT_HELP));

		options.addOption(builder
				.withLongOpt("include-descriptors")
				.hasArg()
				.withDescription(
						"Щļ磺conf/auto-config.xmlʹ***?ͨжöŷָ")
				.create(OPT_INCLUDE_DESCRIPTORS));

		options.addOption(builder.withLongOpt("exclude-descriptors").hasArg()
				.withDescription("ųЩļʹ***?ͨжöŷָ")
				.create(OPT_EXCLUDE_DESCRIPTORS));

		options.addOption(builder
				.withLongOpt("include-packages")
				.hasArg()
				.withDescription(
						"Щļ磺target/*.warʹ***?ͨжöŷָ")
				.create(OPT_INCLUDE_PACKAGES));

		options.addOption(builder.withLongOpt("exclude-packages").hasArg()
				.withDescription("ųЩļʹ***?ͨжöŷָ")
				.create(OPT_EXCLUDE_PACKAGES));

		options.addOption(builder.withLongOpt("interactive").hasOptionalArg()
				.withDescription("ģʽauto|on|offĬΪauto޲ʾon")
				.create(OPT_INTERACTIVE_MODE));

		options.addOption(builder.withLongOpt("non-interactive")
				.withDescription("ǽģʽ൱--interactive=off")
				.create(OPT_NON_INTERACTIVE_MODE));

		options.addOption(builder.withLongOpt("gui")
				.withDescription("ͼû棨ģʽ").create(OPT_GUI_MODE));

		options.addOption(builder.withLongOpt("text")
				.withDescription("ıû棨ģʽ").create(OPT_TEXT_MODE));

		options.addOption(builder.withLongOpt("verbose")
				.withDescription("ʾϢ").create(OPT_VERBOSE));

		options.addOption(builder.withLongOpt("charset")
				.withDescription("/ַ").create(OPT_CHARSET));

		options.addOption(builder.withLongOpt("userprop").hasArg()
				.withDescription("ûļ").create(OPT_USER_PROPERTIES));
		options.addOption(builder.withLongOpt("skip").hasArg()
				.withDescription("Auto-config").create(OPT_SKIP));
	}

	public CommandLine parse(String[] args) {
		CommandLine cli;

		try {
			cli = new PosixParser().parse(options, args);
			cli.putAll(System.getProperties());
		} catch (ParseException e) {
			throw new CLIException(e);
		}

		return cli;
	}

	public void help(PrintWriter out) {
		HelpFormatter formatter = new HelpFormatter();

		formatter.defaultSyntaxPrefix = "ʹ÷";

		formatter.printHelp(out, HelpFormatter.DEFAULT_WIDTH,
				"autoconfig [ѡ] [Ŀ¼|ļ]\n", "ѡ", options,
				HelpFormatter.DEFAULT_LEFT_PAD, HelpFormatter.DEFAULT_DESC_PAD,
				"\n");
	}
}
