package com.meidusa.toolkit.plugins.autoconfig;

import com.meidusa.toolkit.plugins.autoconfig.entry.ConfigEntryFactory;
import com.meidusa.toolkit.plugins.autoconfig.util.PatternSet;

import java.io.BufferedReader;
import java.io.File;
import java.io.PrintWriter;
import java.util.Properties;

public interface ConfigSettings extends ConfigLogger {
    BufferedReader getIn();

    PrintWriter getOut();

    PrintWriter getErr();

    String getCharset();

    PatternSet getDescriptorPatterns();

    PatternSet getPackagePatterns();

    String getInteractiveMode();

    String getMode();

    File[] getDestFiles();

    File getUserPropertiesFile();

    String getUserPropertiesFileCharset();

    boolean isVerbose();

    ConfigEntryFactory getConfigEntryFactory();
    
    Properties getProperties();
    
    File getProjectPath();
}
