/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.io;

import com.meidusa.toolkit.net.io.AbstractPacketMetaData;
import com.meidusa.toolkit.net.io.PacketInputStream;

public class FramedInputStream
extends PacketInputStream {
    private boolean readPackedWithHead;
    private AbstractPacketMetaData metaData;
    private int headSize = 0;

    public FramedInputStream(AbstractPacketMetaData metaData, boolean readPackedWithHead) {
        this.readPackedWithHead = readPackedWithHead;
        this._buffer.order(metaData.getByteOrder());
        this.metaData = metaData;
        this.headSize = metaData.getHeaderSize();
    }

    @Override
    protected int decodeLength() {
        if (this._have < this.headSize) {
            return -1;
        }
        int length = this.metaData.decodeLength(this._buffer);
        this._buffer.position(this._have);
        return length;
    }

    @Override
    public int getHeaderSize() {
        return this.headSize;
    }

    @Override
    protected boolean checkForCompletePacket() {
        if (this._length == -1 || this._have < this._length) {
            return false;
        }
        if (this.readPackedWithHead) {
            this._buffer.position(0);
        } else {
            this._buffer.position(this.headSize);
        }
        this._buffer.limit(this._length);
        return true;
    }
}

