/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.toolkit.net.authenticate.server;

import com.meidusa.toolkit.net.AuthingableConnection;
import com.meidusa.toolkit.net.authenticate.server.AuthResponseData;
import com.meidusa.toolkit.net.authenticate.server.AuthenticateFilter;
import com.meidusa.toolkit.net.authenticate.server.AuthenticateProvider;
import com.meidusa.toolkit.net.packet.AbstractPacket;
import org.apache.log4j.Logger;

public abstract class AbstractAuthenticateProvider<T extends AbstractPacket>
implements AuthenticateProvider<T> {
    public static final String SERVER_ERROR = "m.server_error";
    protected static Logger log = Logger.getLogger(AbstractAuthenticateProvider.class);
    private AuthenticateFilter filter;

    @Override
    public boolean authenticateConnection(AuthingableConnection conn, T authenPacket) {
        AuthResponseData rdata = this.createResponseData();
        try {
            if (authenPacket == null) {
                this.whenClientIllegalPacket(rdata);
                return false;
            }
            if (this.doFilte(conn, rdata)) {
                this.processAuthentication(conn, authenPacket, rdata);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.warn((Object)"Error authenticating", (Throwable)e);
            this.whenServerException(e, rdata);
            return false;
        }
        finally {
            conn.afterAuthing(rdata);
        }
    }

    protected void whenServerException(Exception e, AuthResponseData response) {
        response.code = 500;
        response.message = e.getMessage();
    }

    protected void whenClientIllegalPacket(AuthResponseData rdata) {
        rdata.code = 403;
        rdata.message = "authen packet type error";
    }

    public AuthenticateFilter getFilter() {
        return this.filter;
    }

    public void setFilter(AuthenticateFilter filter) {
        this.filter = filter;
    }

    protected AuthResponseData createResponseData() {
        return new AuthResponseData();
    }

    protected boolean doFilte(AuthingableConnection conn, AuthResponseData rdata) {
        return this.filter != null ? this.filter.doFilte(conn, rdata) : true;
    }

    protected abstract void processAuthentication(AuthingableConnection var1, T var2, AuthResponseData var3);
}

