/**
 * <pre>
 * 	This program is free software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version. 
 * 
 * 	This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details. 
 * 	You should have received a copy of the GNU General Public License along with this program; 
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * </pre>
 */
package com.meidusa.toolkit.net.util;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/**
 * Ϊ߳ṩѭĻܣܹһ򵥵ѭ صÿһͨѭ¼߳̿׵ذŴ¼С
 */
public class LoopingThread extends Thread {

    private static Logger log      = Logger.getLogger(LoopingThread.class);

    protected boolean     _running = true;

    public LoopingThread(){
    }

    /**
     * ָһ
     */
    public LoopingThread(String name){
        super(name);
    }

    /**
     * رո̣߳˴󲢷̷߳Ҫص顣
     */
    public synchronized void shutdown() {
        _running = false;

        // only kick the thread if it's not requesting it's own shutdown
        if (this != Thread.currentThread()) {
            kick();
        }
    }

    /**
     * ѭ
     */
    public void run() {
    	Level level = log.getLevel();
        log.setLevel(Level.INFO);
        log.info(this.getName() + " LoopingThread willStart....");
        log.setLevel(level);
        try {
            willStart();

            while (isRunning()) {
                try {
                    iterate();
                } catch (Throwable e) {
                    handleIterateFailure(e);
                }
            }
        } finally {
            didShutdown();
        }
    }

    /**
     * ߳Ƿ״̬÷falseʱ߳iterateã˳ѭ Ϊѭ̵߳һ {@link #run}
     */
    public synchronized boolean isRunning() {
        return _running;
    }

    /**
     * ߳˳ʱҪڲ߽
     */
    protected void kick() {
        // nothing doing by default
    }

    /**
     * ߳ڿʼִеʱ򣬿һЩʼĶ
     */
    protected void willStart() {
    }

    protected void iterate() {
        throw new RuntimeException("Derived class must implement iterate().");
    }

    protected void handleIterateFailure(Throwable e) {
        // log the exception

        // and shut the thread down
        log.error("error:", e);
        shutdown();
    }

    /**
     * shutdownԺ󡣼˳̵߳С
     */
    protected void didShutdown() {
    }

}
