/*
 * 	This program is free software; you can redistribute it and/or modify it under the terms of 
 * the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version. 
 * 
 * 	This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU General Public License for more details. 
 * 	You should have received a copy of the GNU General Public License along with this program; 
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package com.meidusa.toolkit.net.io;

import java.nio.ByteBuffer;

import com.meidusa.toolkit.net.io.PacketOutputStream;

/**
 * 
 * @author <a href=mailto:piratebase@sina.com>Struct chen</a>
 * 
 */
public class FramingOutputStream extends PacketOutputStream{
	protected boolean packetwrittenWithHead;
	private AbstractPacketMetaData metaData;
	
	/**
	 * 
	 * @param packetwrittenWithHead дݵʱǷдͷϢtrue--ʾдݵʱѾ˰ͷϢ
	 * 							   Ҫڵ{@link #returnPacketBuffer()} ʱҪʵʱɰͷϢ
	 */
	public FramingOutputStream(AbstractPacketMetaData metaData ,boolean packetwrittenWithHead){
		this.packetwrittenWithHead = packetwrittenWithHead;
		this.metaData = metaData;
		this._buffer.order(metaData.getByteOrder());
		resetPacket();
	}
	
	public ByteBuffer returnPacketBuffer ()
    {
        // flip the buffer which will limit it to it's current position
        _buffer.flip();
        if(!packetwrittenWithHead){
	        /**
	         *  ͷϢȣǲͷ
	         */
	        int count = _buffer.limit()-metaData.getHeaderSize();
	        _buffer.putInt(count);
        }
        _buffer.rewind();
        return _buffer;
    }
	
	public void initHeader(){
		if(!packetwrittenWithHead){
			this.write(metaData.getHeadPad(), 0, metaData.getHeaderSize());
		}
    }
}
