package com.meidusa.toolkit.net;

import java.nio.channels.SocketChannel;

import org.apache.log4j.Logger;

public abstract class SocketConnection extends Connection {
	private static Logger logger = Logger.getLogger(SocketConnection.class);

	public SocketConnection(SocketChannel channel, long createStamp) {
		super(channel, createStamp);
		try {
			SocketChannel schannel = (SocketChannel) this.getChannel();
			remoteHost = schannel.socket().getInetAddress().getHostAddress();
			port = schannel.socket().getPort();
		} catch (Exception e) {
			logger.error("socket not connect", e);
		}
	}
}
