package com.meidusa.toolkit.net;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public abstract class ClientSideConnection extends Connection implements MessageHandler{

	private BlockingQueue<byte[]> inputQueue = new LinkedBlockingQueue<byte[]>();
	private long timeout;
	public ClientSideConnection(SocketChannel channel, long createStamp) {
		super(channel, createStamp);
		this.setMessageHandler(this);
	}
	
	public void setSoTimeout(long mils){
		this.timeout = mils;
	}
	
	public void ping(long now) {

	}

	public void handleMessage(Connection conn, byte[] message) {
		inputQueue.offer(message);
	}
	
	/**
	 * 
	 * @see  BlockingQueue#poll(long, TimeUnit)
	 * @return
	 * @throws IOException
	 */
	public byte[] readPacket() throws IOException{
		try {
			byte[] message = null;
			if(timeout >0){
				message = inputQueue.poll(timeout, TimeUnit.MILLISECONDS);
			}else{
				message = inputQueue.poll();
			}
			if(message == null){
				throw new IOException("read Packet timeout");
			}
			return message;
		} catch (InterruptedException e) {
			return null;
		}
	}
	
	public boolean hasPacket(){
		return inputQueue.size()>0;
	}
	
	public void write(byte[] message){
		this.postMessage(message);
	}

}
