package com.meidusa.toolkit.net;
import java.io.IOException;
import java.nio.channels.SocketChannel;

/**
 * Ҫȴ֤ӹ
 * @author struct
 *
 */
public abstract class AuthingableConnectionFactory extends AbstractConnectionFactory {
	
	private int timeOut = 15000;

	public int getTimeOut() {
		return timeOut;
	}

	public void setTimeOut(int timeOut) {
		this.timeOut = timeOut;
	}

	public Connection createConnection(SocketChannel channel, long createStamp) throws IOException {
		AuthingableConnection connection = (AuthingableConnection) super.createConnection(channel, createStamp);
		connection.setAuthingTimeout(timeOut);
		waitforAuthenticate(connection);
		return connection;
	}

	
	
	protected void waitforAuthenticate(Connection connection){
		if(connection instanceof AuthingableConnection){ 
			AuthingableConnection authconn = (AuthingableConnection)connection;
			if(this.getTimeOut()>0){
				authconn.isAuthenticatedWithBlocked(this.getTimeOut());
			}
		}else{
			//connection.getConnectionManager().notifyObservers(ConnectionManager.CONNECTION_ESTABLISHED, connection, null);
		}
	}
}