/*
 * 	This program is free software; you can redistribute it and/or modify it under the terms of 
 * the GNU AFFERO GENERAL PUBLIC LICENSE as published by the Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version. 
 * 
 * 	This program is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * See the GNU AFFERO GENERAL PUBLIC LICENSE for more details. 
 * 	You should have received a copy of the GNU AFFERO GENERAL PUBLIC LICENSE along with this program; 
 * if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package com.meidusa.toolkit.net;

import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;

import com.meidusa.toolkit.net.authenticate.server.AuthResponseData;
import com.meidusa.toolkit.net.authenticate.server.AuthenticateProvider;
import com.meidusa.toolkit.net.authenticate.server.AuthenticationListener;
import com.meidusa.toolkit.net.packet.AbstractPacket;

/**
 * һɱʾǷ֤ͨConnection
 * @author <a href=mailto:piratebase@sina.com>Struct chen</a>
 *
 */
public abstract class AuthingableConnection extends Connection implements MessageHandler ,AuthenContext{
	private static Logger logger = Logger.getLogger(AuthingableConnection.class);
	protected boolean authenticated;//Ƿ֤ͨ
	private boolean authenticatedSeted = false;
	private int authingTimeout = 5 * 1000;
	private Object authenticatLock = new Object();
	private Map<Integer,AbstractPacket> authenContext = new HashMap<Integer,AbstractPacket>(2);
	private AuthenticateProvider authenticateProvider;
	private String lastError;
	public AuthingableConnection(SocketChannel channel, long createStamp){
		super(channel, createStamp);
	}

    public MessageHandler getMessageHandler() {
    	if(isAuthenticated()){
    		return super.getMessageHandler();
    	}else{
    		return this;
    	}
    }
    
	public AuthenticateProvider getAuthenticateProvider() {
		return authenticateProvider;
	}

	public void setAuthenticateProvider(AuthenticateProvider authenticateProvider) {
		this.authenticateProvider = authenticateProvider;
	}

	public int getAuthingTimeout() {
		return authingTimeout;
	}

	public void setAuthingTimeout(int authingTimeout) {
		this.authingTimeout = authingTimeout;
	}
	
	public boolean isAuthenticated(){
		return authenticated;
	}
	
	public boolean isAuthenticatedSeted() {
		return authenticatedSeted;
	}
	
	public void setAuthenticated(boolean authenticated){
		synchronized (authenticatLock) {
			authenticatedSeted = true;
			this.authenticated = authenticated;
			authenticatLock.notifyAll();
		}
	}
    
	protected void beforeAuthing() {
    }
	
    public void afterAuthing(AuthResponseData data) {
        if (AuthResponseData.SUCCESS == data.code) {
            setAuthenticated(true);
            connectionAuthenticateSuccess(data);
        } else {
            setAuthenticated(false);
            connectionAuthenticateFaild(data);
        }
    }
	
    protected void connectionAuthenticateSuccess(AuthResponseData data) {
        if (logger.isInfoEnabled()) {
            logger.info("Connection Authenticate success conn=" + this.getId() + ",hashCode="+this.hashCode());
        }
        afterAuthenticate();
    }

    protected void connectionAuthenticateFaild(AuthResponseData data) {
        if (logger.isInfoEnabled()) {
            logger.info("Connection Authenticate faild conn=" + this.getId() + ",hashCode="+this.hashCode());
        }
        afterAuthenticate();
    }

    public boolean isAuthenticatedWithBlocked(long timeout) {
		synchronized (authenticatLock) {
			if (authenticatedSeted){
				return authenticated;
			}
			try {
				authenticatLock.wait(timeout);
			} catch (InterruptedException e) {
			}
	
			if (!authenticatedSeted) {
				logger.warn("authenticate to server:" + this.getId() + " time out");
			}
			return authenticated;
		}
	}
    
    public void putStep(int step,AbstractPacket packet){
    	this.authenContext.put(step, packet);
    }
	
	public AbstractPacket getStep(int step){
		return this.authenContext.get(step);
	}
	
	public void afterAuthenticate(){
		authenContext.clear();
	}
}
