/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.util;

import com.meidusa.fastjson.JSON;
import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.JSONObject;
import com.meidusa.fastjson.PropertyNamingStrategy;
import com.meidusa.fastjson.annotation.JSONField;
import com.meidusa.fastjson.annotation.JSONType;
import com.meidusa.fastjson.parser.JSONScanner;
import com.meidusa.fastjson.parser.ParserConfig;
import com.meidusa.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import com.meidusa.fastjson.serializer.SerializeBeanInfo;
import com.meidusa.fastjson.util.FieldInfo;
import com.meidusa.fastjson.util.IOUtils;
import com.meidusa.fastmark.feature.Feature;
import com.meidusa.fastmark.feature.SerializerFeature;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessControlException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TypeUtils {
    public static boolean compatibleWithJavaBean = false;
    public static boolean compatibleWithFieldName = false;
    private static boolean setAccessibleEnable = true;
    private static boolean oracleTimestampMethodInited = false;
    private static Method oracleTimestampMethod;
    private static boolean oracleDateMethodInited;
    private static Method oracleDateMethod;
    private static boolean optionalClassInited;
    private static Class<?> optionalClass;
    private static ConcurrentMap<String, Class<?>> mappings;
    private static Class<?> pathClass;
    private static boolean pathClass_error;

    static {
        oracleDateMethodInited = false;
        optionalClassInited = false;
        mappings = new ConcurrentHashMap();
        TypeUtils.addBaseClassMappings();
        pathClass_error = false;
    }

    public static String castToString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static Byte castToByte(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).byteValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            return Byte.parseByte(strVal);
        }
        throw new JSONException("can not cast to byte, value : " + value);
    }

    public static Character castToChar(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character) {
            return (Character)value;
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0) {
                return null;
            }
            if (strVal.length() != 1) {
                throw new JSONException("can not cast to char, value : " + value);
            }
            return Character.valueOf(strVal.charAt(0));
        }
        throw new JSONException("can not cast to char, value : " + value);
    }

    public static Short castToShort(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            return Short.parseShort(strVal);
        }
        throw new JSONException("can not cast to short, value : " + value);
    }

    public static BigDecimal castToBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        String strVal = value.toString();
        if (strVal.length() == 0) {
            return null;
        }
        return new BigDecimal(strVal);
    }

    public static BigInteger castToBigInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        if (value instanceof Float || value instanceof Double) {
            return BigInteger.valueOf(((Number)value).longValue());
        }
        String strVal = value.toString();
        if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
            return null;
        }
        return new BigInteger(strVal);
    }

    public static Float castToFloat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            if (strVal.indexOf(44) != 0) {
                strVal = strVal.replaceAll(",", "");
            }
            return Float.valueOf(Float.parseFloat(strVal));
        }
        throw new JSONException("can not cast to float, value : " + value);
    }

    public static Double castToDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            String strVal = value.toString();
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            if (strVal.indexOf(44) != 0) {
                strVal = strVal.replaceAll(",", "");
            }
            return Double.parseDouble(strVal);
        }
        throw new JSONException("can not cast to double, value : " + value);
    }

    public static java.util.Date castToDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        long longValue = -1L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
            return new java.util.Date(longValue);
        }
        if (value instanceof String) {
            String strVal = (String)value;
            try (JSONScanner dateLexer = new JSONScanner(strVal);){
                if (dateLexer.scanISO8601DateIfMatch(false)) {
                    Calendar calendar = dateLexer.getCalendar();
                    java.util.Date date = calendar.getTime();
                    return date;
                }
            }
            if (strVal.startsWith("/Date(") && strVal.endsWith(")/")) {
                String dotnetDateStr;
                strVal = dotnetDateStr = strVal.substring(6, strVal.length() - 2);
            }
            if (strVal.indexOf(45) != -1) {
                String format = strVal.length() == JSON.DEFFAULT_DATE_FORMAT.length() ? JSON.DEFFAULT_DATE_FORMAT : (strVal.length() == 10 ? "yyyy-MM-dd" : (strVal.length() == "yyyy-MM-dd HH:mm:ss".length() ? "yyyy-MM-dd HH:mm:ss" : "yyyy-MM-dd HH:mm:ss.SSS"));
                SimpleDateFormat dateFormat = new SimpleDateFormat(format, JSON.defaultLocale);
                dateFormat.setTimeZone(JSON.defaultTimeZone);
                try {
                    return dateFormat.parse(strVal);
                }
                catch (ParseException e) {
                    throw new JSONException("can not cast to Date, value : " + strVal);
                }
            }
            if (strVal.length() == 0) {
                return null;
            }
            longValue = Long.parseLong(strVal);
        }
        if (longValue < 0L) {
            Object result;
            Class<?> clazz = value.getClass();
            if ("oracle.sql.TIMESTAMP".equals(clazz.getName())) {
                block33: {
                    if (oracleTimestampMethod == null && !oracleTimestampMethodInited) {
                        try {
                            try {
                                oracleTimestampMethod = clazz.getMethod("toJdbc", new Class[0]);
                            }
                            catch (NoSuchMethodException dateLexer) {
                                oracleTimestampMethodInited = true;
                                break block33;
                            }
                        }
                        catch (Throwable format) {
                            oracleTimestampMethodInited = true;
                            throw format;
                        }
                        oracleTimestampMethodInited = true;
                    }
                }
                try {
                    result = oracleTimestampMethod.invoke(value, new Object[0]);
                }
                catch (Exception e) {
                    throw new JSONException("can not cast oracle.sql.TIMESTAMP to Date", e);
                }
                return (java.util.Date)result;
            }
            if ("oracle.sql.DATE".equals(clazz.getName())) {
                block35: {
                    if (oracleDateMethod == null && !oracleDateMethodInited) {
                        try {
                            try {
                                oracleDateMethod = clazz.getMethod("toJdbc", new Class[0]);
                            }
                            catch (NoSuchMethodException result2) {
                                oracleDateMethodInited = true;
                                break block35;
                            }
                        }
                        catch (Throwable e) {
                            oracleDateMethodInited = true;
                            throw e;
                        }
                        oracleDateMethodInited = true;
                    }
                }
                try {
                    result = oracleDateMethod.invoke(value, new Object[0]);
                }
                catch (Exception e) {
                    throw new JSONException("can not cast oracle.sql.DATE to Date", e);
                }
                return (java.util.Date)result;
            }
            throw new JSONException("can not cast to Date, value : " + value);
        }
        return new java.util.Date(longValue);
    }

    public static Date castToSqlDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        if (value instanceof Calendar) {
            return new Date(((Calendar)value).getTimeInMillis());
        }
        long longValue = 0L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            longValue = Long.parseLong(strVal);
        }
        if (longValue <= 0L) {
            throw new JSONException("can not cast to Date, value : " + value);
        }
        return new Date(longValue);
    }

    public static Timestamp castToTimestamp(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return new Timestamp(((Calendar)value).getTimeInMillis());
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        long longValue = 0L;
        if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            longValue = Long.parseLong(strVal);
        }
        if (longValue <= 0L) {
            throw new JSONException("can not cast to Date, value : " + value);
        }
        return new Timestamp(longValue);
    }

    public static Long castToLong(Object value) {
        block8: {
            if (value == null) {
                return null;
            }
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                String strVal = (String)value;
                if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                    return null;
                }
                if (strVal.indexOf(44) != 0) {
                    strVal = strVal.replaceAll(",", "");
                }
                try {
                    return Long.parseLong(strVal);
                }
                catch (NumberFormatException numberFormatException) {
                    JSONScanner dateParser = new JSONScanner(strVal);
                    Calendar calendar = null;
                    if (dateParser.scanISO8601DateIfMatch(false)) {
                        calendar = dateParser.getCalendar();
                    }
                    dateParser.close();
                    if (calendar == null) break block8;
                    return calendar.getTimeInMillis();
                }
            }
        }
        throw new JSONException("can not cast to long, value : " + value);
    }

    public static Integer castToInt(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            if (strVal.indexOf(44) != 0) {
                strVal = strVal.replaceAll(",", "");
            }
            return Integer.parseInt(strVal);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        throw new JSONException("can not cast to int, value : " + value);
    }

    public static byte[] castToBytes(Object value) {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof String) {
            return IOUtils.decodeBase64((String)value);
        }
        throw new JSONException("can not cast to int, value : " + value);
    }

    public static Boolean castToBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            if (((Number)value).intValue() == 1) {
                return true;
            }
            return false;
        }
        if (value instanceof String) {
            String strVal = (String)value;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            if ("true".equalsIgnoreCase(strVal) || "1".equals(strVal)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(strVal) || "0".equals(strVal)) {
                return Boolean.FALSE;
            }
        }
        throw new JSONException("can not cast to boolean, value : " + value);
    }

    public static <T> T castToJavaBean(Object obj, Class<T> clazz) {
        return TypeUtils.cast(obj, clazz, ParserConfig.getGlobalInstance());
    }

    public static <T> T cast(Object obj, Class<T> clazz, ParserConfig config) {
        if (obj == null) {
            return null;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        if (clazz == obj.getClass()) {
            return (T)obj;
        }
        if (obj instanceof Map) {
            if (clazz == Map.class) {
                return (T)obj;
            }
            Map map = (Map)obj;
            if (clazz == Object.class && !map.containsKey(JSON.DEFAULT_TYPE_KEY)) {
                return (T)obj;
            }
            return TypeUtils.castToJavaBean((Map)obj, clazz, config);
        }
        if (clazz.isArray()) {
            if (obj instanceof Collection) {
                Collection collection = (Collection)obj;
                int index = 0;
                Object array = Array.newInstance(clazz.getComponentType(), collection.size());
                for (Object item : collection) {
                    Object value = TypeUtils.cast(item, clazz.getComponentType(), config);
                    Array.set(array, index, value);
                    ++index;
                }
                return (T)array;
            }
            if (clazz == byte[].class) {
                return (T)TypeUtils.castToBytes(obj);
            }
        }
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)TypeUtils.castToBoolean(obj);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return (T)TypeUtils.castToByte(obj);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return (T)TypeUtils.castToShort(obj);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return (T)TypeUtils.castToInt(obj);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return (T)TypeUtils.castToLong(obj);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (T)TypeUtils.castToFloat(obj);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return (T)TypeUtils.castToDouble(obj);
        }
        if (clazz == String.class) {
            return (T)TypeUtils.castToString(obj);
        }
        if (clazz == BigDecimal.class) {
            return (T)TypeUtils.castToBigDecimal(obj);
        }
        if (clazz == BigInteger.class) {
            return (T)TypeUtils.castToBigInteger(obj);
        }
        if (clazz == java.util.Date.class) {
            return (T)TypeUtils.castToDate(obj);
        }
        if (clazz == Date.class) {
            return (T)TypeUtils.castToSqlDate(obj);
        }
        if (clazz == Timestamp.class) {
            return (T)TypeUtils.castToTimestamp(obj);
        }
        if (clazz.isEnum()) {
            return TypeUtils.castToEnum(obj, clazz, config);
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            Calendar calendar;
            java.util.Date date = TypeUtils.castToDate(obj);
            if (clazz == Calendar.class) {
                calendar = Calendar.getInstance(JSON.defaultTimeZone, JSON.defaultLocale);
            } else {
                try {
                    calendar = (Calendar)clazz.newInstance();
                }
                catch (Exception e) {
                    throw new JSONException("can not cast to : " + clazz.getName(), e);
                }
            }
            calendar.setTime(date);
            return (T)calendar;
        }
        if (obj instanceof String) {
            String strVal = (String)obj;
            if (strVal.length() == 0 || "null".equals(strVal) || "NULL".equals(strVal)) {
                return null;
            }
            if (clazz == Currency.class) {
                return (T)Currency.getInstance(strVal);
            }
        }
        throw new JSONException("can not cast to : " + clazz.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T castToEnum(Object obj, Class<T> clazz, ParserConfig mapping) {
        try {
            T[] values;
            if (obj instanceof String) {
                String name = (String)obj;
                if (name.length() != 0) return Enum.valueOf(clazz, name);
                return null;
            }
            if (!(obj instanceof Number)) throw new JSONException("can not cast to : " + clazz.getName());
            int ordinal = ((Number)obj).intValue();
            if (ordinal >= (values = clazz.getEnumConstants()).length) throw new JSONException("can not cast to : " + clazz.getName());
            return values[ordinal];
        }
        catch (Exception ex) {
            throw new JSONException("can not cast to : " + clazz.getName(), ex);
        }
    }

    public static <T> T cast(Object obj, Type type, ParserConfig mapping) {
        String strVal;
        if (obj == null) {
            return null;
        }
        if (type instanceof Class) {
            return TypeUtils.cast(obj, (Class)type, mapping);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.cast(obj, (ParameterizedType)type, mapping);
        }
        if (obj instanceof String && ((strVal = (String)obj).length() == 0 || "null".equals(strVal) || "NULL".equals(strVal))) {
            return null;
        }
        if (type instanceof TypeVariable) {
            return (T)obj;
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static <T> T cast(Object obj, ParameterizedType type, ParserConfig mapping) {
        Type argType;
        String strVal;
        Type rawTye = type.getRawType();
        if (rawTye == Set.class || rawTye == HashSet.class || rawTye == TreeSet.class || rawTye == List.class || rawTye == ArrayList.class) {
            Type itemType = type.getActualTypeArguments()[0];
            if (obj instanceof Iterable) {
                AbstractCollection collection = rawTye == Set.class || rawTye == HashSet.class ? new HashSet() : (rawTye == TreeSet.class ? new TreeSet() : new ArrayList());
                for (Object item : (Iterable)obj) {
                    collection.add(TypeUtils.cast(item, itemType, mapping));
                }
                return (T)collection;
            }
        }
        if (rawTye == Map.class || rawTye == HashMap.class) {
            Type keyType = type.getActualTypeArguments()[0];
            Type valueType = type.getActualTypeArguments()[1];
            if (obj instanceof Map) {
                HashMap<T, T> map = new HashMap<T, T>();
                for (Map.Entry entry : ((Map)obj).entrySet()) {
                    T key = TypeUtils.cast(entry.getKey(), keyType, mapping);
                    T value = TypeUtils.cast(entry.getValue(), valueType, mapping);
                    map.put(key, value);
                }
                return (T)map;
            }
        }
        if (obj instanceof String && (strVal = (String)obj).length() == 0) {
            return null;
        }
        if (type.getActualTypeArguments().length == 1 && (argType = type.getActualTypeArguments()[0]) instanceof WildcardType) {
            return TypeUtils.cast(obj, rawTye, mapping);
        }
        throw new JSONException("can not cast to : " + type);
    }

    public static <T> T castToJavaBean(Map<String, Object> map, Class<T> clazz, ParserConfig config) {
        try {
            if (clazz == StackTraceElement.class) {
                String declaringClass = (String)map.get("className");
                String methodName = (String)map.get("methodName");
                String fileName = (String)map.get("fileName");
                Number value = (Number)map.get("lineNumber");
                int lineNumber = value == null ? 0 : value.intValue();
                return (T)new StackTraceElement(declaringClass, methodName, fileName, lineNumber);
            }
            Object iClassObject = map.get(JSON.DEFAULT_TYPE_KEY);
            if (iClassObject instanceof String) {
                String className = (String)iClassObject;
                Class<?> loadClazz = TypeUtils.loadClass(className);
                if (loadClazz == null) {
                    throw new ClassNotFoundException(String.valueOf(className) + " not found");
                }
                if (!loadClazz.equals(clazz)) {
                    return (T)TypeUtils.castToJavaBean(map, loadClazz, config);
                }
            }
            if (clazz.isInterface()) {
                JSONObject object = map instanceof JSONObject ? (JSONObject)map : new JSONObject(map);
                return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)object);
            }
            if (config == null) {
                config = ParserConfig.getGlobalInstance();
            }
            JavaBeanDeserializer javaBeanDeser = null;
            ObjectDeserializer deserizer = config.getDeserializer(clazz);
            if (deserizer instanceof JavaBeanDeserializer) {
                javaBeanDeser = (JavaBeanDeserializer)deserizer;
            }
            if (javaBeanDeser == null) {
                throw new JSONException("can not get javaBeanDeserializer");
            }
            return (T)javaBeanDeser.createInstance(map, config);
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    private static void addBaseClassMappings() {
        mappings.put("byte", Byte.TYPE);
        mappings.put("short", Short.TYPE);
        mappings.put("int", Integer.TYPE);
        mappings.put("long", Long.TYPE);
        mappings.put("float", Float.TYPE);
        mappings.put("double", Double.TYPE);
        mappings.put("boolean", Boolean.TYPE);
        mappings.put("char", Character.TYPE);
        mappings.put("[byte", byte[].class);
        mappings.put("[short", short[].class);
        mappings.put("[int", int[].class);
        mappings.put("[long", long[].class);
        mappings.put("[float", float[].class);
        mappings.put("[double", double[].class);
        mappings.put("[boolean", boolean[].class);
        mappings.put("[char", char[].class);
        mappings.put(HashMap.class.getName(), HashMap.class);
    }

    public static void clearClassMapping() {
        mappings.clear();
        TypeUtils.addBaseClassMappings();
    }

    public static Class<?> loadClass(String className) {
        return TypeUtils.loadClass(className, null);
    }

    public static boolean isPath(Class<?> clazz) {
        if (pathClass == null && !pathClass_error) {
            try {
                pathClass = Class.forName("java.nio.file.Path");
            }
            catch (Throwable ex) {
                pathClass_error = true;
            }
        }
        if (pathClass != null) {
            return pathClass.isAssignableFrom(clazz);
        }
        return false;
    }

    public static Class<?> loadClass(String className, ClassLoader classLoader) {
        if (className == null || className.length() == 0) {
            return null;
        }
        Class<?> clazz = (Class<?>)mappings.get(className);
        if (clazz != null) {
            return clazz;
        }
        if (className.charAt(0) == '[') {
            Class<?> componentType = TypeUtils.loadClass(className.substring(1), classLoader);
            return Array.newInstance(componentType, 0).getClass();
        }
        if (className.startsWith("L") && className.endsWith(";")) {
            String newClassName = className.substring(1, className.length() - 1);
            return TypeUtils.loadClass(newClassName, classLoader);
        }
        try {
            if (classLoader != null) {
                clazz = classLoader.loadClass(className);
                mappings.put(className, clazz);
                return clazz;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                clazz = contextClassLoader.loadClass(className);
                mappings.put(className, clazz);
                return clazz;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            clazz = Class.forName(className);
            mappings.put(className, clazz);
            return clazz;
        }
        catch (Throwable throwable) {
            return clazz;
        }
    }

    public static SerializeBeanInfo buildBeanInfo(Class<?> beanType, Map<String, String> aliasMap, PropertyNamingStrategy propertyNamingStrategy) {
        List<FieldInfo> sortedFieldList;
        int features;
        JSONType jsonType = beanType.getAnnotation(JSONType.class);
        HashMap<String, Field> fieldCacheMap = new HashMap<String, Field>();
        ParserConfig.parserAllFieldToCache(beanType, fieldCacheMap);
        List<FieldInfo> fieldInfoList = TypeUtils.computeGetters(beanType, jsonType, aliasMap, fieldCacheMap, false, propertyNamingStrategy);
        Object[] fields = new FieldInfo[fieldInfoList.size()];
        fieldInfoList.toArray(fields);
        String[] orders = null;
        String typeName = null;
        if (jsonType != null) {
            orders = jsonType.orders();
            typeName = jsonType.typeName();
            if (typeName.length() == 0) {
                typeName = null;
            }
            features = SerializerFeature.of((SerializerFeature[])jsonType.serialzeFeatures());
        } else {
            features = 0;
        }
        if (orders != null && orders.length != 0) {
            sortedFieldList = TypeUtils.computeGetters(beanType, jsonType, aliasMap, fieldCacheMap, true, propertyNamingStrategy);
        } else {
            sortedFieldList = new ArrayList<FieldInfo>(fieldInfoList);
            Collections.sort(sortedFieldList);
        }
        Object[] sortedFields = new FieldInfo[sortedFieldList.size()];
        sortedFieldList.toArray(sortedFields);
        if (Arrays.equals(sortedFields, fields)) {
            sortedFields = fields;
        }
        return new SerializeBeanInfo(beanType, jsonType, typeName, features, (FieldInfo[])fields, (FieldInfo[])sortedFields);
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, JSONType jsonType, Map<String, String> aliasMap, Map<String, Field> fieldCacheMap, boolean sorted, PropertyNamingStrategy propertyNamingStrategy) {
        String item;
        int n;
        int n2;
        int parserFeatures;
        int serialzeFeatures;
        int ordinal;
        LinkedHashMap<String, FieldInfo> fieldInfoMap = new LinkedHashMap<String, FieldInfo>();
        AccessibleObject[] accessibleObjectArray = clazz.getMethods();
        int n3 = accessibleObjectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            block39: {
                JSONField fieldAnnotation;
                Field field;
                String propertyName;
                JSONField annotation;
                String label;
                Method method;
                block52: {
                    block53: {
                        String methodName;
                        block50: {
                            char c2;
                            block51: {
                                block49: {
                                    block42: {
                                        JSONField fieldAnnotation2;
                                        Field field2;
                                        block47: {
                                            block48: {
                                                char ch;
                                                block44: {
                                                    block46: {
                                                        char c3;
                                                        block45: {
                                                            block43: {
                                                                block40: {
                                                                    block41: {
                                                                        method = accessibleObjectArray[n4];
                                                                        methodName = method.getName();
                                                                        ordinal = 0;
                                                                        serialzeFeatures = 0;
                                                                        parserFeatures = 0;
                                                                        label = null;
                                                                        if (Modifier.isStatic(method.getModifiers()) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0 || method.getReturnType() == ClassLoader.class || method.getName().equals("getMetaClass") && method.getReturnType().getName().equals("groovy.lang.MetaClass")) break block39;
                                                                        annotation = method.getAnnotation(JSONField.class);
                                                                        if (annotation == null) {
                                                                            annotation = TypeUtils.getSuperMethodAnnotation(clazz, method);
                                                                        }
                                                                        if (annotation == null) break block40;
                                                                        if (!annotation.serialize()) break block39;
                                                                        ordinal = annotation.ordinal();
                                                                        serialzeFeatures = SerializerFeature.of((SerializerFeature[])annotation.serialzeFeatures());
                                                                        parserFeatures = Feature.of((Feature[])annotation.parseFeatures());
                                                                        if (annotation.name().length() == 0) break block41;
                                                                        String propertyName2 = annotation.name();
                                                                        if (aliasMap == null || (propertyName2 = aliasMap.get(propertyName2)) != null) {
                                                                            FieldInfo fieldInfo = new FieldInfo(propertyName2, method, null, clazz, null, ordinal, serialzeFeatures, parserFeatures, annotation, null, label);
                                                                            fieldInfoMap.put(propertyName2, fieldInfo);
                                                                        }
                                                                        break block39;
                                                                    }
                                                                    if (annotation.label().length() != 0) {
                                                                        label = annotation.label();
                                                                    }
                                                                }
                                                                if (!methodName.startsWith("get")) break block42;
                                                                if (methodName.length() < 4 || methodName.equals("getClass")) break block39;
                                                                c3 = methodName.charAt(3);
                                                                if (!Character.isUpperCase(c3) && c3 <= '\u0200') break block43;
                                                                propertyName = compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(3)) : String.valueOf(Character.toLowerCase(methodName.charAt(3))) + methodName.substring(4);
                                                                propertyName = TypeUtils.getPropertyNameByCompatibleFieldName(fieldCacheMap, methodName, propertyName, 3);
                                                                break block44;
                                                            }
                                                            if (c3 != '_') break block45;
                                                            propertyName = methodName.substring(4);
                                                            break block44;
                                                        }
                                                        if (c3 != 'f') break block46;
                                                        propertyName = methodName.substring(3);
                                                        break block44;
                                                    }
                                                    if (methodName.length() < 5 || !Character.isUpperCase(methodName.charAt(4))) break block39;
                                                    propertyName = TypeUtils.decapitalize(methodName.substring(3));
                                                }
                                                boolean ignore = TypeUtils.isJSONTypeIgnore(clazz, propertyName);
                                                if (ignore) break block39;
                                                field2 = ParserConfig.getFieldFromCache(propertyName, fieldCacheMap);
                                                if (field2 == null && propertyName.length() > 1 && (ch = propertyName.charAt(1)) >= 'A' && ch <= 'Z') {
                                                    String javaBeanCompatiblePropertyName = TypeUtils.decapitalize(methodName.substring(3));
                                                    field2 = ParserConfig.getFieldFromCache(javaBeanCompatiblePropertyName, fieldCacheMap);
                                                }
                                                fieldAnnotation2 = null;
                                                if (field2 == null || (fieldAnnotation2 = field2.getAnnotation(JSONField.class)) == null) break block47;
                                                if (!fieldAnnotation2.serialize()) break block39;
                                                ordinal = fieldAnnotation2.ordinal();
                                                serialzeFeatures = SerializerFeature.of((SerializerFeature[])fieldAnnotation2.serialzeFeatures());
                                                parserFeatures = Feature.of((Feature[])fieldAnnotation2.parseFeatures());
                                                if (fieldAnnotation2.name().length() == 0) break block48;
                                                propertyName = fieldAnnotation2.name();
                                                if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) break block39;
                                            }
                                            if (fieldAnnotation2.label().length() != 0) {
                                                label = fieldAnnotation2.label();
                                            }
                                        }
                                        if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) break block39;
                                        if (propertyNamingStrategy != null) {
                                            propertyName = propertyNamingStrategy.translate(propertyName);
                                        }
                                        FieldInfo fieldInfo = new FieldInfo(propertyName, method, field2, clazz, null, ordinal, serialzeFeatures, parserFeatures, annotation, fieldAnnotation2, label);
                                        fieldInfoMap.put(propertyName, fieldInfo);
                                    }
                                    if (!methodName.startsWith("is") || methodName.length() < 3 || method.getReturnType() != Boolean.TYPE && method.getReturnType() != Boolean.class) break block39;
                                    c2 = methodName.charAt(2);
                                    if (!Character.isUpperCase(c2)) break block49;
                                    propertyName = compatibleWithJavaBean ? TypeUtils.decapitalize(methodName.substring(2)) : String.valueOf(Character.toLowerCase(methodName.charAt(2))) + methodName.substring(3);
                                    propertyName = TypeUtils.getPropertyNameByCompatibleFieldName(fieldCacheMap, methodName, propertyName, 2);
                                    break block50;
                                }
                                if (c2 != '_') break block51;
                                propertyName = methodName.substring(3);
                                break block50;
                            }
                            if (c2 != 'f') break block39;
                            propertyName = methodName.substring(2);
                        }
                        field = ParserConfig.getFieldFromCache(propertyName, fieldCacheMap);
                        if (field == null) {
                            field = ParserConfig.getFieldFromCache(methodName, fieldCacheMap);
                        }
                        fieldAnnotation = null;
                        if (field == null || (fieldAnnotation = field.getAnnotation(JSONField.class)) == null) break block52;
                        if (!fieldAnnotation.serialize()) break block39;
                        ordinal = fieldAnnotation.ordinal();
                        serialzeFeatures = SerializerFeature.of((SerializerFeature[])fieldAnnotation.serialzeFeatures());
                        parserFeatures = Feature.of((Feature[])fieldAnnotation.parseFeatures());
                        if (fieldAnnotation.name().length() == 0) break block53;
                        propertyName = fieldAnnotation.name();
                        if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) break block39;
                    }
                    if (fieldAnnotation.label().length() != 0) {
                        label = fieldAnnotation.label();
                    }
                }
                if (aliasMap == null || (propertyName = aliasMap.get(propertyName)) != null) {
                    if (propertyNamingStrategy != null) {
                        propertyName = propertyNamingStrategy.translate(propertyName);
                    }
                    if (!fieldInfoMap.containsKey(propertyName)) {
                        FieldInfo fieldInfo = new FieldInfo(propertyName, method, field, clazz, null, ordinal, serialzeFeatures, parserFeatures, annotation, fieldAnnotation, label);
                        fieldInfoMap.put(propertyName, fieldInfo);
                    }
                }
            }
            ++n4;
        }
        accessibleObjectArray = clazz.getFields();
        n3 = accessibleObjectArray.length;
        n4 = 0;
        while (n4 < n3) {
            block54: {
                String label;
                String propertyName;
                JSONField fieldAnnotation;
                AccessibleObject field;
                block55: {
                    field = accessibleObjectArray[n4];
                    if (Modifier.isStatic(((Field)field).getModifiers())) break block54;
                    fieldAnnotation = ((Field)field).getAnnotation(JSONField.class);
                    ordinal = 0;
                    serialzeFeatures = 0;
                    parserFeatures = 0;
                    propertyName = ((Field)field).getName();
                    label = null;
                    if (fieldAnnotation == null) break block55;
                    if (!fieldAnnotation.serialize()) break block54;
                    ordinal = fieldAnnotation.ordinal();
                    serialzeFeatures = SerializerFeature.of((SerializerFeature[])fieldAnnotation.serialzeFeatures());
                    parserFeatures = Feature.of((Feature[])fieldAnnotation.parseFeatures());
                    if (fieldAnnotation.name().length() != 0) {
                        propertyName = fieldAnnotation.name();
                    }
                    if (fieldAnnotation.label().length() != 0) {
                        label = fieldAnnotation.label();
                    }
                }
                if (aliasMap == null || (propertyName = aliasMap.get(propertyName)) != null) {
                    if (propertyNamingStrategy != null) {
                        propertyName = propertyNamingStrategy.translate(propertyName);
                    }
                    if (!fieldInfoMap.containsKey(propertyName)) {
                        FieldInfo fieldInfo = new FieldInfo(propertyName, null, (Field)field, clazz, null, ordinal, serialzeFeatures, parserFeatures, null, fieldAnnotation, label);
                        fieldInfoMap.put(propertyName, fieldInfo);
                    }
                }
            }
            ++n4;
        }
        ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
        boolean containsAll = false;
        String[] orders = null;
        JSONType annotation = clazz.getAnnotation(JSONType.class);
        if (annotation != null) {
            orders = annotation.orders();
            if (orders != null && orders.length == fieldInfoMap.size()) {
                containsAll = true;
                String[] stringArray = orders;
                n2 = orders.length;
                n = 0;
                while (n < n2) {
                    item = stringArray[n];
                    if (!fieldInfoMap.containsKey(item)) {
                        containsAll = false;
                        break;
                    }
                    ++n;
                }
            } else {
                containsAll = false;
            }
        }
        if (containsAll) {
            String[] stringArray = orders;
            n2 = orders.length;
            n = 0;
            while (n < n2) {
                item = stringArray[n];
                FieldInfo fieldInfo = (FieldInfo)fieldInfoMap.get(item);
                fieldInfoList.add(fieldInfo);
                ++n;
            }
        } else {
            for (FieldInfo fieldInfo : fieldInfoMap.values()) {
                fieldInfoList.add(fieldInfo);
            }
            if (sorted) {
                Collections.sort(fieldInfoList);
            }
        }
        return fieldInfoList;
    }

    private static String getPropertyNameByCompatibleFieldName(Map<String, Field> fieldCacheMap, String methodName, String propertyName, int fromIdx) {
        if (compatibleWithFieldName && !fieldCacheMap.containsKey(propertyName)) {
            String tempPropertyName = methodName.substring(fromIdx);
            return fieldCacheMap.containsKey(tempPropertyName) ? tempPropertyName : propertyName;
        }
        return propertyName;
    }

    public static JSONField getSuperMethodAnnotation(Class<?> clazz, Method method) {
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces.length > 0) {
            Class<?>[] types = method.getParameterTypes();
            Class<?>[] classArray = interfaces;
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> interfaceClass = classArray[n2];
                Method[] methodArray = interfaceClass.getMethods();
                int n3 = methodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method interfaceMethod = methodArray[n4];
                    Class<?>[] interfaceTypes = interfaceMethod.getParameterTypes();
                    if (interfaceTypes.length == types.length && interfaceMethod.getName().equals(method.getName())) {
                        JSONField annotation;
                        boolean match = true;
                        int i = 0;
                        while (i < types.length) {
                            if (!interfaceTypes[i].equals(types[i])) {
                                match = false;
                                break;
                            }
                            ++i;
                        }
                        if (match && (annotation = interfaceMethod.getAnnotation(JSONField.class)) != null) {
                            return annotation;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    private static boolean isJSONTypeIgnore(Class<?> clazz, String propertyName) {
        JSONType jsonType = clazz.getAnnotation(JSONType.class);
        if (jsonType != null) {
            String[] fields = jsonType.includes();
            if (fields.length > 0) {
                int i = 0;
                while (i < fields.length) {
                    if (propertyName.equals(fields[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            fields = jsonType.ignores();
            int i = 0;
            while (i < fields.length) {
                if (propertyName.equals(fields[i])) {
                    return true;
                }
                ++i;
            }
        }
        return clazz.getSuperclass() != Object.class && clazz.getSuperclass() != null && TypeUtils.isJSONTypeIgnore(clazz.getSuperclass(), propertyName);
    }

    public static boolean isGenericParamType(Type type) {
        if (type instanceof ParameterizedType) {
            return true;
        }
        if (type instanceof Class) {
            Type superType = ((Class)type).getGenericSuperclass();
            if (superType == Object.class) {
                return false;
            }
            return TypeUtils.isGenericParamType(superType);
        }
        return false;
    }

    public static Type getGenericParamType(Type type) {
        if (type instanceof ParameterizedType) {
            return type;
        }
        if (type instanceof Class) {
            return TypeUtils.getGenericParamType(((Class)type).getGenericSuperclass());
        }
        return type;
    }

    public static Type unwrapOptional(Type type) {
        ParameterizedType parameterizedType;
        block7: {
            if (!optionalClassInited) {
                try {
                    try {
                        optionalClass = Class.forName("java.util.Optional");
                    }
                    catch (Exception exception) {
                        optionalClassInited = true;
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    optionalClassInited = true;
                    throw throwable;
                }
                optionalClassInited = true;
            }
        }
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() == optionalClass) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return type;
    }

    public static Class<?> getClass(Type type) {
        if (type.getClass() == Class.class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            Type boundType = ((TypeVariable)type).getBounds()[0];
            return (Class)boundType;
        }
        return Object.class;
    }

    public static Field getField(Class<?> clazz, String fieldName, Field[] declaredFields) {
        Field[] fieldArray = declaredFields;
        int n = declaredFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (fieldName.equals(field.getName())) {
                return field;
            }
            ++n2;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            return TypeUtils.getField(superClass, fieldName, superClass.getDeclaredFields());
        }
        return null;
    }

    public static int getSerializeFeatures(Class<?> clazz) {
        JSONType annotation = clazz.getAnnotation(JSONType.class);
        if (annotation == null) {
            return 0;
        }
        return SerializerFeature.of((SerializerFeature[])annotation.serialzeFeatures());
    }

    public static int getParserFeatures(Class<?> clazz) {
        JSONType annotation = clazz.getAnnotation(JSONType.class);
        if (annotation == null) {
            return 0;
        }
        return Feature.of((Feature[])annotation.parseFeatures());
    }

    public static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        if (name.length() > 1 && Character.isUpperCase(name.charAt(1)) && Character.isUpperCase(name.charAt(0))) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static void setAccessible(AccessibleObject obj) {
        if (!setAccessibleEnable) {
            return;
        }
        if (obj.isAccessible()) {
            return;
        }
        try {
            obj.setAccessible(true);
        }
        catch (AccessControlException error) {
            setAccessibleEnable = false;
        }
    }

    public static Class<?> getCollectionItemClass(Type fieldType) {
        if (fieldType instanceof ParameterizedType) {
            Class itemClass;
            Type actualTypeArgument = ((ParameterizedType)fieldType).getActualTypeArguments()[0];
            if (actualTypeArgument instanceof Class) {
                itemClass = (Class)actualTypeArgument;
                if (!Modifier.isPublic(itemClass.getModifiers())) {
                    throw new JSONException("can not create ASMParser");
                }
            } else {
                throw new JSONException("can not create ASMParser");
            }
            return itemClass;
        }
        return Object.class;
    }

    public static Collection createCollection(Type type) {
        Collection<Object> list;
        Class<AbstractCollection> rawClass = TypeUtils.getRawClass(type);
        if (rawClass == AbstractCollection.class || rawClass == Collection.class) {
            list = new ArrayList();
        } else if (rawClass.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (rawClass.isAssignableFrom(LinkedHashSet.class)) {
            list = new LinkedHashSet();
        } else if (rawClass.isAssignableFrom(TreeSet.class)) {
            list = new TreeSet();
        } else if (rawClass.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (rawClass.isAssignableFrom(EnumSet.class)) {
            Object itemType = type instanceof ParameterizedType ? ((ParameterizedType)type).getActualTypeArguments()[0] : Object.class;
            list = EnumSet.noneOf(itemType);
        } else {
            try {
                list = (Collection)rawClass.newInstance();
            }
            catch (Exception e) {
                throw new JSONException("create instance error, class " + rawClass.getName());
            }
        }
        return list;
    }

    public static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getRawClass(((ParameterizedType)type).getRawType());
        }
        throw new JSONException("TODO");
    }
}

