/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.type;

import com.meidusa.fastjson.type.DefinedParameterizedType;
import java.awt.List;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Map;
import java.util.Set;

public class DefinedParameterizedTypeBuilder {
    public static Type buildDefinedType(Type type, Map<TypeVariable<?>, Type> typeMap) {
        if (type instanceof ParameterizedType) {
            ParameterizedType castType = (ParameterizedType)type;
            DefinedParameterizedType definedParameterizedType = new DefinedParameterizedType();
            definedParameterizedType.setRawType((Class)castType.getRawType());
            definedParameterizedType.setOwnerType(castType.getOwnerType());
            Type[] actualTypes = castType.getActualTypeArguments();
            Type[] actualDefinedTypes = new Type[actualTypes.length];
            int i = 0;
            while (i < actualTypes.length) {
                if (actualTypes[i] instanceof Class) {
                    actualDefinedTypes[i] = actualTypes[i];
                } else if (actualTypes[i] instanceof TypeVariable) {
                    actualDefinedTypes[i] = typeMap.get(actualTypes[i]);
                    if (actualDefinedTypes[i] == null) {
                        Type[] bounds = ((TypeVariable)actualTypes[i]).getBounds();
                        Type[] organizedBounds = new Type[bounds.length];
                        int j = 0;
                        while (j < bounds.length) {
                            organizedBounds[i] = DefinedParameterizedTypeBuilder.buildDefinedType(bounds[0], typeMap);
                            ++j;
                        }
                        actualDefinedTypes[i] = DefinedParameterizedTypeBuilder.chooseFromBounds(organizedBounds);
                        actualDefinedTypes[i] = DefinedParameterizedTypeBuilder.buildDefinedType(actualDefinedTypes[i], typeMap);
                    }
                } else if (actualTypes[i] instanceof WildcardType) {
                    actualDefinedTypes[i] = DefinedParameterizedTypeBuilder.chooseFromBounds(((WildcardType)actualTypes[i]).getUpperBounds());
                    actualDefinedTypes[i] = DefinedParameterizedTypeBuilder.buildDefinedType(actualDefinedTypes[i], typeMap);
                } else if (actualTypes[i] instanceof ParameterizedType) {
                    actualDefinedTypes[i] = DefinedParameterizedTypeBuilder.buildDefinedType(actualTypes[i], typeMap);
                }
                ++i;
            }
            definedParameterizedType.setActualTypes(actualDefinedTypes);
            return definedParameterizedType;
        }
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof TypeVariable) {
            return typeMap.get(type);
        }
        if (type instanceof WildcardType) {
            return DefinedParameterizedTypeBuilder.chooseFromBounds(((WildcardType)type).getUpperBounds());
        }
        return null;
    }

    public static Type chooseFromBounds(Type[] types) {
        int i = 0;
        while (i < types.length) {
            Class typeRawClass = null;
            if (types[i] instanceof ParameterizedType) {
                typeRawClass = (Class)((ParameterizedType)types[i]).getRawType();
            } else if (types[i] instanceof Class) {
                typeRawClass = (Class)types[i];
            }
            if (typeRawClass != null) {
                if (!typeRawClass.isInterface()) {
                    return types[i];
                }
                if (typeRawClass == List.class || typeRawClass == Map.class || typeRawClass == Set.class) {
                    return types[i];
                }
            }
            ++i;
        }
        return Object.class;
    }

    public static void buildTypeVariableMap(Type type, Map<TypeVariable<?>, Type> map) {
        Class rawType = null;
        if (type instanceof ParameterizedType) {
            Type[] actualArguments = ((ParameterizedType)type).getActualTypeArguments();
            Type[] organizedArguments = new Type[actualArguments.length];
            int i = 0;
            while (i < actualArguments.length) {
                organizedArguments[i] = DefinedParameterizedTypeBuilder.buildDefinedType(actualArguments[i], map);
                ++i;
            }
            rawType = (Class)((ParameterizedType)type).getRawType();
            TypeVariable<Class<T>>[] variables = rawType.getTypeParameters();
            int i2 = 0;
            while (i2 < actualArguments.length) {
                map.put(variables[i2], organizedArguments[i2]);
                ++i2;
            }
        } else if (type instanceof Class) {
            rawType = (Class)type;
        }
        Type[] interfaces = rawType.getGenericInterfaces();
        Type superClass = rawType.getGenericSuperclass();
        int i = 0;
        while (i < interfaces.length) {
            DefinedParameterizedTypeBuilder.buildTypeVariableMap(interfaces[i], map);
            ++i;
        }
        if (superClass != null && superClass != Object.class) {
            DefinedParameterizedTypeBuilder.buildTypeVariableMap(superClass, map);
        }
    }
}

