/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.JSON;
import com.meidusa.fastjson.JSONAware;
import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.JSONStreamAware;
import com.meidusa.fastjson.PropertyNamingStrategy;
import com.meidusa.fastjson.annotation.JSONField;
import com.meidusa.fastjson.annotation.JSONType;
import com.meidusa.fastjson.serializer.ASMSerializerFactory;
import com.meidusa.fastjson.serializer.AppendableSerializer;
import com.meidusa.fastjson.serializer.ArraySerializer;
import com.meidusa.fastjson.serializer.AtomicCodec;
import com.meidusa.fastjson.serializer.AutowiredObjectSerializer;
import com.meidusa.fastjson.serializer.AwtCodec;
import com.meidusa.fastjson.serializer.BigDecimalCodec;
import com.meidusa.fastjson.serializer.BigIntegerCodec;
import com.meidusa.fastjson.serializer.BooleanCodec;
import com.meidusa.fastjson.serializer.CalendarCodec;
import com.meidusa.fastjson.serializer.CharacterCodec;
import com.meidusa.fastjson.serializer.ClobSeriliazer;
import com.meidusa.fastjson.serializer.CollectionCodec;
import com.meidusa.fastjson.serializer.DateCodec;
import com.meidusa.fastjson.serializer.DoubleSerializer;
import com.meidusa.fastjson.serializer.EnumSerializer;
import com.meidusa.fastjson.serializer.EnumerationSerializer;
import com.meidusa.fastjson.serializer.FieldSerializer;
import com.meidusa.fastjson.serializer.FloatCodec;
import com.meidusa.fastjson.serializer.IntegerCodec;
import com.meidusa.fastjson.serializer.JSONAwareSerializer;
import com.meidusa.fastjson.serializer.JSONSerializable;
import com.meidusa.fastjson.serializer.JSONSerializableSerializer;
import com.meidusa.fastjson.serializer.JavaBeanSerializer;
import com.meidusa.fastjson.serializer.ListSerializer;
import com.meidusa.fastjson.serializer.LongCodec;
import com.meidusa.fastjson.serializer.MapSerializer;
import com.meidusa.fastjson.serializer.MiscCodec;
import com.meidusa.fastjson.serializer.ObjectArrayCodec;
import com.meidusa.fastjson.serializer.ObjectSerializer;
import com.meidusa.fastjson.serializer.PrimitiveArraySerializer;
import com.meidusa.fastjson.serializer.ReferenceCodec;
import com.meidusa.fastjson.serializer.SerializeBeanInfo;
import com.meidusa.fastjson.serializer.SerializeFilter;
import com.meidusa.fastjson.serializer.SerializeFilterable;
import com.meidusa.fastjson.serializer.StringCodec;
import com.meidusa.fastjson.serializer.ToStringSerializer;
import com.meidusa.fastjson.support.springfox.SwaggerJsonSerializer;
import com.meidusa.fastjson.util.ASMUtils;
import com.meidusa.fastjson.util.FieldInfo;
import com.meidusa.fastjson.util.IdentityHashMap;
import com.meidusa.fastjson.util.ServiceLoader;
import com.meidusa.fastjson.util.TypeUtils;
import com.meidusa.fastmark.feature.SerializerFeature;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.xml.datatype.XMLGregorianCalendar;

public class SerializeConfig {
    public static final SerializeConfig globalInstance = new SerializeConfig();
    private static boolean awtError = false;
    private static boolean jdk8Error = false;
    private static boolean oracleJdbcError = false;
    private static boolean springfoxError = false;
    private boolean asm = !ASMUtils.IS_ANDROID;
    private ASMSerializerFactory asmFactory;
    protected String typeKey = JSON.DEFAULT_TYPE_KEY;
    public PropertyNamingStrategy propertyNamingStrategy;
    private final IdentityHashMap<Type, ObjectSerializer> serializers = new IdentityHashMap(1024);

    public String getTypeKey() {
        return this.typeKey;
    }

    public void setTypeKey(String typeKey) {
        this.typeKey = typeKey;
    }

    private final JavaBeanSerializer createASMSerializer(SerializeBeanInfo beanInfo) throws Exception {
        JavaBeanSerializer serializer = this.asmFactory.createJavaBeanSerializer(beanInfo);
        int i = 0;
        while (i < serializer.sortedGetters.length) {
            ObjectSerializer fieldSer;
            FieldSerializer fieldDeser = serializer.sortedGetters[i];
            Class<?> fieldClass = fieldDeser.fieldInfo.fieldClass;
            if (fieldClass.isEnum() && !((fieldSer = this.getObjectWriter(fieldClass)) instanceof EnumSerializer)) {
                serializer.writeDirect = false;
            }
            ++i;
        }
        return serializer;
    }

    private final ObjectSerializer createJavaBeanSerializer(Class<?> clazz) {
        SerializeBeanInfo beanInfo = TypeUtils.buildBeanInfo(clazz, null, this.propertyNamingStrategy);
        if (beanInfo.fields.length == 0 && Iterable.class.isAssignableFrom(clazz)) {
            return MiscCodec.instance;
        }
        return this.createJavaBeanSerializer(beanInfo);
    }

    public ObjectSerializer createJavaBeanSerializer(SerializeBeanInfo beanInfo) {
        JSONType jsonType = beanInfo.jsonType;
        if (jsonType != null) {
            Class<?> serializerClass = jsonType.serializer();
            if (serializerClass != Void.class) {
                try {
                    Object seralizer = serializerClass.newInstance();
                    if (seralizer instanceof ObjectSerializer) {
                        return (ObjectSerializer)seralizer;
                    }
                }
                catch (Throwable seralizer) {
                    // empty catch block
                }
            }
            if (!jsonType.asm()) {
                this.asm = false;
            }
        }
        Class<?> clazz = beanInfo.beanType;
        if (!Modifier.isPublic(beanInfo.beanType.getModifiers())) {
            return new JavaBeanSerializer(beanInfo);
        }
        boolean asm = this.asm;
        if (asm && this.asmFactory.classLoader.isExternalClass(clazz) || clazz == Serializable.class || clazz == Object.class) {
            asm = false;
        }
        if (asm && !ASMUtils.checkName(clazz.getName())) {
            asm = false;
        }
        if (asm) {
            FieldInfo[] fieldInfoArray = beanInfo.fields;
            int n = beanInfo.fields.length;
            int n2 = 0;
            while (n2 < n) {
                FieldInfo field = fieldInfoArray[n2];
                JSONField annotation = field.getAnnotation();
                if (annotation != null && (!ASMUtils.checkName(annotation.name()) || annotation.format().length() != 0 || annotation.jsonDirect() || annotation.serializeUsing() != Void.class)) {
                    asm = false;
                    break;
                }
                ++n2;
            }
        }
        if (asm) {
            try {
                JavaBeanSerializer asmSerializer = this.createASMSerializer(beanInfo);
                if (asmSerializer != null) {
                    return asmSerializer;
                }
            }
            catch (ClassFormatError asmSerializer) {
            }
            catch (ClassCastException asmSerializer) {
            }
            catch (Throwable e) {
                throw new JSONException("create asm serializer error, class " + clazz, e);
            }
        }
        return new JavaBeanSerializer(beanInfo);
    }

    public boolean isAsmEnable() {
        return this.asm;
    }

    public void setAsmEnable(boolean asmEnable) {
        if (ASMUtils.IS_ANDROID) {
            return;
        }
        this.asm = asmEnable;
    }

    public static SerializeConfig getGlobalInstance() {
        return globalInstance;
    }

    public SerializeConfig() {
        this(1024);
    }

    public SerializeConfig(int tableSize) {
        try {
            if (this.asm) {
                this.asmFactory = new ASMSerializerFactory();
            }
        }
        catch (NoClassDefFoundError eror) {
            this.asm = false;
        }
        catch (ExceptionInInitializerError error) {
            this.asm = false;
        }
        this.put((Type)((Object)Boolean.class), BooleanCodec.instance);
        this.put((Type)((Object)Character.class), CharacterCodec.instance);
        this.put((Type)((Object)Byte.class), IntegerCodec.instance);
        this.put((Type)((Object)Short.class), IntegerCodec.instance);
        this.put((Type)((Object)Integer.class), IntegerCodec.instance);
        this.put((Type)((Object)Long.class), LongCodec.instance);
        this.put((Type)((Object)Float.class), FloatCodec.instance);
        this.put((Type)((Object)Double.class), DoubleSerializer.instance);
        this.put((Type)((Object)BigDecimal.class), BigDecimalCodec.instance);
        this.put((Type)((Object)BigInteger.class), BigIntegerCodec.instance);
        this.put((Type)((Object)String.class), StringCodec.instance);
        this.put((Type)((Object)byte[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)short[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)int[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)long[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)float[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)double[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)boolean[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)char[].class), PrimitiveArraySerializer.instance);
        this.put((Type)((Object)Object[].class), ObjectArrayCodec.instance);
        this.put((Type)((Object)Class.class), MiscCodec.instance);
        this.put((Type)((Object)SimpleDateFormat.class), MiscCodec.instance);
        this.put((Type)((Object)Currency.class), new MiscCodec());
        this.put((Type)((Object)TimeZone.class), MiscCodec.instance);
        this.put((Type)((Object)InetAddress.class), MiscCodec.instance);
        this.put((Type)((Object)Inet4Address.class), MiscCodec.instance);
        this.put((Type)((Object)Inet6Address.class), MiscCodec.instance);
        this.put((Type)((Object)InetSocketAddress.class), MiscCodec.instance);
        this.put((Type)((Object)File.class), MiscCodec.instance);
        this.put((Type)((Object)Appendable.class), AppendableSerializer.instance);
        this.put((Type)((Object)StringBuffer.class), AppendableSerializer.instance);
        this.put((Type)((Object)StringBuilder.class), AppendableSerializer.instance);
        this.put((Type)((Object)Charset.class), ToStringSerializer.instance);
        this.put((Type)((Object)Pattern.class), ToStringSerializer.instance);
        this.put((Type)((Object)Locale.class), ToStringSerializer.instance);
        this.put((Type)((Object)URI.class), ToStringSerializer.instance);
        this.put((Type)((Object)URL.class), ToStringSerializer.instance);
        this.put((Type)((Object)UUID.class), ToStringSerializer.instance);
        this.put((Type)((Object)AtomicBoolean.class), AtomicCodec.instance);
        this.put((Type)((Object)AtomicInteger.class), AtomicCodec.instance);
        this.put((Type)((Object)AtomicLong.class), AtomicCodec.instance);
        this.put((Type)((Object)AtomicReference.class), ReferenceCodec.instance);
        this.put((Type)((Object)AtomicIntegerArray.class), AtomicCodec.instance);
        this.put((Type)((Object)AtomicLongArray.class), AtomicCodec.instance);
        this.put((Type)((Object)WeakReference.class), ReferenceCodec.instance);
        this.put((Type)((Object)SoftReference.class), ReferenceCodec.instance);
    }

    public void addFilter(Class<?> clazz, SerializeFilter filter) {
        ObjectSerializer serializer = this.getObjectWriter(clazz);
        if (serializer instanceof SerializeFilterable) {
            SerializeFilterable filterable = (SerializeFilterable)((Object)serializer);
            if (this != globalInstance && filterable == MapSerializer.instance) {
                MapSerializer newMapSer = new MapSerializer();
                this.put(clazz, newMapSer);
                newMapSer.addFilter(filter);
                return;
            }
            filterable.addFilter(filter);
        }
    }

    public void config(Class<?> clazz, SerializerFeature feature, boolean value) {
        ObjectSerializer serializer = this.getObjectWriter(clazz, false);
        if (serializer == null) {
            SerializeBeanInfo beanInfo = TypeUtils.buildBeanInfo(clazz, null, this.propertyNamingStrategy);
            beanInfo.features = value ? (beanInfo.features |= feature.mask) : (beanInfo.features &= ~feature.mask);
            serializer = this.createJavaBeanSerializer(beanInfo);
            this.put(clazz, serializer);
            return;
        }
        if (serializer instanceof JavaBeanSerializer) {
            JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)serializer;
            SerializeBeanInfo beanInfo = javaBeanSerializer.beanInfo;
            int originalFeaturs = beanInfo.features;
            beanInfo.features = value ? (beanInfo.features |= feature.mask) : (beanInfo.features &= ~feature.mask);
            if (originalFeaturs == beanInfo.features) {
                return;
            }
            Class<?> serializerClass = serializer.getClass();
            if (serializerClass != JavaBeanSerializer.class) {
                ObjectSerializer newSerializer = this.createJavaBeanSerializer(beanInfo);
                this.put(clazz, newSerializer);
            }
        }
    }

    public ObjectSerializer getObjectWriter(Class<?> clazz) {
        return this.getObjectWriter(clazz, true);
    }

    private ObjectSerializer getObjectWriter(Class<?> clazz, boolean create) {
        AutowiredObjectSerializer autowired;
        ClassLoader classLoader2;
        ObjectSerializer writer = this.serializers.get(clazz);
        if (writer == null) {
            try {
                classLoader2 = Thread.currentThread().getContextClassLoader();
                for (AutowiredObjectSerializer o : ServiceLoader.load(AutowiredObjectSerializer.class, classLoader2)) {
                    if (!(o instanceof AutowiredObjectSerializer)) continue;
                    autowired = o;
                    for (Type forType : autowired.getAutowiredFor()) {
                        this.put(forType, autowired);
                    }
                }
            }
            catch (ClassCastException classLoader2) {
                // empty catch block
            }
            writer = this.serializers.get(clazz);
        }
        if (writer == null && (classLoader2 = JSON.class.getClassLoader()) != Thread.currentThread().getContextClassLoader()) {
            try {
                for (AutowiredObjectSerializer o : ServiceLoader.load(AutowiredObjectSerializer.class, classLoader2)) {
                    if (!(o instanceof AutowiredObjectSerializer)) continue;
                    autowired = o;
                    for (Type forType : autowired.getAutowiredFor()) {
                        this.put(forType, autowired);
                    }
                }
            }
            catch (ClassCastException o) {
                // empty catch block
            }
            writer = this.serializers.get(clazz);
        }
        if (writer == null) {
            if (Map.class.isAssignableFrom(clazz)) {
                this.put(clazz, MapSerializer.instance);
            } else if (List.class.isAssignableFrom(clazz)) {
                this.put(clazz, ListSerializer.instance);
            } else if (Collection.class.isAssignableFrom(clazz)) {
                this.put(clazz, CollectionCodec.instance);
            } else if (Date.class.isAssignableFrom(clazz)) {
                this.put(clazz, DateCodec.instance);
            } else if (JSONAware.class.isAssignableFrom(clazz)) {
                this.put(clazz, JSONAwareSerializer.instance);
            } else if (JSONSerializable.class.isAssignableFrom(clazz)) {
                this.put(clazz, JSONSerializableSerializer.instance);
            } else if (JSONStreamAware.class.isAssignableFrom(clazz)) {
                this.put(clazz, MiscCodec.instance);
            } else if (clazz.isEnum() || clazz.getSuperclass() != null && clazz.getSuperclass().isEnum()) {
                this.put(clazz, EnumSerializer.instance);
            } else if (clazz.isArray()) {
                Class<?> componentType = clazz.getComponentType();
                ObjectSerializer compObjectSerializer = this.getObjectWriter(componentType);
                this.put(clazz, new ArraySerializer(componentType, compObjectSerializer));
            } else if (Throwable.class.isAssignableFrom(clazz)) {
                SerializeBeanInfo beanInfo = TypeUtils.buildBeanInfo(clazz, null, this.propertyNamingStrategy);
                beanInfo.features |= SerializerFeature.WriteClassName.mask;
                this.put(clazz, new JavaBeanSerializer(beanInfo));
            } else if (TimeZone.class.isAssignableFrom(clazz)) {
                this.put(clazz, MiscCodec.instance);
            } else if (Appendable.class.isAssignableFrom(clazz)) {
                this.put(clazz, AppendableSerializer.instance);
            } else if (Charset.class.isAssignableFrom(clazz)) {
                this.put(clazz, ToStringSerializer.instance);
            } else if (Enumeration.class.isAssignableFrom(clazz)) {
                this.put(clazz, EnumerationSerializer.instance);
            } else if (Calendar.class.isAssignableFrom(clazz) || XMLGregorianCalendar.class.isAssignableFrom(clazz)) {
                this.put(clazz, CalendarCodec.instance);
            } else if (Clob.class.isAssignableFrom(clazz)) {
                this.put(clazz, ClobSeriliazer.instance);
            } else if (TypeUtils.isPath(clazz)) {
                this.put(clazz, ToStringSerializer.instance);
            } else if (Iterator.class.isAssignableFrom(clazz)) {
                this.put(clazz, MiscCodec.instance);
            } else {
                String className = clazz.getName();
                if (className.startsWith("java.awt.") && AwtCodec.support(clazz)) {
                    if (!awtError) {
                        try {
                            this.put(Class.forName("java.awt.Color"), AwtCodec.instance);
                            this.put(Class.forName("java.awt.Font"), AwtCodec.instance);
                            this.put(Class.forName("java.awt.Point"), AwtCodec.instance);
                            this.put(Class.forName("java.awt.Rectangle"), AwtCodec.instance);
                        }
                        catch (Throwable e) {
                            awtError = true;
                        }
                    }
                    return AwtCodec.instance;
                }
                if (!oracleJdbcError && className.startsWith("oracle.sql.")) {
                    try {
                        this.put(Class.forName("oracle.sql.DATE"), DateCodec.instance);
                        this.put(Class.forName("oracle.sql.TIMESTAMP"), DateCodec.instance);
                        writer = this.serializers.get(clazz);
                        if (writer != null) {
                            return writer;
                        }
                    }
                    catch (Throwable e) {
                        oracleJdbcError = true;
                    }
                }
                if (!springfoxError && className.equals("springfox.documentation.spring.web.json.Json")) {
                    try {
                        this.put(Class.forName("springfox.documentation.spring.web.json.Json"), SwaggerJsonSerializer.instance);
                        writer = this.serializers.get(clazz);
                        if (writer != null) {
                            return writer;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        springfoxError = true;
                    }
                }
                boolean isCglibProxy = false;
                boolean isJavassistProxy = false;
                Class<?>[] classArray = clazz.getInterfaces();
                int n = classArray.length;
                int forType = 0;
                while (forType < n) {
                    Class<?> item = classArray[forType];
                    String interfaceName = item.getName();
                    if (interfaceName.equals("net.sf.cglib.proxy.Factory") || interfaceName.equals("org.springframework.cglib.proxy.Factory")) {
                        isCglibProxy = true;
                        break;
                    }
                    if (interfaceName.equals("javassist.util.proxy.ProxyObject") || interfaceName.equals("org.apache.ibatis.javassist.util.proxy.ProxyObject")) {
                        isJavassistProxy = true;
                        break;
                    }
                    ++forType;
                }
                if (isCglibProxy || isJavassistProxy) {
                    Class<?> superClazz = clazz.getSuperclass();
                    ObjectSerializer superWriter = this.getObjectWriter(superClazz);
                    this.putInternal(clazz, superWriter);
                    return superWriter;
                }
                if (create) {
                    this.putInternal(clazz, this.createJavaBeanSerializer(clazz));
                }
            }
            writer = this.serializers.get(clazz);
        }
        return writer;
    }

    public final ObjectSerializer get(Type key) {
        return this.serializers.get(key);
    }

    public boolean put(Type type, ObjectSerializer value) {
        boolean isEnum = false;
        if (type instanceof Class) {
            Class clazz = (Class)type;
            isEnum = clazz.isEnum();
        }
        return this.putInternal(type, value);
    }

    protected boolean putInternal(Type key, ObjectSerializer value) {
        return this.serializers.put(key, value);
    }
}

