/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.JSON;
import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.parser.DefaultJSONParser;
import com.meidusa.fastjson.parser.JSONLexer;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Type;
import java.util.Collection;

public class CharArrayCodec
implements ObjectDeserializer {
    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        return CharArrayCodec.deserialze(parser);
    }

    public static <T> T deserialze(DefaultJSONParser parser) {
        JSONLexer lexer = parser.lexer;
        if (lexer.token() == 4) {
            String val = lexer.stringVal();
            lexer.nextToken(16);
            return (T)val.toCharArray();
        }
        if (lexer.token() == 2) {
            Number val = lexer.integerValue();
            lexer.nextToken(16);
            return (T)val.toString().toCharArray();
        }
        Object value = parser.parse();
        if (value instanceof String) {
            return (T)((String)value).toCharArray();
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            boolean accept = true;
            for (Object item : collection) {
                int itemLength;
                if (!(item instanceof String) || (itemLength = ((String)item).length()) == 1) continue;
                accept = false;
                break;
            }
            if (!accept) {
                throw new JSONException("can not cast to char[]");
            }
        }
        return (T)(value == null ? null : JSON.toJSONString(value).toCharArray());
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }
}

