/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.JSONArray;
import com.meidusa.fastjson.parser.DefaultJSONParser;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import com.meidusa.fastjson.serializer.JSONSerializer;
import com.meidusa.fastjson.serializer.ObjectSerializer;
import com.meidusa.fastjson.serializer.SerializeWriter;
import com.meidusa.fastmark.feature.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class AtomicCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final AtomicCodec instance = new AtomicCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object instanceof AtomicInteger) {
            AtomicInteger val = (AtomicInteger)object;
            out.writeInt(val.get());
            return;
        }
        if (object instanceof AtomicLong) {
            AtomicLong val = (AtomicLong)object;
            out.writeLong(val.get());
            return;
        }
        if (object instanceof AtomicBoolean) {
            AtomicBoolean val = (AtomicBoolean)object;
            out.append(val.get() ? "true" : "false");
            return;
        }
        if (object == null) {
            out.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        if (object instanceof AtomicIntegerArray) {
            AtomicIntegerArray array = (AtomicIntegerArray)object;
            int len = array.length();
            out.write(91);
            int i = 0;
            while (i < len) {
                int val = array.get(i);
                if (i != 0) {
                    out.write(44);
                }
                out.writeInt(val);
                ++i;
            }
            out.write(93);
            return;
        }
        AtomicLongArray array = (AtomicLongArray)object;
        int len = array.length();
        out.write(91);
        int i = 0;
        while (i < len) {
            long val = array.get(i);
            if (i != 0) {
                out.write(44);
            }
            out.writeLong(val);
            ++i;
        }
        out.write(93);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        if (parser.lexer.token() == 8) {
            parser.lexer.nextToken(16);
            return null;
        }
        JSONArray array = new JSONArray();
        parser.parseArray(array);
        if (clazz == AtomicIntegerArray.class) {
            AtomicIntegerArray atomicArray = new AtomicIntegerArray(array.size());
            int i = 0;
            while (i < array.size()) {
                atomicArray.set(i, array.getInteger(i));
                ++i;
            }
            return (T)atomicArray;
        }
        AtomicLongArray atomicArray = new AtomicLongArray(array.size());
        int i = 0;
        while (i < array.size()) {
            atomicArray.set(i, array.getLong(i));
            ++i;
        }
        return (T)atomicArray;
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

