/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.parser.deserializer;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.parser.DefaultJSONParser;
import com.meidusa.fastjson.parser.JSONLexer;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Type;

public class EnumDeserializer
implements ObjectDeserializer {
    private final Class<?> enumClass;
    protected final Enum[] values;

    public EnumDeserializer(Class<?> enumClass) {
        this.enumClass = enumClass;
        this.values = (Enum[])enumClass.getEnumConstants();
    }

    public Enum<?> valueOf(int ordinal) {
        return this.values[ordinal];
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
        block8: {
            JSONLexer lexer = parser.lexer;
            int token = lexer.token();
            if (token == 2) {
                int intValue = lexer.intValue();
                lexer.nextToken(16);
                if (intValue < 0 || intValue > this.values.length) {
                    throw new JSONException("parse enum " + this.enumClass.getName() + " error, value : " + intValue);
                }
                return (T)this.values[intValue];
            }
            if (token == 4) {
                String strVal = lexer.stringVal();
                lexer.nextToken(16);
                if (strVal.length() == 0) {
                    return null;
                }
                return (T)Enum.valueOf(this.enumClass, strVal);
            }
            if (token != 8) break block8;
            Object value = null;
            lexer.nextToken(16);
            return null;
        }
        try {
            Object value = parser.parse();
            throw new JSONException("parse enum " + this.enumClass.getName() + " error, value : " + value);
        }
        catch (JSONException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

