/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson;

import com.meidusa.fastjson.util.ParameterizedTypeImpl;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TypeReference<T> {
    static ConcurrentMap<Class<?>, ConcurrentMap<Type, ConcurrentMap<Type, Type>>> classTypeCache = new ConcurrentHashMap(16, 0.75f, 1);
    protected final Type type;

    protected TypeReference() {
        Type superClass = this.getClass().getGenericSuperclass();
        this.type = ((ParameterizedType)superClass).getActualTypeArguments()[0];
    }

    protected TypeReference(Type ... actualTypeArguments) {
        Class<?> thisClass = this.getClass();
        Type superClass = thisClass.getGenericSuperclass();
        ParameterizedType argType = (ParameterizedType)((ParameterizedType)superClass).getActualTypeArguments()[0];
        Type rawType = argType.getRawType();
        Type[] argTypes = argType.getActualTypeArguments();
        int actualIndex = 0;
        int i = 0;
        while (i < argTypes.length) {
            if (argTypes[i] instanceof TypeVariable) {
                argTypes[i] = actualTypeArguments[actualIndex++];
                if (actualIndex >= actualTypeArguments.length) break;
            }
            ++i;
        }
        if (actualTypeArguments.length == 1 && argTypes.length == 1) {
            Type actualTypeArgument;
            Type cachedType;
            ConcurrentMap typeCached;
            ConcurrentMap classCache = (ConcurrentMap)classTypeCache.get(thisClass);
            if (classCache == null) {
                classTypeCache.putIfAbsent(thisClass, new ConcurrentHashMap(16, 0.75f, 1));
                classCache = (ConcurrentMap)classTypeCache.get(thisClass);
            }
            if ((typeCached = (ConcurrentMap)classCache.get(argType)) == null) {
                classCache.putIfAbsent(argType, new ConcurrentHashMap(16, 0.75f, 1));
                typeCached = (ConcurrentMap)classCache.get(argType);
            }
            if ((cachedType = (Type)typeCached.get(actualTypeArgument = actualTypeArguments[0])) == null) {
                typeCached.putIfAbsent(actualTypeArgument, actualTypeArgument);
                cachedType = (Type)typeCached.get(actualTypeArgument);
            }
            this.type = cachedType;
        } else {
            this.type = new ParameterizedTypeImpl(argTypes, thisClass, rawType);
        }
    }

    public Type getType() {
        return this.type;
    }
}

