/*
 * Copyright 1999-2101 Alibaba Group.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.meidusa.fastjson.parser;

import static com.meidusa.fastjson.parser.JSONScanner.EOI;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.JSONObject;
import com.meidusa.fastjson.parser.JSONScanner;
import com.meidusa.fastjson.parser.JSONToken;
import com.meidusa.fastmark.feature.Feature;


/**
 * @author wenshao[szujobs@hotmail.com]
 */
public class DefaultExtJSONParser extends DefaultJSONParser {

    public DefaultExtJSONParser(String input){
        this(input, ParserConfig.getGlobalInstance());
    }

    public DefaultExtJSONParser(String input, ParserConfig mapping){
        super(input, mapping);
    }

    public DefaultExtJSONParser(String input, ParserConfig mapping, int features){
        super(input, mapping, features);
    }

    public DefaultExtJSONParser(char[] input, int length, ParserConfig mapping, int features){
        super(input, length, mapping, features);
    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
	public Map<String, Object> parseObjectWithTypeMap(Map<String, Type> typeMap) {
	    if(typeMap == null || typeMap.size() ==0){
	       return  parseObject(JSONObject.class);
	    }
		Map<String, Object> map = new HashMap<String, Object>();
		JSONScanner lexer = (JSONScanner) this.lexer;
		if (lexer.token() != JSONToken.LBRACE) {
			throw new JSONException("syntax error, expect {, actual " + lexer.token());
		}

		for (;;) {
			lexer.skipWhitespace();
			char ch = lexer.getCurrent();
			if (isEnabled(Feature.AllowArbitraryCommas)) {
				while (ch == ',') {
					lexer.next();
					lexer.skipWhitespace();
					ch = lexer.getCurrent();
				}
			}

			String key;
			if (ch == '"') {
				key = lexer.scanSymbol(symbolTable, '"');
				lexer.skipWhitespace();
				ch = lexer.getCurrent();
				if (ch != ':') {
					throw new JSONException("expect ':' at " + lexer.pos() + ", name " + key);
				}
			} else if (ch == '}') {
				lexer.next();
				lexer.resetStringPosition();
				lexer.nextToken();
				return map;
			} else if (ch == '\'') {
				if (!isEnabled(Feature.AllowSingleQuotes)) {
					throw new JSONException("syntax error");
				}

				key = lexer.scanSymbol(symbolTable, '\'');
				lexer.skipWhitespace();
				ch = lexer.getCurrent();
				if (ch != ':') {
					throw new JSONException("expect ':' at " + lexer.pos());
				}
			} else if ((byte) ch == EOI) {
				lexer.nextToken();
				// lexer.pos();
				if (lexer.isEOF()) {
					return map;
				}
				return map;
				// throw new JSONException("syntax error");
			} else if (ch == ',') {
				throw new JSONException("syntax error");
			} else {
				if (!isEnabled(Feature.AllowUnQuotedFieldNames)) {
					throw new JSONException("syntax error");
				}

				key = lexer.scanSymbolUnQuoted(symbolTable);
				lexer.skipWhitespace();
				ch = lexer.getCurrent();
				if (ch != ':') {
					throw new JSONException("expect ':' at " + lexer.pos() + ", actual " + ch);
				}
			}
			lexer.resetStringPosition();
			lexer.nextToken();
			lexer.nextToken();
			Type type = typeMap.get(key);
			if (type == null) {
			    map.put(key, parse());
			} else {
				map.put(key, parseObject(type));
			}
			/*
			 * lexer.incrementBufferPosition(); lexer.skipWhitespace(); ch =
			 * lexer.getCurrent();
			 */

		}
	}
}
