/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.util;

import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.type.DefinedParameterizedTypeBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;

public class FieldInfo
implements Comparable<FieldInfo> {
    private final String name;
    private final Method method;
    private final Field field;
    private final Class<?> fieldClass;
    private final Type fieldType;
    private final boolean isTypeHandle;

    public String toString() {
        return "FieldInfo [name=" + this.name + ", method=" + this.method + ", field=" + this.field + ", fieldClass=" + this.fieldClass + ", fieldType=" + this.fieldType + ", isTypeHandle=" + this.isTypeHandle + "]";
    }

    public FieldInfo(String name, Method method, Map<TypeVariable<?>, Type> typeMap, Field field, boolean isKey) {
        this.name = name;
        this.method = method;
        this.field = field;
        this.isTypeHandle = isKey;
        if (method.getParameterTypes().length == 1) {
            this.fieldClass = method.getParameterTypes()[0];
            this.fieldType = DefinedParameterizedTypeBuilder.buildDefinedType(method.getGenericParameterTypes()[0], typeMap);
        } else {
            this.fieldClass = method.getReturnType();
            this.fieldType = DefinedParameterizedTypeBuilder.buildDefinedType(method.getGenericReturnType(), typeMap);
        }
        if (this.fieldType instanceof ParameterizedType) {
            DefaultExtJSONParser.putType(this.fieldType.toString(), this.fieldType);
        }
    }

    public boolean isTypeHandle() {
        return this.isTypeHandle;
    }

    public Class<?> getFieldClass() {
        return this.fieldClass;
    }

    public Type getFieldType() {
        return this.fieldType;
    }

    public String getName() {
        return this.name;
    }

    public Method getMethod() {
        return this.method;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public int compareTo(FieldInfo o) {
        if (this.isTypeHandle && !o.isTypeHandle) {
            return Integer.MIN_VALUE;
        }
        return 0;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T annotation = null;
        annotation = this.method.getAnnotation(annotationClass);
        if (annotation == null && this.field != null) {
            annotation = this.field.getAnnotation(annotationClass);
        }
        return annotation;
    }
}

