/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.JSON;
import com.meidusa.fastjson.parser.CharTypes;
import com.meidusa.fastjson.serializer.SerialWriterStringEncoder;
import com.meidusa.fastjson.util.IOUtils;
import com.meidusa.fastmark.feature.SerializerFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;

public final class SerializeWriter
extends Writer {
    protected char[] buf;
    protected int count;
    private static int MAX_BUFFER_SIZE = Integer.getInteger("venus.json.max.buffer", 131072);
    private static final ThreadLocal<char[]> bufLocal = new ThreadLocal();
    private int features;

    public SerializeWriter() {
        this.features = JSON.DEFAULT_GENERATE_FEATURE;
        this.buf = bufLocal.get();
        if (this.buf == null) {
            this.buf = new char[1024];
        } else {
            bufLocal.set(null);
        }
    }

    public SerializeWriter(SerializerFeature ... features) {
        this.buf = bufLocal.get();
        if (this.buf == null) {
            this.buf = new char[1024];
        } else {
            bufLocal.set(null);
        }
        int featuresValue = 0;
        SerializerFeature[] serializerFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            SerializerFeature feature = serializerFeatureArray[n2];
            featuresValue |= feature.getMask();
            ++n2;
        }
        this.features = featuresValue;
    }

    public SerializeWriter(int initialSize) {
        if (initialSize <= 0) {
            throw new IllegalArgumentException("Negative initial size: " + initialSize);
        }
        this.buf = new char[initialSize];
    }

    public void config(SerializerFeature feature, boolean state) {
        this.features = state ? (this.features |= feature.getMask()) : (this.features &= ~feature.getMask());
    }

    public boolean isEnabled(SerializerFeature feature) {
        return SerializerFeature.isEnabled((int)this.features, (SerializerFeature)feature);
    }

    @Override
    public void write(int c) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = (char)c;
        this.count = newcount;
    }

    public void write(char c) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = c;
        this.count = newcount;
    }

    @Override
    public void write(char[] c, int off, int len) {
        if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(c, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void expandCapacity(int minimumCapacity) {
        int newCapacity = this.buf.length * 3 / 2 + 1;
        if (newCapacity < minimumCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.buf, 0, newValue, 0, this.count);
        this.buf = newValue;
    }

    @Override
    public void write(String str, int off, int len) {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        str.getChars(off, off + len, this.buf, this.count);
        this.count = newcount;
    }

    public void writeTo(Writer out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void writeTo(OutputStream out, String charset) throws IOException {
        byte[] bytes = new String(this.buf, 0, this.count).getBytes(charset);
        out.write(bytes);
    }

    @Override
    public SerializeWriter append(CharSequence csq) {
        String s = csq == null ? "null" : csq.toString();
        this.write(s, 0, s.length());
        return this;
    }

    @Override
    public SerializeWriter append(CharSequence csq, int start, int end) {
        String s = (csq == null ? "null" : csq).subSequence(start, end).toString();
        this.write(s, 0, s.length());
        return this;
    }

    @Override
    public SerializeWriter append(char c) {
        this.write(c);
        return this;
    }

    public void reset() {
        this.count = 0;
    }

    public char[] toCharArray() {
        char[] newValue = new char[this.count];
        System.arraycopy(this.buf, 0, newValue, 0, this.count);
        return newValue;
    }

    public byte[] toBytes(String charsetName) {
        if (charsetName == null) {
            charsetName = "UTF-8";
        }
        Charset cs = Charset.forName(charsetName);
        SerialWriterStringEncoder encoder = new SerialWriterStringEncoder(cs);
        return encoder.encode(this.buf, 0, this.count);
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        if (this.buf != null && this.buf.length > MAX_BUFFER_SIZE) {
            this.buf = null;
            bufLocal.set(null);
        } else {
            bufLocal.set(this.buf);
        }
    }

    public void writeBooleanArray(boolean[] array) throws IOException {
        int[] sizeArray = new int[array.length];
        int totalSize = 2;
        int i = 0;
        while (i < array.length) {
            boolean val;
            if (i != 0) {
                ++totalSize;
            }
            int size = (val = array[i]) ? 4 : 5;
            sizeArray[i] = size;
            totalSize += size;
            ++i;
        }
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 91;
        int currentSize = this.count + 1;
        int i2 = 0;
        while (i2 < array.length) {
            boolean val;
            if (i2 != 0) {
                this.buf[currentSize++] = 44;
            }
            if (val = array[i2]) {
                this.buf[currentSize++] = 116;
                this.buf[currentSize++] = 114;
                this.buf[currentSize++] = 117;
                this.buf[currentSize++] = 101;
            } else {
                this.buf[currentSize++] = 102;
                this.buf[currentSize++] = 97;
                this.buf[currentSize++] = 108;
                this.buf[currentSize++] = 115;
                this.buf[currentSize++] = 101;
            }
            ++i2;
        }
        this.buf[currentSize] = 93;
        this.count = newcount;
    }

    @Override
    public void write(String text) {
        if (text == null) {
            this.writeNull();
            return;
        }
        int length = text.length();
        int newcount = this.count + length;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        text.getChars(0, length, this.buf, this.count);
        this.count = newcount;
    }

    public void writeInt(int i) {
        if (i == Integer.MIN_VALUE) {
            this.write("-2147483648");
            return;
        }
        int size = i < 0 ? IOUtils.stringSize((long)(-i)) + 1 : IOUtils.stringSize((long)i);
        int newcount = this.count + size;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        IOUtils.getChars(i, newcount, this.buf);
        this.count = newcount;
    }

    public void writeShortArray(short[] array) throws IOException {
        int[] sizeArray = new int[array.length];
        int totalSize = 2;
        int i = 0;
        while (i < array.length) {
            int size;
            if (i != 0) {
                ++totalSize;
            }
            short val = array[i];
            sizeArray[i] = size = IOUtils.stringSize((long)val);
            totalSize += size;
            ++i;
        }
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 91;
        int currentSize = this.count + 1;
        int i2 = 0;
        while (i2 < array.length) {
            if (i2 != 0) {
                this.buf[currentSize++] = 44;
            }
            short val = array[i2];
            IOUtils.getChars(val, currentSize += sizeArray[i2], this.buf);
            ++i2;
        }
        this.buf[currentSize] = 93;
        this.count = newcount;
    }

    public void writeByteArray(byte[] array) {
        int[] sizeArray = new int[array.length];
        int totalSize = 2;
        int i = 0;
        while (i < array.length) {
            int size;
            if (i != 0) {
                ++totalSize;
            }
            byte val = array[i];
            sizeArray[i] = size = IOUtils.stringSize(val);
            totalSize += size;
            ++i;
        }
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 91;
        int currentSize = this.count + 1;
        int i2 = 0;
        while (i2 < array.length) {
            if (i2 != 0) {
                this.buf[currentSize++] = 44;
            }
            byte val = array[i2];
            IOUtils.getChars(val, currentSize += sizeArray[i2], this.buf);
            ++i2;
        }
        this.buf[currentSize] = 93;
        this.count = newcount;
    }

    public void writeIntArray(int[] array) {
        int[] sizeArray = new int[array.length];
        int totalSize = 2;
        int i = 0;
        while (i < array.length) {
            int val;
            if (i != 0) {
                ++totalSize;
            }
            int size = (val = array[i]) == Integer.MIN_VALUE ? "-2147483648".length() : (val < 0 ? IOUtils.stringSize((long)(-val)) + 1 : IOUtils.stringSize((long)val));
            sizeArray[i] = size;
            totalSize += size;
            ++i;
        }
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 91;
        int currentSize = this.count + 1;
        int i2 = 0;
        while (i2 < array.length) {
            int val;
            if (i2 != 0) {
                this.buf[currentSize++] = 44;
            }
            if ((val = array[i2]) == Integer.MIN_VALUE) {
                System.arraycopy("-2147483648".toCharArray(), 0, this.buf, currentSize, sizeArray[i2]);
                currentSize += sizeArray[i2];
            } else {
                IOUtils.getChars(val, currentSize += sizeArray[i2], this.buf);
            }
            ++i2;
        }
        this.buf[currentSize] = 93;
        this.count = newcount;
    }

    public void writeIntAndChar(int i, char c) {
        if (i == Integer.MIN_VALUE) {
            this.write("-2147483648");
            this.write(c);
            return;
        }
        int size = i < 0 ? IOUtils.stringSize((long)(-i)) + 1 : IOUtils.stringSize((long)i);
        int newcount0 = this.count + size;
        int newcount1 = newcount0 + 1;
        if (newcount1 > this.buf.length) {
            this.expandCapacity(newcount1);
        }
        IOUtils.getChars(i, newcount0, this.buf);
        this.buf[newcount0] = c;
        this.count = newcount1;
    }

    public void writeLongAndChar(long i, char c) throws IOException {
        if (i == Long.MIN_VALUE) {
            this.write("-9223372036854775808");
            this.write(c);
            return;
        }
        int size = i < 0L ? IOUtils.stringSize(-i) + 1 : IOUtils.stringSize(i);
        int newcount0 = this.count + size;
        int newcount1 = newcount0 + 1;
        if (newcount1 > this.buf.length) {
            this.expandCapacity(newcount1);
        }
        IOUtils.getChars(i, newcount0, this.buf);
        this.buf[newcount0] = c;
        this.count = newcount1;
    }

    public void writeLong(long i) {
        if (i == Long.MIN_VALUE) {
            this.write("-9223372036854775808");
            return;
        }
        int size = i < 0L ? IOUtils.stringSize(-i) + 1 : IOUtils.stringSize(i);
        int newcount = this.count + size;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        IOUtils.getChars(i, newcount, this.buf);
        this.count = newcount;
    }

    public void writeNull() {
        int newcount = this.count + 4;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 110;
        this.buf[this.count + 1] = 117;
        this.buf[this.count + 2] = 108;
        this.buf[this.count + 3] = 108;
        this.count = newcount;
    }

    public void writeLongArray(long[] array) {
        int[] sizeArray = new int[array.length];
        int totalSize = 2;
        int i = 0;
        while (i < array.length) {
            long val;
            if (i != 0) {
                ++totalSize;
            }
            int size = (val = array[i]) == Long.MIN_VALUE ? "-9223372036854775808".length() : (val < 0L ? IOUtils.stringSize(-val) + 1 : IOUtils.stringSize(val));
            sizeArray[i] = size;
            totalSize += size;
            ++i;
        }
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 91;
        int currentSize = this.count + 1;
        int i2 = 0;
        while (i2 < array.length) {
            long val;
            if (i2 != 0) {
                this.buf[currentSize++] = 44;
            }
            if ((val = array[i2]) == Long.MIN_VALUE) {
                System.arraycopy("-9223372036854775808".toCharArray(), 0, this.buf, currentSize, sizeArray[i2]);
                currentSize += sizeArray[i2];
            } else {
                IOUtils.getChars(val, currentSize += sizeArray[i2], this.buf);
            }
            ++i2;
        }
        this.buf[currentSize] = 93;
        this.count = newcount;
    }

    private void writeStringWithDoubleQuote(String text) {
        char ch;
        if (text == null) {
            this.writeNull();
            return;
        }
        int len = text.length();
        int newcount = this.count + len + 2;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count + 1;
        int end = start + len;
        this.buf[this.count] = 34;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        int specialCount = 0;
        int lastSpecialIndex = -1;
        char lastSpecial = '\u0000';
        int i = start;
        while (i < end) {
            ch = this.buf[i];
            if (ch == '\b' || ch == '\n' || ch == '\r' || ch == '\f' || ch == '\\' || ch == '\"' || ch == '\t' && this.isEnabled(SerializerFeature.WriteTabAsSpecial)) {
                ++specialCount;
                lastSpecialIndex = i;
                lastSpecial = ch;
            }
            ++i;
        }
        if ((newcount += specialCount) > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.count = newcount;
        if (specialCount == 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, end - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
        } else if (specialCount > 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, end - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
            ++end;
            i = lastSpecialIndex - 2;
            while (i >= start) {
                ch = this.buf[i];
                if (ch == '\b' || ch == '\n' || ch == '\r' || ch == '\f' || ch == '\\' || ch == '\"' || ch == '\t' && this.isEnabled(SerializerFeature.WriteTabAsSpecial)) {
                    System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                    this.buf[i] = 92;
                    this.buf[i + 1] = CharTypes.replaceChars[ch];
                    ++end;
                }
                --i;
            }
        }
        this.buf[this.count - 1] = 34;
    }

    public void writeKeyWithDoubleQuote(String text) {
        boolean[] specicalFlags_doubleQuotes = CharTypes.specicalFlags_doubleQuotes;
        int len = text.length();
        int newcount = this.count + len + 3;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count + 1;
        int end = start + len;
        this.buf[this.count] = 34;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        int i = start;
        while (i < end) {
            char ch = this.buf[i];
            if (ch < specicalFlags_doubleQuotes.length && specicalFlags_doubleQuotes[ch] || ch == '\t' && this.isEnabled(SerializerFeature.WriteTabAsSpecial)) {
                if (++newcount > this.buf.length) {
                    this.expandCapacity(newcount);
                }
                this.count = newcount;
                System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                this.buf[i] = 92;
                this.buf[++i] = CharTypes.replaceChars[ch];
                ++end;
            }
            ++i;
        }
        this.buf[this.count - 2] = 34;
        this.buf[this.count - 1] = 58;
    }

    public void writeFieldNull(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        this.writeNull();
    }

    public void writeFieldNullString(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        if (this.isEnabled(SerializerFeature.WriteNullStringAsEmpty)) {
            this.writeString("");
        } else {
            this.writeNull();
        }
    }

    public void writeFieldNullBoolean(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        if (this.isEnabled(SerializerFeature.WriteNullBooleanAsFalse)) {
            this.write("false");
        } else {
            this.writeNull();
        }
    }

    public void writeFieldNullList(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        if (this.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
            this.write("[]");
        } else {
            this.writeNull();
        }
    }

    public void writeFieldNullNumber(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        if (this.isEnabled(SerializerFeature.WriteNullNumberAsZero)) {
            this.write('0');
        } else {
            this.writeNull();
        }
    }

    public void writeFieldValue(char seperator, String name, char value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == '\u0000') {
            this.writeString("\u0000");
        } else {
            this.writeString(Character.toString(value));
        }
    }

    public void writeFieldValue(char seperator, String name, boolean value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value) {
            this.write("true");
        } else {
            this.write("false");
        }
    }

    public void writeFieldValue(char seperator, String name, int value) {
        this.write(seperator);
        this.writeFieldName(name);
        this.writeInt(value);
    }

    public void writeFieldValue(char seperator, String name, long value) {
        this.write(seperator);
        this.writeFieldName(name);
        this.writeLong(value);
    }

    public void writeFieldValue(char seperator, String name, float value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == 0.0f) {
            this.write('0');
        } else if (Float.isNaN(value)) {
            this.writeNull();
        } else if (Float.isInfinite(value)) {
            this.writeNull();
        } else {
            String text = Float.toString(value);
            if (text.endsWith(".0")) {
                text = text.substring(0, text.length() - 2);
            }
            this.write(text);
        }
    }

    public void writeFieldValue(char seperator, String name, double value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == 0.0) {
            this.write('0');
        } else if (Double.isNaN(value)) {
            this.writeNull();
        } else if (Double.isInfinite(value)) {
            this.writeNull();
        } else {
            String text = Double.toString(value);
            if (text.endsWith(".0")) {
                text = text.substring(0, text.length() - 2);
            }
            this.write(text);
        }
    }

    public void writeFieldValue(char seperator, String name, String value) {
        if (this.isEnabled(SerializerFeature.QuoteFieldNames)) {
            if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
                this.write(seperator);
                this.writeFieldName(name);
                if (value == null) {
                    this.writeNull();
                } else {
                    this.writeString(value);
                }
            } else {
                this.writeFieldValueStringWithDoubleQuote(seperator, name, value);
            }
        } else {
            this.write(seperator);
            this.writeFieldName(name);
            if (value == null) {
                this.writeNull();
            } else {
                this.writeString(value);
            }
        }
    }

    private void writeFieldValueStringWithDoubleQuote(char seperator, String name, String value) {
        char ch;
        char ch2;
        int valueLen;
        int nameLen = name.length();
        int newcount = this.count;
        if (value == null) {
            valueLen = 4;
            newcount += nameLen + 8;
        } else {
            valueLen = value.length();
            newcount += nameLen + valueLen + 6;
        }
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = seperator;
        int nameStart = this.count + 2;
        int nameEnd = nameStart + nameLen;
        this.buf[this.count + 1] = 34;
        name.getChars(0, nameLen, this.buf, nameStart);
        this.count = newcount;
        int specialCount = 0;
        int lastSpecialIndex = -1;
        char lastSpecial = '\u0000';
        int i = nameStart;
        while (i < nameEnd) {
            ch2 = this.buf[i];
            if (ch2 == '\b' || ch2 == '\n' || ch2 == '\r' || ch2 == '\f' || ch2 == '\\' || ch2 == '\"' || ch2 == '\t' && this.isEnabled(SerializerFeature.WriteTabAsSpecial)) {
                ++specialCount;
                lastSpecialIndex = i;
                lastSpecial = ch2;
            }
            ++i;
        }
        if (specialCount > 0) {
            if ((newcount += specialCount) > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
        }
        if (specialCount == 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, nameEnd - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
            ++nameEnd;
        } else if (specialCount > 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, nameEnd - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
            ++nameEnd;
            i = lastSpecialIndex - 2;
            while (i >= nameStart) {
                ch2 = this.buf[i];
                if (ch2 == '\b' || ch2 == '\n' || ch2 == '\r' || ch2 == '\f' || ch2 == '\\' || ch2 == '\"' || ch2 == '\t' && this.isEnabled(SerializerFeature.WriteTabAsSpecial)) {
                    System.arraycopy(this.buf, i + 1, this.buf, i + 2, nameEnd - i - 1);
                    this.buf[i] = 92;
                    this.buf[i + 1] = CharTypes.replaceChars[ch2];
                    ++nameEnd;
                }
                --i;
            }
        }
        this.buf[nameEnd] = 34;
        int index = nameEnd + 1;
        this.buf[index++] = 58;
        if (value == null) {
            this.buf[index++] = 110;
            this.buf[index++] = 117;
            this.buf[index++] = 108;
            this.buf[index++] = 108;
            return;
        }
        this.buf[index++] = 34;
        int valueStart = index;
        int valueEnd = valueStart + valueLen;
        value.getChars(0, valueLen, this.buf, valueStart);
        specialCount = 0;
        lastSpecialIndex = -1;
        lastSpecial = '\u0000';
        int i2 = valueStart;
        while (i2 < valueEnd) {
            ch = this.buf[i2];
            if (ch == '\b' || ch == '\n' || ch == '\r' || ch == '\f' || ch == '\\' || ch == '\"' || ch == '\t' && this.isEnabled(SerializerFeature.WriteTabAsSpecial)) {
                ++specialCount;
                lastSpecialIndex = i2;
                lastSpecial = ch;
            }
            ++i2;
        }
        if (specialCount > 0) {
            if ((newcount += specialCount) > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
        }
        if (specialCount == 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, valueEnd - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
        } else if (specialCount > 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, valueEnd - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
            ++valueEnd;
            i2 = lastSpecialIndex - 2;
            while (i2 >= valueStart) {
                ch = this.buf[i2];
                if (ch == '\b' || ch == '\n' || ch == '\r' || ch == '\f' || ch == '\\' || ch == '\"' || ch == '\t' && this.isEnabled(SerializerFeature.WriteTabAsSpecial)) {
                    System.arraycopy(this.buf, i2 + 1, this.buf, i2 + 2, valueEnd - i2 - 1);
                    this.buf[i2] = 92;
                    this.buf[i2 + 1] = CharTypes.replaceChars[ch];
                    ++valueEnd;
                }
                --i2;
            }
        }
        this.buf[this.count - 1] = 34;
    }

    public void writeFieldValue(char seperator, String name, Enum<?> value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == null) {
            this.writeNull();
        } else if (this.isEnabled(SerializerFeature.WriteEnumUsingToString)) {
            this.writeString(value.name());
        } else {
            this.writeInt(value.ordinal());
        }
    }

    public void writeFieldValue(char seperator, String name, BigDecimal value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == null) {
            this.writeNull();
        } else {
            this.write(value.toString());
        }
    }

    public void writeString(String text, char seperator) {
        this.writeString(text);
        this.write(seperator);
    }

    public void writeString(String text) {
        if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
            this.writeStringWithSingleQuote(text);
        } else {
            this.writeStringWithDoubleQuote(text);
        }
    }

    private void writeStringWithSingleQuote(String text) {
        char ch;
        if (text == null) {
            int newcount = this.count + 4;
            if (newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            "null".getChars(0, 4, this.buf, this.count);
            this.count = newcount;
            return;
        }
        int len = text.length();
        int newcount = this.count + len + 2;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count + 1;
        int end = start + len;
        this.buf[this.count] = 39;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        int specialCount = 0;
        int lastSpecialIndex = -1;
        char lastSpecial = '\u0000';
        int i = start;
        while (i < end) {
            ch = this.buf[i];
            if (ch == '\b' || ch == '\n' || ch == '\r' || ch == '\f' || ch == '\\' || ch == '\'' || ch == '\t' && this.isEnabled(SerializerFeature.WriteTabAsSpecial)) {
                ++specialCount;
                lastSpecialIndex = i;
                lastSpecial = ch;
            }
            ++i;
        }
        if ((newcount += specialCount) > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.count = newcount;
        if (specialCount == 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, end - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
        } else if (specialCount > 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, end - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
            ++end;
            i = lastSpecialIndex - 2;
            while (i >= start) {
                ch = this.buf[i];
                if (ch == '\b' || ch == '\n' || ch == '\r' || ch == '\f' || ch == '\\' || ch == '\'' || ch == '\t' && this.isEnabled(SerializerFeature.WriteTabAsSpecial)) {
                    System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                    this.buf[i] = 92;
                    this.buf[i + 1] = CharTypes.replaceChars[ch];
                    ++end;
                }
                --i;
            }
        }
        this.buf[this.count - 1] = 39;
    }

    public void writeFieldName(String key) {
        if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
            if (this.isEnabled(SerializerFeature.QuoteFieldNames)) {
                this.writeKeyWithSingleQuote(key);
            } else {
                this.writeKeyWithSingleQuoteIfHasSpecial(key);
            }
        } else if (this.isEnabled(SerializerFeature.QuoteFieldNames)) {
            this.writeKeyWithDoubleQuote(key);
        } else {
            this.writeKeyWithDoubleQuoteIfHasSpecial(key);
        }
    }

    private void writeKeyWithSingleQuote(String text) {
        boolean[] specicalFlags_singleQuotes = CharTypes.specicalFlags_singleQuotes;
        int len = text.length();
        int newcount = this.count + len + 3;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count + 1;
        int end = start + len;
        this.buf[this.count] = 39;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        int i = start;
        while (i < end) {
            char ch = this.buf[i];
            if (ch < specicalFlags_singleQuotes.length && specicalFlags_singleQuotes[ch] || ch == '\t' && this.isEnabled(SerializerFeature.WriteTabAsSpecial)) {
                if (++newcount > this.buf.length) {
                    this.expandCapacity(newcount);
                }
                this.count = newcount;
                System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                this.buf[i] = 92;
                this.buf[++i] = CharTypes.replaceChars[ch];
                ++end;
            }
            ++i;
        }
        this.buf[this.count - 2] = 39;
        this.buf[this.count - 1] = 58;
    }

    private void writeKeyWithDoubleQuoteIfHasSpecial(String text) {
        boolean[] specicalFlags_doubleQuotes = CharTypes.specicalFlags_doubleQuotes;
        int len = text.length();
        int newcount = this.count + len + 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count;
        int end = start + len;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        boolean hasSpecial = false;
        int i = start;
        while (i < end) {
            char ch = this.buf[i];
            if (ch < specicalFlags_doubleQuotes.length && specicalFlags_doubleQuotes[ch]) {
                if (!hasSpecial) {
                    if ((newcount += 3) > this.buf.length) {
                        this.expandCapacity(newcount);
                    }
                    this.count = newcount;
                    System.arraycopy(this.buf, i + 1, this.buf, i + 3, end - i - 1);
                    System.arraycopy(this.buf, 0, this.buf, 1, i);
                    this.buf[start] = 34;
                    this.buf[++i] = 92;
                    this.buf[++i] = CharTypes.replaceChars[ch];
                    end += 2;
                    this.buf[this.count - 2] = 34;
                    hasSpecial = true;
                } else {
                    if (++newcount > this.buf.length) {
                        this.expandCapacity(newcount);
                    }
                    this.count = newcount;
                    System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i);
                    this.buf[i] = 92;
                    this.buf[++i] = CharTypes.replaceChars[ch];
                    ++end;
                }
            }
            ++i;
        }
        this.buf[this.count - 1] = 58;
    }

    private void writeKeyWithSingleQuoteIfHasSpecial(String text) {
        boolean[] specicalFlags_singleQuotes = CharTypes.specicalFlags_singleQuotes;
        int len = text.length();
        int newcount = this.count + len + 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count;
        int end = start + len;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        boolean hasSpecial = false;
        int i = start;
        while (i < end) {
            char ch = this.buf[i];
            if (ch < specicalFlags_singleQuotes.length && specicalFlags_singleQuotes[ch]) {
                if (!hasSpecial) {
                    if ((newcount += 3) > this.buf.length) {
                        this.expandCapacity(newcount);
                    }
                    this.count = newcount;
                    System.arraycopy(this.buf, i + 1, this.buf, i + 3, end - i - 1);
                    System.arraycopy(this.buf, 0, this.buf, 1, i);
                    this.buf[start] = 39;
                    this.buf[++i] = 92;
                    this.buf[++i] = CharTypes.replaceChars[ch];
                    end += 2;
                    this.buf[this.count - 2] = 39;
                    hasSpecial = true;
                } else {
                    if (++newcount > this.buf.length) {
                        this.expandCapacity(newcount);
                    }
                    this.count = newcount;
                    System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i);
                    this.buf[i] = 92;
                    this.buf[++i] = CharTypes.replaceChars[ch];
                    ++end;
                }
            }
            ++i;
        }
        this.buf[newcount - 1] = 58;
    }
}

