/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.serializer.JSONSerializer;
import com.meidusa.fastjson.serializer.NameFilter;
import com.meidusa.fastjson.serializer.ObjectSerializer;
import com.meidusa.fastjson.serializer.PropertyFilter;
import com.meidusa.fastjson.serializer.SerializeWriter;
import com.meidusa.fastjson.serializer.ValueFilter;
import com.meidusa.fastmark.feature.SerializerFeature;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MapSerializer
implements ObjectSerializer {
    public static MapSerializer instance = new MapSerializer();

    @Override
    public void write(JSONSerializer serializer, Object object) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            out.writeNull();
            return;
        }
        TreeMap map = (TreeMap)object;
        if (out.isEnabled(SerializerFeature.SortField)) {
            map = new TreeMap(map);
        }
        out.write('{');
        Class<?> preClazz = null;
        ObjectSerializer preWriter = null;
        boolean first = true;
        for (Map.Entry entry : map.entrySet()) {
            List<ValueFilter> valueFilters;
            List<NameFilter> nameFilters;
            Object value = entry.getValue();
            Object entryKey = entry.getKey();
            String key = entryKey == null ? "null" : entryKey.toString();
            List<PropertyFilter> propertyFilters = serializer.getPropertyFiltersDirect();
            if (propertyFilters != null) {
                boolean apply = true;
                for (PropertyFilter propertyFilter : propertyFilters) {
                    if (propertyFilter.apply(object, key, value)) continue;
                    apply = false;
                    break;
                }
                if (!apply) continue;
            }
            if ((nameFilters = serializer.getNameFiltersDirect()) != null) {
                for (NameFilter nameFilter : nameFilters) {
                    key = nameFilter.process(object, key, value);
                }
            }
            if ((valueFilters = serializer.getValueFiltersDirect()) != null) {
                for (ValueFilter valueFilter : valueFilters) {
                    value = valueFilter.process(object, key, value);
                }
            }
            if (value == null && !serializer.isEnabled(SerializerFeature.WriteMapNullValue)) continue;
            if (!first) {
                out.write(',');
            }
            out.writeFieldName(key);
            first = false;
            if (value == null) {
                out.writeNull();
                continue;
            }
            Class<?> clazz = value.getClass();
            if (clazz == preClazz) {
                preWriter.write(serializer, value);
                continue;
            }
            preClazz = clazz;
            preWriter = serializer.getObjectWriter(clazz);
            preWriter.write(serializer, value);
        }
        out.write('}');
    }
}

