/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.parser.ParserConfig;
import com.meidusa.fastjson.serializer.FieldSerializer;
import com.meidusa.fastjson.serializer.FilterUtils;
import com.meidusa.fastjson.serializer.JSONSerializer;
import com.meidusa.fastjson.serializer.NumberFieldSerializer;
import com.meidusa.fastjson.serializer.ObjectFieldSerializer;
import com.meidusa.fastjson.serializer.ObjectSerializer;
import com.meidusa.fastjson.serializer.SerializeWriter;
import com.meidusa.fastjson.type.DefinedParameterizedTypeBuilder;
import com.meidusa.fastjson.util.FieldInfo;
import com.meidusa.fastmark.Serialize;
import com.meidusa.fastmark.TypeHandle;
import com.meidusa.fastmark.TypeHandleKey;
import com.meidusa.fastmark.feature.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public class JavaBeanSerializer
implements ObjectSerializer {
    private final FieldSerializer[] getters;

    public FieldSerializer[] getGetters() {
        return this.getters;
    }

    public JavaBeanSerializer(Class<?> clazz) {
        this(clazz, (Map<String, String>)null);
    }

    public JavaBeanSerializer(Class<?> clazz, String ... aliasList) {
        this(clazz, JavaBeanSerializer.createAliasMap(aliasList));
    }

    static Map<String, String> createAliasMap(String ... aliasList) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        String[] stringArray = aliasList;
        int n = aliasList.length;
        int n2 = 0;
        while (n2 < n) {
            String alias = stringArray[n2];
            aliasMap.put(alias, alias);
            ++n2;
        }
        return aliasMap;
    }

    public JavaBeanSerializer(Class<?> clazz, Map<String, String> aliasMap) {
        ArrayList<FieldSerializer> getterList = new ArrayList<FieldSerializer>();
        List<FieldInfo> fieldInfoList = JavaBeanSerializer.computeGetters(clazz, aliasMap);
        for (FieldInfo fieldInfo : fieldInfoList) {
            getterList.add(this.createFieldSerializer(fieldInfo));
        }
        this.getters = getterList.toArray(new FieldSerializer[getterList.size()]);
    }

    protected boolean isWriteClassName(JSONSerializer serializer) {
        return serializer.isEnabled(SerializerFeature.WriteClassName);
    }

    @Override
    public void write(JSONSerializer serializer, Object object) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            out.writeNull();
            return;
        }
        Object[] getters = this.getters;
        if (out.isEnabled(SerializerFeature.SortField)) {
            Arrays.sort(getters);
        }
        try {
            out.append('{');
            boolean commaFlag = false;
            if (this.isWriteClassName(serializer)) {
                out.writeFieldName("class");
                serializer.write(object.getClass());
                commaFlag = true;
            }
            int i = 0;
            while (i < getters.length) {
                Field field;
                Object fieldSerializer = getters[i];
                if (!serializer.isEnabled(SerializerFeature.SkipTransientField) || (field = ((FieldSerializer)fieldSerializer).getField()) == null || !Modifier.isTransient(field.getModifiers())) {
                    Object propertyValue = ((FieldSerializer)fieldSerializer).getPropertyValue(object);
                    if (FilterUtils.apply(serializer, object, ((FieldSerializer)fieldSerializer).getName(), propertyValue)) {
                        String key = FilterUtils.processKey(serializer, object, ((FieldSerializer)fieldSerializer).getName(), propertyValue);
                        Object originalValue = propertyValue;
                        propertyValue = FilterUtils.processValue(serializer, object, ((FieldSerializer)fieldSerializer).getName(), propertyValue);
                        if (propertyValue != null || ((FieldSerializer)fieldSerializer).isWriteNull() || serializer.isEnabled(SerializerFeature.WriteMapNullValue)) {
                            if (commaFlag) {
                                out.append(',');
                            }
                            if (StringUtils.equals((String)key, (String)((FieldSerializer)fieldSerializer).getName())) {
                                out.writeFieldName(key);
                                serializer.write(propertyValue);
                            } else if (originalValue != propertyValue) {
                                ((FieldSerializer)fieldSerializer).writePrefix(serializer);
                                serializer.write(propertyValue);
                            } else {
                                ((FieldSerializer)fieldSerializer).writeProperty(serializer, propertyValue);
                            }
                            commaFlag = true;
                        }
                    }
                }
                ++i;
            }
            out.append('}');
        }
        catch (Exception e) {
            throw new JSONException("write javaBean error", e);
        }
    }

    public FieldSerializer createFieldSerializer(FieldInfo fieldInfo) {
        Class<?> clazz = fieldInfo.getMethod().getReturnType();
        if (clazz == Number.class) {
            return new NumberFieldSerializer(fieldInfo);
        }
        return new ObjectFieldSerializer(fieldInfo);
    }

    public static Set<String> getTypeHandleKey(Class<?> clazz, Class<?> stopClazz) {
        Class<?> superClazz = clazz;
        HashSet<String> keySets = new HashSet<String>();
        while (superClazz != stopClazz && superClazz != Object.class) {
            Field[] fields;
            TypeHandle typeHandle = superClazz.getAnnotation(TypeHandle.class);
            if (typeHandle != null && typeHandle.key() != null) {
                keySets.add(typeHandle.key());
            }
            Field[] fieldArray = fields = superClazz.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                TypeHandleKey typeHandlekey = field.getAnnotation(TypeHandleKey.class);
                if (typeHandlekey != null) {
                    keySets.add(field.getName());
                }
                ++n2;
            }
            superClazz = superClazz.getSuperclass();
        }
        return keySets;
    }

    public static Map<String, Field> getAllFields(Class<?> clazz, Class<?> stopClazz) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        Class<?> superClazz = clazz;
        while (superClazz != stopClazz && superClazz != Object.class) {
            Field[] fields;
            Field[] fieldArray = fields = superClazz.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                fieldMap.put(field.getName(), field);
                ++n2;
            }
            superClazz = superClazz.getSuperclass();
        }
        return fieldMap;
    }

    /*
     * Unable to fully structure code
     */
    public static List<FieldInfo> computeGetters(Type type, Map<String, String> aliasMap) {
        variableMap = new HashMap<TypeVariable<?>, Type>();
        DefinedParameterizedTypeBuilder.buildTypeVariableMap(type, variableMap);
        clazz = null;
        if (type instanceof Class) {
            clazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            clazz = (Class)((ParameterizedType)type).getRawType();
        }
        handleKey = JavaBeanSerializer.getTypeHandleKey(clazz, Object.class);
        getterMap = new TreeMap<String, FieldInfo>();
        var9_6 = clazz.getMethods();
        var8_7 = var9_6.length;
        var7_8 = 0;
        while (var7_8 < var8_7) {
            block13: {
                block17: {
                    block15: {
                        block16: {
                            block14: {
                                method = var9_6[var7_8];
                                methodName = method.getName();
                                if (Modifier.isStatic(method.getModifiers()) || method.getReturnType().equals(Void.TYPE) || method.getParameterTypes().length != 0) break block13;
                                annotation = method.getAnnotation(Serialize.class);
                                if (annotation == null) break block14;
                                if (!annotation.serialize()) break block13;
                                if (annotation.name().length() != 0) {
                                    propertyName = annotation.name();
                                    if (aliasMap == null || (propertyName = aliasMap.get(propertyName)) != null) {
                                        getterMap.put(propertyName, new FieldInfo(propertyName, method, variableMap, null, handleKey.contains(propertyName)));
                                        ** GOTO lbl52
                                    } else {
                                        ** GOTO lbl28
                                    }
                                }
                                break block14;
lbl28:
                                // 2 sources

                                break block13;
                            }
                            if (!methodName.startsWith("get")) break block15;
                            if (methodName.length() < 4 || methodName.equals("getClass") || !Character.isUpperCase(methodName.charAt(3))) break block13;
                            propertyName = String.valueOf(Character.toLowerCase(methodName.charAt(3))) + methodName.substring(4);
                            field = ParserConfig.getField(clazz, propertyName);
                            if (field == null || (fieldAnnotation = field.getAnnotation(Serialize.class)) == null || fieldAnnotation.name().length() == 0) break block16;
                            propertyName = fieldAnnotation.name();
                            if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) break block13;
                        }
                        if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) break block13;
                        getterMap.put(propertyName, new FieldInfo(propertyName, method, variableMap, field, handleKey.contains(propertyName)));
                    }
                    if (!methodName.startsWith("is") || methodName.length() < 3 || !Character.isUpperCase(methodName.charAt(2))) break block13;
                    propertyName = String.valueOf(Character.toLowerCase(methodName.charAt(2))) + methodName.substring(3);
                    field = ParserConfig.getField(clazz, propertyName);
                    if (field == null || (fieldAnnotation = field.getAnnotation(Serialize.class)) == null || fieldAnnotation.name().length() == 0) break block17;
                    propertyName = fieldAnnotation.name();
                    if (aliasMap != null && (propertyName = aliasMap.get(propertyName)) == null) break block13;
                }
                if (aliasMap == null || (propertyName = aliasMap.get(propertyName)) != null) {
                    getterMap.put(propertyName, new FieldInfo(propertyName, method, variableMap, field, handleKey.contains(propertyName)));
                }
            }
            ++var7_8;
        }
        return new LinkedList<FieldInfo>(getterMap.values());
    }
}

