/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.serializer.JSONSerializer;
import com.meidusa.fastjson.serializer.SerializeWriter;
import com.meidusa.fastjson.util.FieldInfo;
import com.meidusa.fastmark.Serialize;
import com.meidusa.fastmark.feature.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public abstract class FieldSerializer
implements Comparable<FieldSerializer> {
    protected final FieldInfo fieldInfo;
    private final String double_quoted_fieldPrefix;
    private final String single_quoted_fieldPrefix;
    private final String un_quoted_fieldPrefix;
    private boolean writeNull = false;

    public FieldSerializer(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        fieldInfo.getMethod().setAccessible(true);
        this.double_quoted_fieldPrefix = String.valueOf('\"') + fieldInfo.getName() + "\":";
        this.single_quoted_fieldPrefix = String.valueOf('\'') + fieldInfo.getName() + "':";
        this.un_quoted_fieldPrefix = String.valueOf(fieldInfo.getName()) + ":";
        Serialize annotation = fieldInfo.getAnnotation(Serialize.class);
        if (annotation != null) {
            SerializerFeature[] serializerFeatureArray = annotation.serialzeFeatures();
            int n = serializerFeatureArray.length;
            int n2 = 0;
            while (n2 < n) {
                SerializerFeature feature = serializerFeatureArray[n2];
                if (feature == SerializerFeature.WriteMapNullValue) {
                    this.writeNull = true;
                }
                ++n2;
            }
        }
    }

    public boolean isWriteNull() {
        return this.writeNull;
    }

    public Field getField() {
        return this.fieldInfo.getField();
    }

    public String getName() {
        return this.fieldInfo.getName();
    }

    public Method getMethod() {
        return this.fieldInfo.getMethod();
    }

    public void writePrefix(JSONSerializer serializer) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (serializer.isEnabled(SerializerFeature.QuoteFieldNames)) {
            if (serializer.isEnabled(SerializerFeature.UseSingleQuotes)) {
                out.write(this.single_quoted_fieldPrefix);
            } else {
                out.write(this.double_quoted_fieldPrefix);
            }
        } else {
            out.write(this.un_quoted_fieldPrefix);
        }
    }

    @Override
    public int compareTo(FieldSerializer o) {
        return this.getName().compareTo(o.getName());
    }

    public Object getPropertyValue(Object object) throws Exception {
        return this.getMethod().invoke(object, new Object[0]);
    }

    public abstract void writeProperty(JSONSerializer var1, Object var2) throws Exception;
}

