package com.meidusa.fastjson.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;

import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.type.DefinedParameterizedTypeBuilder;

public class FieldInfo implements Comparable<FieldInfo> {

	private final String name;
	private final Method method;
	private final Field field;

	private final Class<?> fieldClass;
	private final Type fieldType;

	private final boolean isTypeHandle;

	@Override
	public String toString() {
		return "FieldInfo [name=" + name + ", method=" + method + ", field=" + field + ", fieldClass=" + fieldClass
				+ ", fieldType=" + fieldType + ", isTypeHandle=" + isTypeHandle + "]";
	}

	public FieldInfo(String name, Method method, Map<TypeVariable<?>, Type> typeMap, Field field, boolean isKey) {
		this.name = name;
		this.method = method;
		this.field = field;

		this.isTypeHandle = isKey;

		if (method.getParameterTypes().length == 1) {
			this.fieldClass = method.getParameterTypes()[0];
			this.fieldType = DefinedParameterizedTypeBuilder.buildDefinedType(method.getGenericParameterTypes()[0],
					typeMap);
		} else {
			this.fieldClass = method.getReturnType();
			this.fieldType = DefinedParameterizedTypeBuilder.buildDefinedType(method.getGenericReturnType(), typeMap);
		}
		if (this.fieldType instanceof ParameterizedType) {
			DefaultExtJSONParser.putType(fieldType.toString(), fieldType);
		}
	}

	public boolean isTypeHandle() {
		return isTypeHandle;
	}

	public Class<?> getFieldClass() {
		return fieldClass;
	}

	public Type getFieldType() {
		return fieldType;
	}

	public String getName() {
		return name;
	}

	public Method getMethod() {
		return method;
	}

	public Field getField() {
		return field;
	}

	public int compareTo(FieldInfo o) {
		if (isTypeHandle && !o.isTypeHandle) {
			return -Integer.MIN_VALUE;
		}
//		return this.name.compareTo(o.name);
		return 0;
	}

	public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
		T annotation = null;
		annotation = method.getAnnotation(annotationClass);

		if (annotation == null) {
			if (field != null) {
				annotation = field.getAnnotation(annotationClass);
			}
		}

		return annotation;
	}
}
