/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastbson.serializer;

import com.meidusa.fastbson.ASMSerializerFactory;
import com.meidusa.fastbson.exception.SerializeException;
import com.meidusa.fastbson.parse.BSONScanner;
import com.meidusa.fastbson.parse.BSONWriter;
import com.meidusa.fastbson.serializer.BasicSerializerGroup;
import com.meidusa.fastbson.serializer.ObjectSerializer;
import com.meidusa.fastbson.util.ObjectId;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class UnknownTypeSerializer
implements ObjectSerializer {
    private static ObjectSerializer OBJECT_SERIALIZER = BasicSerializerGroup.hashMapSerializer;
    private static ObjectSerializer ARRAY_SERIALIZER = BasicSerializerGroup.arrayListSerializer;
    private static ObjectSerializer UNKNOWN_SERIALIZER = new UnknownTypeSerializer();

    public static ObjectSerializer getInstance() {
        return UNKNOWN_SERIALIZER;
    }

    @Override
    public Object deserialize(BSONScanner scanner, ObjectSerializer[] subSerializer, int i) {
        byte type = scanner.getCurrentType();
        switch (type) {
            case 2: {
                return scanner.readBSONString();
            }
            case 1: {
                return scanner.readBSONDouble();
            }
            case 5: {
                return scanner.readBSONBinary();
            }
            case 16: {
                return scanner.readBSONInt();
            }
            case 18: {
                return scanner.readBSONLong();
            }
            case 126: {
                return scanner.readBSONBigDecimal();
            }
            case 8: {
                return scanner.readBSONBoolean();
            }
            case 7: {
                return scanner.readBSONOid();
            }
            case 9: {
                return scanner.readDate();
            }
            case 3: {
                return OBJECT_SERIALIZER.deserialize(scanner, new ObjectSerializer[]{UNKNOWN_SERIALIZER}, 0);
            }
            case 4: {
                return ARRAY_SERIALIZER.deserialize(scanner, new ObjectSerializer[]{UNKNOWN_SERIALIZER}, 0);
            }
        }
        throw new SerializeException.UnsupportedTypeException("type not supported " + type);
    }

    @Override
    public void serialize(BSONWriter writer, Object val, ObjectSerializer[] subSerializer, int i) {
        if (val != null) {
            if (val instanceof String) {
                writer.writeValue((String)val);
            } else if (val instanceof Number) {
                if (val instanceof Integer || val instanceof Short || val instanceof Byte || val instanceof AtomicInteger) {
                    writer.writeValue(((Number)val).intValue());
                } else if (val instanceof Long || val instanceof AtomicLong) {
                    writer.writeValue(((Number)val).longValue());
                } else if (val instanceof BigDecimal) {
                    writer.writeValue((BigDecimal)val);
                } else {
                    writer.writeValue(((Number)val).doubleValue());
                }
            } else if (val instanceof Date) {
                writer.writeValue((Date)val);
            } else if (val instanceof Map) {
                ASMSerializerFactory.getSerializer(val.getClass()).serialize(writer, val, new ObjectSerializer[]{UNKNOWN_SERIALIZER}, 0);
            } else if (val instanceof ObjectId) {
                writer.writeBytes(((ObjectId)val).toByteArray());
            } else if (val instanceof Boolean) {
                writer.writeValue((Boolean)val);
            } else if (val instanceof List) {
                ASMSerializerFactory.getSerializer(val.getClass()).serialize(writer, val, new ObjectSerializer[]{UNKNOWN_SERIALIZER}, 0);
            } else if (val instanceof byte[]) {
                writer.writeValue((byte[])val);
            } else if (val.getClass().isArray()) {
                Class<?> listClass = val.getClass();
                Class<?> componentClass = listClass.getComponentType();
                ObjectSerializer serializer = ASMSerializerFactory.getSerializer(Object[].class);
                ObjectSerializer[] componentSerializer = new ObjectSerializer[]{ASMSerializerFactory.getSerializer(componentClass)};
                serializer.serialize(writer, val, componentSerializer, 0);
            } else if (val instanceof Date) {
                writer.writeValue((Date)val);
            } else if (val.getClass().isEnum()) {
                writer.writeValue(val.toString());
            } else {
                ObjectSerializer serializer = ASMSerializerFactory.getSerializer(val.getClass());
                serializer.serialize(writer, val, new ObjectSerializer[0], 0);
            }
        }
    }

    @Override
    public Class<?> getSerializedClass() {
        return null;
    }

    @Override
    public byte getBsonSuffix() {
        return 0;
    }
}

