/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastbson.serializer;

import com.meidusa.fastbson.exception.SerializeException;
import com.meidusa.fastbson.parse.BSONScanner;
import com.meidusa.fastbson.parse.BSONWriter;
import com.meidusa.fastbson.serializer.AbstractObjectSerializer;
import com.meidusa.fastbson.serializer.ObjectSerializer;
import com.meidusa.fastbson.serializer.UnknownTypeSerializer;
import java.util.Collection;

public abstract class CollectionSerializer
extends AbstractObjectSerializer {
    @Override
    public Object deserialize(BSONScanner scanner, ObjectSerializer[] subSerializer, int i) {
        Collection coll;
        ObjectSerializer subSerializerCurrent = subSerializer[i++];
        scanner.skip(4);
        try {
            coll = (Collection)this.getSerializedClass().newInstance();
        }
        catch (Exception e) {
            throw new SerializeException("couldn't happened....");
        }
        while (scanner.readType() != 0) {
            scanner.readCString();
            coll.add(subSerializerCurrent.deserialize(scanner, subSerializer, i));
        }
        return coll;
    }

    @Override
    public void serialize(BSONWriter writer, Object value, ObjectSerializer[] subSerializer, int i) {
        ObjectSerializer subSerializerCurrent = subSerializer[i++];
        Collection listValue = (Collection)value;
        writer.beginArray();
        int j = 0;
        for (Object o : listValue) {
            if (subSerializerCurrent instanceof UnknownTypeSerializer) {
                writer.write(CollectionSerializer.getUnknownBsonSuffix(o));
            } else {
                writer.write(subSerializerCurrent.getBsonSuffix());
            }
            writer.writeCString(String.valueOf(j++));
            subSerializerCurrent.serialize(writer, o, subSerializer, i);
        }
        writer.endArray();
    }

    @Override
    public abstract Class<?> getSerializedClass();

    @Override
    public byte getBsonSuffix() {
        return 3;
    }
}

