/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastbson.parse;

import com.meidusa.fastbson.parse.BSONWriter;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.Stack;

public class ByteArrayBSONWriter
implements BSONWriter {
    private static final byte BLANK = 0;
    private static final byte TRUE = 1;
    private static final byte FALSE = 0;
    private byte[] buffer;
    private int current;
    private Stack<Integer> subBeginPos = new Stack();

    @Override
    public void clear() {
        if (this.buffer.length > 524288) {
            this.buffer = new byte[65536];
        }
        if (this.subBeginPos.size() > 10) {
            this.subBeginPos = new Stack();
        }
        this.current = 0;
    }

    private void ensureLength(int length) {
        if (this.current + length >= this.buffer.length) {
            byte[] newBuffer = new byte[Math.max(this.buffer.length * 2, this.current + length)];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
    }

    @Override
    public void skip(int num) {
        this.current += num;
    }

    @Override
    public void writeBytes(byte[] bts) {
        this.ensureLength(bts.length);
        System.arraycopy(bts, 0, this.buffer, this.current, bts.length);
        this.current += bts.length;
    }

    private void writeIntAt(int position, int i) {
        this.ensureLength(position + 4);
        this.buffer[position++] = (byte)i;
        this.buffer[position++] = (byte)(i >> 8);
        this.buffer[position++] = (byte)(i >> 16);
        this.buffer[position++] = (byte)(i >> 24);
    }

    public ByteArrayBSONWriter() {
        this.buffer = new byte[65536];
    }

    @Override
    public void begin() {
        this.skip(4);
    }

    @Override
    public void end() {
        this.writeIntAt(0, this.current);
        this.write((byte)0);
    }

    @Override
    public void writeValue(boolean b) {
        this.ensureLength(1);
        this.buffer[this.current++] = b ? (byte)1 : 0;
    }

    @Override
    public void writeValue(Boolean b) {
        this.ensureLength(1);
        this.buffer[this.current++] = b == true ? (byte)1 : 0;
    }

    @Override
    public void writeValue(int i) {
        this.ensureLength(4);
        this.buffer[this.current++] = (byte)i;
        this.buffer[this.current++] = (byte)(i >> 8);
        this.buffer[this.current++] = (byte)(i >> 16);
        this.buffer[this.current++] = (byte)(i >> 24);
    }

    @Override
    public void writeValue(Integer i) {
        this.ensureLength(4);
        this.buffer[this.current++] = (byte)(i >> 0);
        this.buffer[this.current++] = (byte)(i >> 8);
        this.buffer[this.current++] = (byte)(i >> 16);
        this.buffer[this.current++] = (byte)(i >> 24);
    }

    @Override
    public void writeValue(long l) {
        this.ensureLength(8);
        this.buffer[this.current++] = (byte)l;
        this.buffer[this.current++] = (byte)(l >> 8);
        this.buffer[this.current++] = (byte)(l >> 16);
        this.buffer[this.current++] = (byte)(l >> 24);
        this.buffer[this.current++] = (byte)(l >> 32);
        this.buffer[this.current++] = (byte)(l >> 40);
        this.buffer[this.current++] = (byte)(l >> 48);
        this.buffer[this.current++] = (byte)(l >> 56);
    }

    @Override
    public void writeValue(Long l) {
        this.ensureLength(8);
        this.buffer[this.current++] = (byte)(l >> 0);
        this.buffer[this.current++] = (byte)(l >> 8);
        this.buffer[this.current++] = (byte)(l >> 16);
        this.buffer[this.current++] = (byte)(l >> 24);
        this.buffer[this.current++] = (byte)(l >> 32);
        this.buffer[this.current++] = (byte)(l >> 40);
        this.buffer[this.current++] = (byte)(l >> 48);
        this.buffer[this.current++] = (byte)(l >> 56);
    }

    @Override
    public void writeValue(float f) {
        this.ensureLength(8);
        Long l = Double.doubleToLongBits(f);
        this.buffer[this.current++] = (byte)(l >> 0);
        this.buffer[this.current++] = (byte)(l >> 8);
        this.buffer[this.current++] = (byte)(l >> 16);
        this.buffer[this.current++] = (byte)(l >> 24);
        this.buffer[this.current++] = (byte)(l >> 32);
        this.buffer[this.current++] = (byte)(l >> 40);
        this.buffer[this.current++] = (byte)(l >> 48);
        this.buffer[this.current++] = (byte)(l >> 56);
    }

    @Override
    public void writeValue(Float f) {
        this.ensureLength(8);
        Long l = Double.doubleToLongBits(f.floatValue());
        this.buffer[this.current++] = (byte)(l >> 0);
        this.buffer[this.current++] = (byte)(l >> 8);
        this.buffer[this.current++] = (byte)(l >> 16);
        this.buffer[this.current++] = (byte)(l >> 24);
        this.buffer[this.current++] = (byte)(l >> 32);
        this.buffer[this.current++] = (byte)(l >> 40);
        this.buffer[this.current++] = (byte)(l >> 48);
        this.buffer[this.current++] = (byte)(l >> 56);
    }

    @Override
    public void writeValue(double d) {
        this.ensureLength(8);
        Long l = Double.doubleToLongBits(d);
        this.buffer[this.current++] = (byte)(l >> 0);
        this.buffer[this.current++] = (byte)(l >> 8);
        this.buffer[this.current++] = (byte)(l >> 16);
        this.buffer[this.current++] = (byte)(l >> 24);
        this.buffer[this.current++] = (byte)(l >> 32);
        this.buffer[this.current++] = (byte)(l >> 40);
        this.buffer[this.current++] = (byte)(l >> 48);
        this.buffer[this.current++] = (byte)(l >> 56);
    }

    @Override
    public void writeValue(Double d) {
        this.ensureLength(8);
        Long l = Double.doubleToLongBits(d);
        this.buffer[this.current++] = (byte)(l >> 0);
        this.buffer[this.current++] = (byte)(l >> 8);
        this.buffer[this.current++] = (byte)(l >> 16);
        this.buffer[this.current++] = (byte)(l >> 24);
        this.buffer[this.current++] = (byte)(l >> 32);
        this.buffer[this.current++] = (byte)(l >> 40);
        this.buffer[this.current++] = (byte)(l >> 48);
        this.buffer[this.current++] = (byte)(l >> 56);
    }

    @Override
    public void writeValue(String s) {
        byte[] bts = s.getBytes(Charset.forName("UTF-8"));
        this.ensureLength(bts.length + 5);
        int i = bts.length + 1;
        this.buffer[this.current++] = (byte)(i >> 0);
        this.buffer[this.current++] = (byte)(i >> 8);
        this.buffer[this.current++] = (byte)(i >> 16);
        this.buffer[this.current++] = (byte)(i >> 24);
        System.arraycopy(bts, 0, this.buffer, this.current, i - 1);
        this.current += i - 1;
        this.buffer[this.current++] = 0;
    }

    @Override
    public void writeValue(Date dt) {
        this.ensureLength(8);
        long l = dt.getTime();
        this.buffer[this.current++] = (byte)l;
        this.buffer[this.current++] = (byte)(l >> 8);
        this.buffer[this.current++] = (byte)(l >> 16);
        this.buffer[this.current++] = (byte)(l >> 24);
        this.buffer[this.current++] = (byte)(l >> 32);
        this.buffer[this.current++] = (byte)(l >> 40);
        this.buffer[this.current++] = (byte)(l >> 48);
        this.buffer[this.current++] = (byte)(l >> 56);
    }

    @Override
    public void writeValue(BigDecimal dt) {
        byte[] bts = dt.unscaledValue().toByteArray();
        int scale = dt.scale();
        int size = bts.length;
        this.ensureLength(bts.length + 8);
        this.buffer[this.current++] = (byte)(size >> 0);
        this.buffer[this.current++] = (byte)(size >> 8);
        this.buffer[this.current++] = (byte)(size >> 16);
        this.buffer[this.current++] = (byte)(size >> 24);
        System.arraycopy(bts, 0, this.buffer, this.current, size);
        this.current += size;
        this.buffer[this.current++] = (byte)(scale >> 0);
        this.buffer[this.current++] = (byte)(scale >> 8);
        this.buffer[this.current++] = (byte)(scale >> 16);
        this.buffer[this.current++] = (byte)(scale >> 24);
    }

    @Override
    public void write(byte b) {
        this.ensureLength(1);
        this.buffer[this.current++] = b;
    }

    @Override
    public void writeValue(byte b) {
        this.writeValue((int)b);
    }

    @Override
    public void writeValue(Byte b) {
        this.writeValue((int)b.byteValue());
    }

    @Override
    public void writeCString(String s) {
        this.ensureLength(s.length() + 1);
        byte[] strBts = s.getBytes(Charset.forName("UTF-8"));
        this.writeBytes(strBts);
        this.buffer[this.current++] = 0;
    }

    @Override
    public void beginArray() {
        this.subBeginPos.push(this.current);
        this.ensureLength(4);
        this.skip(4);
    }

    @Override
    public void beginObject() {
        this.subBeginPos.push(this.current);
        this.ensureLength(4);
        this.skip(4);
    }

    @Override
    public void endArray() {
        this.ensureLength(1);
        this.write((byte)0);
        int pos = this.subBeginPos.pop();
        this.writeIntAt(pos, this.current - pos);
    }

    @Override
    public void endObject() {
        this.ensureLength(1);
        this.write((byte)0);
        int pos = this.subBeginPos.pop();
        this.writeIntAt(pos, this.current - pos);
    }

    @Override
    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public int getLength() {
        return this.current;
    }

    @Override
    public void writeValue(byte[] val) {
        this.writeValue(val.length);
        this.write((byte)0);
        this.writeBytes(val);
    }

    public String toString() {
        return "ByteArrayBSONWriter [buffer=" + Arrays.toString(this.buffer) + ", current=" + this.current + ", subBeginPos=" + this.subBeginPos + "]";
    }
}

