/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastbson;

import com.meidusa.fastbson.ASMContext;
import com.meidusa.fastbson.FieldInfo;
import com.meidusa.fastbson.annotation.As;
import com.meidusa.fastbson.exception.SerializeException;
import com.meidusa.fastbson.parse.BSONScanner;
import com.meidusa.fastbson.parse.BSONWriter;
import com.meidusa.fastbson.serializer.AbstractObjectSerializer;
import com.meidusa.fastbson.serializer.ArraySerializer;
import com.meidusa.fastbson.serializer.BasicSerializerGroup;
import com.meidusa.fastbson.serializer.BigDecimalSerializer;
import com.meidusa.fastbson.serializer.BooleanSerializer;
import com.meidusa.fastbson.serializer.DoubleSerializer;
import com.meidusa.fastbson.serializer.EnumSerializer;
import com.meidusa.fastbson.serializer.FloatSerializer;
import com.meidusa.fastbson.serializer.IntegerSerializer;
import com.meidusa.fastbson.serializer.LongSerializer;
import com.meidusa.fastbson.serializer.ObjectSerializer;
import com.meidusa.fastbson.serializer.PrimitiveBooleanSerializer;
import com.meidusa.fastbson.serializer.PrimitiveDoubleSerializer;
import com.meidusa.fastbson.serializer.PrimitiveFloatSerializer;
import com.meidusa.fastbson.serializer.PrimitiveIntSerializer;
import com.meidusa.fastbson.serializer.PrimitiveLongSerializer;
import com.meidusa.fastbson.serializer.PrimitiveShortSerializer;
import com.meidusa.fastbson.serializer.StringSerializer;
import com.meidusa.fastbson.serializer.UnknownTypeSerializer;
import com.meidusa.fastbson.util.ASMClassLoader;
import com.meidusa.fastbson.util.TypeHelper;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class ASMSerializerFactory {
    private ASMClassLoader classLoader = new ASMClassLoader();
    private static ASMSerializerFactory serializerFactory = new ASMSerializerFactory();
    private HashMap<Class<?>, ObjectSerializer> serializerMap;
    private final String BSON_FIELD_SUFFIX = "_bson";
    private final String BYTE_FIELD_SUFFIX = "_prefix";
    private final String SERIALIZER_FIELD_SUFFIX = "_serializer";
    private final String SUB_SERIALIZER_FIELD_SUFFIX = "_sub_serializer";
    private final String FIELD_SET = "_set";
    private final String SUPER_CLASS = this.getType(AbstractObjectSerializer.class);
    private final String[] INTERFACE = new String[]{this.getType(ObjectSerializer.class)};

    private static ASMSerializerFactory getInstance() {
        return serializerFactory;
    }

    private ASMSerializerFactory() {
        this.initSerializers();
    }

    private void initSerializers() {
        this.serializerMap = new HashMap();
        this.serializerMap.put(ArrayList.class, BasicSerializerGroup.arrayListSerializer);
        this.serializerMap.put(BigDecimal.class, new BigDecimalSerializer());
        this.serializerMap.put(Boolean.class, new BooleanSerializer());
        this.serializerMap.put(Double.class, new DoubleSerializer());
        this.serializerMap.put(Float.class, new FloatSerializer());
        this.serializerMap.put(LinkedHashMap.class, BasicSerializerGroup.linkedHashMapSerializer);
        this.serializerMap.put(HashMap.class, BasicSerializerGroup.hashMapSerializer);
        this.serializerMap.put(Map.class, BasicSerializerGroup.hashMapSerializer);
        this.serializerMap.put(Set.class, BasicSerializerGroup.hashSetSerializer);
        this.serializerMap.put(HashSet.class, BasicSerializerGroup.hashSetSerializer);
        this.serializerMap.put(LinkedHashSet.class, BasicSerializerGroup.linkedHashSetSerializer);
        this.serializerMap.put(Integer.class, new IntegerSerializer());
        this.serializerMap.put(LinkedList.class, BasicSerializerGroup.linkedListSerializer);
        this.serializerMap.put(List.class, BasicSerializerGroup.arrayListSerializer);
        this.serializerMap.put(Long.class, new LongSerializer());
        this.serializerMap.put(Object[].class, new ArraySerializer());
        this.serializerMap.put(Boolean.TYPE, new PrimitiveBooleanSerializer());
        this.serializerMap.put(Double.TYPE, new PrimitiveDoubleSerializer());
        this.serializerMap.put(Float.TYPE, new PrimitiveFloatSerializer());
        this.serializerMap.put(Integer.TYPE, new PrimitiveIntSerializer());
        this.serializerMap.put(Long.TYPE, new PrimitiveLongSerializer());
        this.serializerMap.put(Short.TYPE, new PrimitiveShortSerializer());
        this.serializerMap.put(String.class, new StringSerializer());
        this.serializerMap.put(Object.class, new UnknownTypeSerializer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectSerializer innerGetSerializer(Class<?> clazz) {
        ObjectSerializer serializer = this.serializerMap.get(clazz);
        if (serializer == null) {
            HashMap<Class<?>, ObjectSerializer> hashMap = this.serializerMap;
            synchronized (hashMap) {
                serializer = this.serializerMap.get(clazz);
                if (serializer == null) {
                    serializer = this.createSerializer(clazz);
                    this.serializerMap.put(clazz, serializer);
                }
            }
        }
        return serializer;
    }

    public static ObjectSerializer getSerializer(Class<?> clazz) {
        return ASMSerializerFactory.getInstance().innerGetSerializer(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createAndReplace(Class<?> replaced, Class<?> replace) {
        ObjectSerializer serializerReplaced = ASMSerializerFactory.getInstance().serializerMap.get(replaced);
        if (serializerReplaced != null) {
            return;
        }
        ObjectSerializer serializerReplace = ASMSerializerFactory.getSerializer(replace);
        if (serializerReplace != null) {
            HashMap<Class<?>, ObjectSerializer> hashMap = ASMSerializerFactory.getInstance().serializerMap;
            synchronized (hashMap) {
                if (serializerReplaced == null) {
                    ASMSerializerFactory.getInstance().serializerMap.put(replaced, serializerReplace);
                    ASMSerializerFactory.getInstance().serializerMap.put(replace, serializerReplace);
                    return;
                }
            }
        }
    }

    public ObjectSerializer createSerializer(final Class<?> clazz) {
        if (clazz.isEnum()) {
            return new EnumSerializer(){

                @Override
                public Class<? extends Enum> getSerializedClass() {
                    return clazz;
                }
            };
        }
        ClassWriter clsWriter = new ClassWriter(1);
        String className = this.getClassName(clazz);
        clsWriter.visit(49, 33, this.getClassName(clazz), "null", this.SUPER_CLASS, this.INTERFACE);
        ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>();
        this.analyzeFields(clazz, fieldInfoList);
        ASMContext ctx = new ASMContext(4);
        ctx.serializerClass = className;
        ctx.fieldInfoList = fieldInfoList;
        ctx.baseClass = clazz;
        this.writeField(clsWriter, ctx);
        this.writeInit(clsWriter, ctx);
        this.writeDeserialize(clsWriter, ctx);
        this.writeSerialize(clsWriter, ctx);
        this.writeGetSerializedClass(clsWriter, ctx.baseClass);
        byte[] code = clsWriter.toByteArray();
        Class<?> exampleClass = this.classLoader.defineClassPublic(className, code, 0, code.length);
        Object instance = null;
        try {
            instance = exampleClass.newInstance();
            return instance;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SerializeException.ASMWrapperException("can't create class", e);
        }
    }

    private String getClassName(Class<?> clazz) {
        String className = clazz.getCanonicalName();
        className = className.replace('.', '_');
        className = className + "_asm_generated";
        return className;
    }

    public void analyzeFields(Class<?> clazz, List<FieldInfo> fieldInfoList) {
        do {
            HashSet fieldNames = new HashSet();
            for (Field field : clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || field.getName().equals("this$0")) continue;
                FieldInfo info = new FieldInfo(field.getName(), Modifier.isPublic(modifiers), field.getGenericType());
                As name = field.getAnnotation(As.class);
                String fieldName = name != null ? name.value() : info.getName();
                if (fieldNames.contains(fieldName)) {
                    throw new SerializeException.DuplicateFieldNameException(clazz.toString() + "has duplicate fieldName: " + fieldName);
                }
                info.setAsName(fieldName);
                info.setTypes(TypeHelper.getGenericDeserializer(info.getFieldType()));
                info.setBsonType(this.getBsonType(field.getType()));
                fieldInfoList.add(info);
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class);
    }

    private String getPrimitiveLetter(Class<?> type) {
        if (Integer.TYPE.equals(type)) {
            return "I";
        }
        if (Void.TYPE.equals(type)) {
            return "V";
        }
        if (Boolean.TYPE.equals(type)) {
            return "Z";
        }
        if (Character.TYPE.equals(type)) {
            return "C";
        }
        if (Byte.TYPE.equals(type)) {
            return "B";
        }
        if (Short.TYPE.equals(type)) {
            return "S";
        }
        if (Float.TYPE.equals(type)) {
            return "F";
        }
        if (Long.TYPE.equals(type)) {
            return "J";
        }
        if (Double.TYPE.equals(type)) {
            return "D";
        }
        throw new IllegalStateException("Type: " + type.getCanonicalName() + " is not a primitive type");
    }

    public String getType(Class<?> type) {
        if (type.isArray()) {
            return "[" + this.getDesc(type.getComponentType());
        }
        if (!type.isPrimitive()) {
            String clsName = type.getCanonicalName();
            if (type.isMemberClass()) {
                int lastDot = clsName.lastIndexOf(".");
                clsName = clsName.substring(0, lastDot) + "$" + clsName.substring(lastDot + 1);
            }
            return clsName.replaceAll("\\.", "/");
        }
        return this.getPrimitiveLetter(type);
    }

    public String getDesc(Class<?> type) {
        if (type.isPrimitive()) {
            return this.getPrimitiveLetter(type);
        }
        if (type.isArray()) {
            return "[" + this.getDesc(type.getComponentType());
        }
        return "L" + this.getType(type) + ";";
    }

    private String constructMethodDesc(Class<?> returnType, Class<?> ... paramType) {
        StringBuilder methodDesc = new StringBuilder();
        methodDesc.append('(');
        for (int i = 0; i < paramType.length; ++i) {
            methodDesc.append(this.getDesc(paramType[i]));
        }
        methodDesc.append(')');
        if (returnType == Void.class) {
            methodDesc.append("V");
        } else {
            methodDesc.append(this.getDesc(returnType));
        }
        return methodDesc.toString();
    }

    private Byte getBsonType(Class<?> clazz) {
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return (byte)16;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return (byte)18;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return (byte)1;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (byte)1;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (byte)8;
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return (byte)16;
        }
        if (clazz == Date.class) {
            return (byte)9;
        }
        if (clazz == String.class || clazz.isEnum()) {
            return (byte)2;
        }
        if (clazz == byte[].class) {
            return (byte)5;
        }
        if (clazz == BigDecimal.class) {
            return (byte)126;
        }
        if (clazz.isArray() || ClassUtils.isAssignable(clazz, Collection.class)) {
            return (byte)4;
        }
        if (clazz == Object.class) {
            return null;
        }
        return (byte)3;
    }

    private void writeField(ClassWriter clsWriter, ASMContext ctx) {
        FieldVisitor fdVisitor;
        FieldInfo fieldInfo;
        int i;
        for (i = 0; i < ctx.fieldInfoList.size(); ++i) {
            fieldInfo = ctx.fieldInfoList.get(i);
            fdVisitor = clsWriter.visitField(1, fieldInfo.getName() + "_prefix", this.getType(byte[].class), "", null);
            fdVisitor.visitEnd();
        }
        for (i = 0; i < ctx.fieldInfoList.size(); ++i) {
            fieldInfo = ctx.fieldInfoList.get(i);
            if (fieldInfo.getBsonType() == null) continue;
            fdVisitor = clsWriter.visitField(1, fieldInfo.getName() + "_bson", this.getType(Byte.TYPE), "", null);
            fdVisitor.visitEnd();
        }
        for (i = 0; i < ctx.fieldInfoList.size(); ++i) {
            fieldInfo = ctx.fieldInfoList.get(i);
            if (!this.shouldHaveSerializer(fieldInfo)) continue;
            fieldInfo.setNeedSerializer(true);
            FieldVisitor fw = clsWriter.visitField(1, fieldInfo.getName() + "_serializer", this.getDesc(ObjectSerializer.class), "", null);
            fw.visitEnd();
            List<Class> types = fieldInfo.getTypes();
            if (types.size() <= 1) continue;
            FieldVisitor fwSub = clsWriter.visitField(1, fieldInfo.getName() + "_sub_serializer", this.getDesc(ObjectSerializer[].class), "", null);
            fwSub.visitEnd();
        }
    }

    private boolean shouldHaveSerializer(FieldInfo info) {
        if (info.getFieldType() instanceof Class) {
            return this.isSimpleClass((Class)info.getFieldType());
        }
        return this.isSimpleClass(info.getClass());
    }

    private boolean isSimpleClass(Class<?> clazz) {
        return !clazz.isPrimitive() && !ClassUtils.isAssignable(clazz, Number.class) && clazz != String.class && clazz != Date.class && clazz != byte[].class && !clazz.isEnum();
    }

    private void writeInit(ClassWriter clsWriter, ASMContext ctx) {
        MethodVisitor mw = clsWriter.visitMethod(1, "<init>", this.constructMethodDesc(Void.class, new Class[0]), null, null);
        mw.visitVarInsn(25, 0);
        mw.visitMethodInsn(183, this.getType(AbstractObjectSerializer.class), "<init>", this.constructMethodDesc(Void.class, new Class[0]));
        for (int i = 0; i < ctx.fieldInfoList.size(); ++i) {
            FieldInfo info = ctx.fieldInfoList.get(i);
            String fieldName = info.getName();
            Class<?> clazz = info.getFieldClass();
            mw.visitVarInsn(25, 0);
            mw.visitLdcInsn((Object)info.getAsName());
            mw.visitMethodInsn(182, this.getType(String.class), "length", this.constructMethodDesc(Integer.TYPE, new Class[0]));
            mw.visitInsn(4);
            mw.visitInsn(96);
            mw.visitIntInsn(188, 8);
            mw.visitFieldInsn(181, ctx.serializerClass, fieldName + "_prefix", this.getDesc(byte[].class));
            mw.visitLdcInsn((Object)info.getAsName());
            mw.visitMethodInsn(182, this.getType(String.class), "getBytes", this.constructMethodDesc(byte[].class, new Class[0]));
            mw.visitInsn(3);
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, ctx.serializerClass, fieldName + "_prefix", this.getType(byte[].class));
            mw.visitInsn(3);
            mw.visitLdcInsn((Object)info.getAsName());
            mw.visitMethodInsn(182, this.getType(String.class), "length", this.constructMethodDesc(Integer.TYPE, new Class[0]));
            mw.visitMethodInsn(184, this.getType(System.class), "arraycopy", this.constructMethodDesc(Void.class, Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE));
            if (info.getBsonType() != null) {
                mw.visitVarInsn(25, 0);
                mw.visitLdcInsn((Object)info.getBsonType());
                mw.visitFieldInsn(181, ctx.serializerClass, fieldName + "_bson", this.getDesc(Byte.TYPE));
            }
            if (!this.shouldHaveSerializer(info)) continue;
            mw.visitVarInsn(25, 0);
            mw.visitLdcInsn((Object)Type.getType(info.getFieldClass()));
            mw.visitMethodInsn(184, this.getType(ASMSerializerFactory.class), "getSerializer", this.constructMethodDesc(ObjectSerializer.class, Class.class));
            mw.visitFieldInsn(181, ctx.serializerClass, fieldName + "_serializer", this.getDesc(ObjectSerializer.class));
            List<Class> types = info.getTypes();
            if (types.size() <= 1) continue;
            mw.visitVarInsn(25, 0);
            mw.visitIntInsn(16, types.size() - 1);
            mw.visitTypeInsn(189, this.getType(ObjectSerializer.class));
            mw.visitFieldInsn(181, ctx.serializerClass, fieldName + "_sub_serializer", this.getDesc(ObjectSerializer[].class));
            for (int j = 1; j < types.size(); ++j) {
                Class subType;
                Class subClass = subType = types.get(j);
                mw.visitVarInsn(25, 0);
                mw.visitFieldInsn(180, ctx.serializerClass, fieldName + "_sub_serializer", this.getDesc(ObjectSerializer[].class));
                mw.visitIntInsn(16, j - 1);
                if (subClass.isPrimitive()) {
                    if (subClass == Boolean.TYPE) {
                        mw.visitFieldInsn(178, this.getType(Boolean.class), "TYPE", this.getDesc(Class.class));
                    } else if (subClass == Integer.TYPE) {
                        mw.visitFieldInsn(178, this.getType(Integer.class), "TYPE", this.getDesc(Class.class));
                    } else if (subClass == Long.TYPE) {
                        mw.visitFieldInsn(178, this.getType(Long.class), "TYPE", this.getDesc(Class.class));
                    } else if (subClass == Float.TYPE) {
                        mw.visitFieldInsn(178, this.getType(Float.class), "TYPE", this.getDesc(Class.class));
                    } else if (subClass == Double.TYPE) {
                        mw.visitFieldInsn(178, this.getType(Double.class), "TYPE", this.getDesc(Class.class));
                    }
                } else {
                    mw.visitLdcInsn((Object)Type.getType((Class)subClass));
                }
                mw.visitMethodInsn(184, this.getType(ASMSerializerFactory.class), "getSerializer", this.constructMethodDesc(ObjectSerializer.class, Class.class));
                mw.visitInsn(83);
            }
        }
        mw.visitInsn(177);
        mw.visitMaxs(0, 0);
        mw.visitEnd();
    }

    private void writeSerialize(ClassWriter clsWriter, ASMContext ctx) {
        int i;
        MethodVisitor mw = clsWriter.visitMethod(1, "serialize", this.constructMethodDesc(Void.class, BSONWriter.class, Object.class, ObjectSerializer[].class, Integer.TYPE), null, null);
        mw.visitVarInsn(25, 2);
        mw.visitTypeInsn(192, this.getType(ctx.baseClass));
        mw.visitVarInsn(58, 5);
        List<FieldInfo> fieldInfoList = ctx.fieldInfoList;
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(185, this.getType(BSONWriter.class), "beginObject", this.constructMethodDesc(Void.class, new Class[0]));
        Label[] labels = new Label[fieldInfoList.size()];
        for (i = 0; i < labels.length; ++i) {
            labels[i] = new Label();
        }
        i = 0;
        for (FieldInfo fieldInfo : fieldInfoList) {
            String getter = null;
            Class<?> fieldClass = fieldInfo.getFieldClass();
            if (fieldClass.isArray() && fieldClass.getComponentType() != Byte.TYPE) {
                fieldClass = Array.newInstance(fieldInfo.getTypes().get(1), 0).getClass();
            }
            if (!fieldInfo.isPublic()) {
                try {
                    PropertyDescriptor descripter = new PropertyDescriptor(fieldInfo.getName(), ctx.baseClass);
                    getter = descripter.getReadMethod().getName();
                }
                catch (IntrospectionException e) {
                    throw new SerializeException.ASMWrapperException("can't find getter method for field" + fieldInfo.getName(), e);
                }
            }
            if (!fieldInfo.getFieldClass().isPrimitive()) {
                mw.visitVarInsn(25, 5);
                if (!fieldInfo.isPublic()) {
                    mw.visitMethodInsn(182, this.getType(ctx.baseClass), getter, this.constructMethodDesc(fieldClass, new Class[0]));
                } else {
                    mw.visitFieldInsn(180, this.getType(ctx.baseClass), fieldInfo.getName(), this.getDesc(fieldClass));
                }
                mw.visitJumpInsn(198, labels[i]);
            }
            mw.visitVarInsn(25, 1);
            if (fieldInfo.getBsonType() != null) {
                mw.visitVarInsn(25, 0);
                mw.visitFieldInsn(180, ctx.serializerClass, fieldInfo.getName() + "_bson", this.getDesc(Byte.TYPE));
            } else {
                mw.visitVarInsn(25, 5);
                if (!fieldInfo.isPublic()) {
                    mw.visitMethodInsn(182, this.getType(ctx.baseClass), getter, this.constructMethodDesc(fieldClass, new Class[0]));
                } else {
                    mw.visitFieldInsn(180, this.getType(ctx.baseClass), fieldInfo.getName(), this.getDesc(fieldInfo.getFieldClass()));
                }
                mw.visitMethodInsn(184, this.getType(AbstractObjectSerializer.class), "getUnknownBsonSuffix", this.constructMethodDesc(Byte.TYPE, Object.class));
            }
            mw.visitMethodInsn(185, this.getType(BSONWriter.class), "write", this.constructMethodDesc(Void.class, Byte.TYPE));
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, ctx.serializerClass, fieldInfo.getName() + "_prefix", this.getDesc(byte[].class));
            mw.visitMethodInsn(185, this.getType(BSONWriter.class), "writeBytes", this.constructMethodDesc(Void.class, byte[].class));
            if (fieldInfo.isNeedSerializer()) {
                mw.visitVarInsn(25, 0);
                mw.visitFieldInsn(180, ctx.serializerClass, fieldInfo.getName() + "_serializer", this.getDesc(ObjectSerializer.class));
                mw.visitVarInsn(25, 1);
                mw.visitVarInsn(25, 5);
                if (!fieldInfo.isPublic()) {
                    mw.visitMethodInsn(182, this.getType(ctx.baseClass), getter, this.constructMethodDesc(fieldClass, new Class[0]));
                } else {
                    mw.visitFieldInsn(180, this.getType(ctx.baseClass), fieldInfo.getName(), this.getDesc(fieldInfo.getFieldClass()));
                }
                if (fieldInfo.getTypes().size() <= 1) {
                    mw.visitInsn(1);
                } else {
                    mw.visitVarInsn(25, 0);
                    mw.visitFieldInsn(180, ctx.serializerClass, fieldInfo.getName() + "_sub_serializer", this.getDesc(ObjectSerializer[].class));
                }
                mw.visitInsn(3);
                mw.visitMethodInsn(185, this.getType(ObjectSerializer.class), "serialize", this.constructMethodDesc(Void.class, BSONWriter.class, Object.class, ObjectSerializer[].class, Integer.TYPE));
            } else {
                mw.visitVarInsn(25, 1);
                mw.visitVarInsn(25, 5);
                if (!fieldInfo.isPublic()) {
                    mw.visitMethodInsn(182, this.getType(ctx.baseClass), getter, this.constructMethodDesc(fieldClass, new Class[0]));
                } else {
                    mw.visitFieldInsn(180, this.getType(ctx.baseClass), fieldInfo.getName(), this.getDesc(fieldInfo.getFieldClass()));
                }
                if (fieldClass.isEnum()) {
                    mw.visitMethodInsn(182, this.getType(fieldClass), "toString", this.constructMethodDesc(String.class, new Class[0]));
                    mw.visitMethodInsn(185, this.getType(BSONWriter.class), "writeValue", this.constructMethodDesc(Void.class, String.class));
                } else {
                    mw.visitMethodInsn(185, this.getType(BSONWriter.class), "writeValue", this.constructMethodDesc(Void.class, fieldClass));
                }
            }
            if (!fieldInfo.getFieldClass().isPrimitive()) {
                mw.visitLabel(labels[i]);
            }
            ++i;
        }
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(185, this.getType(BSONWriter.class), "endObject", this.constructMethodDesc(Void.class, new Class[0]));
        mw.visitInsn(177);
        mw.visitMaxs(1, 0);
        mw.visitEnd();
    }

    private void writeGetSerializedClass(ClassWriter clsWriter, Class<?> clazz) {
        MethodVisitor mw = clsWriter.visitMethod(1, "getSerializedClass", this.constructMethodDesc(Class.class, new Class[0]), null, null);
        mw.visitLdcInsn((Object)Type.getType(clazz));
        mw.visitInsn(176);
        mw.visitMaxs(0, 0);
        mw.visitEnd();
    }

    private void writeDeserialize(ClassWriter clsWriter, ASMContext ctx) {
        int i;
        MethodVisitor mw = clsWriter.visitMethod(1, "deserialize", this.constructMethodDesc(Object.class, BSONScanner.class, ObjectSerializer[].class, Integer.TYPE), null, null);
        mw.visitVarInsn(25, 1);
        mw.visitInsn(7);
        mw.visitMethodInsn(185, this.getType(BSONScanner.class), "skip", this.constructMethodDesc(Void.class, Integer.TYPE));
        mw.visitTypeInsn(187, this.getType(ctx.baseClass));
        mw.visitInsn(89);
        mw.visitMethodInsn(183, this.getType(ctx.baseClass), "<init>", this.constructMethodDesc(Void.class, new Class[0]));
        mw.visitVarInsn(58, ctx.var("temp"));
        for (int i2 = 0; i2 < ctx.fieldInfoList.size(); ++i2) {
            mw.visitInsn(3);
            mw.visitVarInsn(54, ctx.var(ctx.fieldInfoList.get(i2).getName() + "_set"));
        }
        Label _while_clause = new Label();
        Label _loop = new Label();
        Label[] fieldLabel = new Label[ctx.fieldInfoList.size()];
        for (i = 0; i < fieldLabel.length; ++i) {
            fieldLabel[i] = new Label();
        }
        mw.visitJumpInsn(167, _while_clause);
        mw.visitLabel(_loop);
        for (i = 0; i < ctx.fieldInfoList.size(); ++i) {
            FieldInfo info = ctx.fieldInfoList.get(i);
            mw.visitVarInsn(21, ctx.var(info.getName() + "_set"));
            mw.visitJumpInsn(154, fieldLabel[i]);
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, ctx.serializerClass, info.getName() + "_prefix", this.getDesc(byte[].class));
            mw.visitMethodInsn(185, this.getType(BSONScanner.class), "match", this.constructMethodDesc(Boolean.TYPE, byte[].class));
            mw.visitJumpInsn(153, fieldLabel[i]);
            this.writePutMethod(mw, info, ctx);
            mw.visitInsn(4);
            mw.visitVarInsn(54, ctx.var(info.getName() + "_set"));
            mw.visitJumpInsn(167, _while_clause);
            mw.visitLabel(fieldLabel[i]);
        }
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(185, this.getType(BSONScanner.class), "skipField", this.constructMethodDesc(Void.class, new Class[0]));
        mw.visitLabel(_while_clause);
        mw.visitVarInsn(25, 1);
        mw.visitMethodInsn(185, this.getType(BSONScanner.class), "readType", this.constructMethodDesc(Byte.TYPE, new Class[0]));
        mw.visitJumpInsn(154, _loop);
        mw.visitVarInsn(25, ctx.var("temp"));
        mw.visitMaxs(1, ctx.fieldInfoList.size());
        mw.visitEnd();
        mw.visitInsn(176);
    }

    private void writePutMethod(MethodVisitor mw, FieldInfo info, ASMContext ctx) {
        mw.visitVarInsn(25, ctx.var("temp"));
        Class fieldClass = info.getFieldType() instanceof Class ? (Class)info.getFieldType() : info.getFieldClass();
        String fieldName = info.getName();
        if (fieldClass == Integer.TYPE || fieldClass == Integer.class) {
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(185, this.getType(BSONScanner.class), "readBSONInt", this.constructMethodDesc(Integer.TYPE, new Class[0]));
            if (!fieldClass.isPrimitive()) {
                mw.visitMethodInsn(184, this.getType(Integer.class), "valueOf", this.constructMethodDesc(Integer.class, Integer.TYPE));
            }
        } else if (fieldClass == Long.TYPE || fieldClass == Long.class) {
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(185, this.getType(BSONScanner.class), "readBSONLong", this.constructMethodDesc(Long.TYPE, new Class[0]));
            if (!fieldClass.isPrimitive()) {
                mw.visitMethodInsn(184, this.getType(Long.class), "valueOf", this.constructMethodDesc(Long.class, Long.TYPE));
            }
        } else if (fieldClass == Double.TYPE || fieldClass == Double.class) {
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(185, this.getType(BSONScanner.class), "readBSONDouble", this.constructMethodDesc(Double.TYPE, new Class[0]));
            if (!fieldClass.isPrimitive()) {
                mw.visitMethodInsn(184, this.getType(Double.class), "valueOf", this.constructMethodDesc(Double.class, Double.TYPE));
            }
        } else if (fieldClass == Float.TYPE || fieldClass == Float.class) {
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(185, this.getType(BSONScanner.class), "readBSONDouble", this.constructMethodDesc(Double.TYPE, new Class[0]));
            mw.visitInsn(144);
            if (!fieldClass.isPrimitive()) {
                mw.visitMethodInsn(184, this.getType(Float.class), "valueOf", this.constructMethodDesc(Float.class, Float.TYPE));
            }
        } else if (fieldClass == String.class) {
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(185, this.getType(BSONScanner.class), "readBSONString", this.constructMethodDesc(String.class, new Class[0]));
        } else if (fieldClass.isEnum()) {
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(185, this.getType(BSONScanner.class), "readString", this.constructMethodDesc(String.class, new Class[0]));
            mw.visitMethodInsn(184, this.getType(fieldClass), "valueOf", this.constructMethodDesc(fieldClass, String.class));
        } else if (fieldClass == Date.class) {
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(185, this.getType(BSONScanner.class), "readBSONDate", this.constructMethodDesc(Date.class, new Class[0]));
        } else if (fieldClass == Boolean.TYPE || fieldClass == Boolean.class) {
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(185, this.getType(BSONScanner.class), "readBSONBoolean", this.constructMethodDesc(Boolean.TYPE, new Class[0]));
            if (!fieldClass.isPrimitive()) {
                mw.visitMethodInsn(184, this.getType(Boolean.class), "valueOf", this.constructMethodDesc(Boolean.class, Boolean.TYPE));
            }
        } else if (fieldClass == BigDecimal.class) {
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(185, this.getType(BSONScanner.class), "readBSONBigDecimal", this.constructMethodDesc(BigDecimal.class, new Class[0]));
        } else if (fieldClass == Byte.TYPE || fieldClass == Byte.class) {
            mw.visitVarInsn(25, 1);
            mw.visitMethodInsn(185, this.getType(BSONScanner.class), "readBSONByte", this.constructMethodDesc(Byte.TYPE, new Class[0]));
            if (!fieldClass.isPrimitive()) {
                mw.visitMethodInsn(184, this.getType(Byte.class), "valueOf", this.constructMethodDesc(Byte.class, Byte.TYPE));
            }
        } else if (ClassUtils.isAssignable((Class)fieldClass, Map.class)) {
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, ctx.serializerClass, fieldName + "_serializer", this.getDesc(ObjectSerializer.class));
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, ctx.serializerClass, fieldName + "_sub_serializer", this.getDesc(ObjectSerializer[].class));
            mw.visitInsn(3);
            mw.visitMethodInsn(185, this.getType(ObjectSerializer.class), "deserialize", this.constructMethodDesc(Object.class, BSONScanner.class, ObjectSerializer[].class, Integer.TYPE));
            mw.visitTypeInsn(192, this.getType(fieldClass));
        } else if (ClassUtils.isAssignable((Class)fieldClass, List.class)) {
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, ctx.serializerClass, fieldName + "_serializer", this.getDesc(ObjectSerializer.class));
            mw.visitVarInsn(25, 1);
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, ctx.serializerClass, fieldName + "_sub_serializer", this.getDesc(ObjectSerializer[].class));
            mw.visitInsn(3);
            mw.visitMethodInsn(185, this.getType(ObjectSerializer.class), "deserialize", this.constructMethodDesc(Object.class, BSONScanner.class, ObjectSerializer[].class, Integer.TYPE));
            mw.visitTypeInsn(192, this.getType(fieldClass));
        } else if (fieldClass.isArray()) {
            if (fieldClass.getComponentType() == Byte.TYPE) {
                mw.visitVarInsn(25, 1);
                mw.visitMethodInsn(185, this.getType(BSONScanner.class), "readBSONBinary", this.constructMethodDesc(byte[].class, new Class[0]));
            } else {
                mw.visitVarInsn(25, 0);
                mw.visitFieldInsn(180, ctx.serializerClass, fieldName + "_serializer", this.getDesc(ObjectSerializer.class));
                mw.visitVarInsn(25, 1);
                mw.visitVarInsn(25, 0);
                mw.visitFieldInsn(180, ctx.serializerClass, fieldName + "_sub_serializer", this.getDesc(ObjectSerializer[].class));
                mw.visitInsn(3);
                mw.visitMethodInsn(185, this.getType(ObjectSerializer.class), "deserialize", this.constructMethodDesc(Object.class, BSONScanner.class, ObjectSerializer[].class, Integer.TYPE));
                mw.visitTypeInsn(192, this.getType(Array.newInstance(info.getTypes().get(1), 0).getClass()));
            }
        } else {
            mw.visitVarInsn(25, 0);
            mw.visitFieldInsn(180, ctx.serializerClass, fieldName + "_serializer", this.getDesc(ObjectSerializer.class));
            mw.visitVarInsn(25, 1);
            mw.visitInsn(1);
            mw.visitInsn(3);
            mw.visitMethodInsn(185, this.getType(ObjectSerializer.class), "deserialize", this.constructMethodDesc(Object.class, BSONScanner.class, ObjectSerializer[].class, Integer.TYPE));
            mw.visitTypeInsn(192, this.getType(fieldClass));
        }
        if (!info.isPublic()) {
            try {
                String setterName = null;
                String setterDesc = null;
                PropertyDescriptor desc = new PropertyDescriptor(info.getName(), ctx.baseClass);
                Method setter = desc.getWriteMethod();
                setterName = setter.getName();
                setterDesc = this.constructMethodDesc(setter.getReturnType(), setter.getParameterTypes());
                mw.visitMethodInsn(182, this.getType(ctx.baseClass), setterName, setterDesc);
            }
            catch (IntrospectionException e) {
                throw new SerializeException.ASMWrapperException("can't find setter method for field " + info.getAsName(), e);
            }
        } else {
            Class fieldRealClass = info.getFieldType() instanceof ParameterizedType ? (Class)((ParameterizedType)info.getFieldType()).getRawType() : (Class)info.getFieldType();
            mw.visitFieldInsn(181, this.getType(ctx.baseClass), info.getName(), this.getDesc(fieldRealClass));
        }
    }
}

